/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;

class CodeStyleCachingUtil {
    private static final Logger LOG = Logger.getInstance(CodeStyleCachingUtil.class);

    CodeStyleCachingUtil() {
    }

    @NotNull
    static CodeStyleSettings getCachedCodeStyle(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleCachingUtil.$$$reportNull$$$0(0);
        }
        CachedCodeStyleHolder cachedCodeStyleHolder = (CachedCodeStyleHolder)CachedValuesManager.getCachedValue(file, () -> CodeStyleCachingUtil.createHolder(file).getCachedResult());
        CodeStyleSettings codeStyleSettings = cachedCodeStyleHolder.getCachedSettings();
        if (codeStyleSettings == null) {
            CodeStyleCachingUtil.$$$reportNull$$$0(1);
        }
        return codeStyleSettings;
    }

    private static CachedCodeStyleHolder createHolder(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleCachingUtil.$$$reportNull$$$0(2);
        }
        CachedCodeStyleHolder holder = new CachedCodeStyleHolder();
        holder.compute(file);
        if (LOG.isDebugEnabled()) {
            CodeStyleCachingUtil.logCached(file, holder);
        }
        return holder;
    }

    private static void logCached(@NotNull PsiFile file, @NotNull CachedCodeStyleHolder holder) {
        if (file == null) {
            CodeStyleCachingUtil.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            CodeStyleCachingUtil.$$$reportNull$$$0(4);
        }
        CodeStyleSettings settings = holder.getCachedSettings();
        LOG.debug(String.format("File: %s (%s), cached: %s, tracker: %d", file.getName(), Integer.toHexString(file.hashCode()), settings, settings.getModificationTracker().getModificationCount()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleCachingUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleCachingUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedCodeStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCodeStyle";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHolder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logCached";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CachedCodeStyleHolder {
        @NotNull
        private CodeStyleSettings myCachedSettings = CodeStyle.getDefaultSettings();

        CachedCodeStyleHolder() {
        }

        private void compute(@NotNull PsiFile file) {
            CodeStyleSettingsManager settingsManager;
            CodeStyleSettings currSettings;
            if (file == null) {
                CachedCodeStyleHolder.$$$reportNull$$$0(0);
            }
            if ((currSettings = (this.myCachedSettings = (settingsManager = CodeStyleSettingsManager.getInstance(file.getProject())).getCurrentSettings())) != settingsManager.getTemporarySettings()) {
                TransientCodeStyleSettings modifiableSettings = new TransientCodeStyleSettings(file, currSettings);
                for (CodeStyleSettingsModifier modifier : CodeStyleSettingsModifier.EP_NAME.getExtensionList()) {
                    if (!modifier.modifySettings(modifiableSettings, file)) continue;
                    LOG.debug("Modifier: " + modifier.getClass().getName());
                    modifiableSettings.setModifier(modifier);
                    currSettings = modifiableSettings;
                    break;
                }
            }
            this.myCachedSettings = currSettings;
        }

        @NotNull
        Object[] getDependencies() {
            Object[] objectArray;
            if (this.myCachedSettings instanceof TransientCodeStyleSettings) {
                objectArray = ((TransientCodeStyleSettings)this.myCachedSettings).getDependencies().toArray();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.myCachedSettings.getModificationTracker();
            }
            if (objectArray == null) {
                CachedCodeStyleHolder.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @NotNull
        CodeStyleSettings getCachedSettings() {
            CodeStyleSettings codeStyleSettings = this.myCachedSettings;
            if (codeStyleSettings == null) {
                CachedCodeStyleHolder.$$$reportNull$$$0(2);
            }
            return codeStyleSettings;
        }

        CachedValueProvider.Result<CachedCodeStyleHolder> getCachedResult() {
            return new CachedValueProvider.Result<CachedCodeStyleHolder>(this, this.getDependencies());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/CodeStyleCachingUtil$CachedCodeStyleHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/CodeStyleCachingUtil$CachedCodeStyleHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCachedSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

