/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.constant;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;

public class JSConstantExpressionIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        ConstantExpressionPredicate constantExpressionPredicate = new ConstantExpressionPredicate();
        if (constantExpressionPredicate == null) {
            JSConstantExpressionIntention.$$$reportNull$$$0(0);
        }
        return constantExpressionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSConstantExpressionIntention.$$$reportNull$$$0(1);
        }
        JSExpression expression = (JSExpression)element;
        Object value = ExpressionUtil.computeConstantExpression((JSExpression)expression);
        String newExpression = JSConstantExpressionIntention.formatValue(value, expression);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)expression, (String)newExpression);
    }

    public static String formatValue(Object value, JSExpression expression) {
        if (value instanceof String) {
            boolean shouldUseTemplateString = JSConstantExpressionIntention.shouldUseTemplateString(expression);
            String quote = shouldUseTemplateString ? "`" : JSCodeStyleSettings.getQuote((PsiElement)expression);
            String escapedValue = shouldUseTemplateString ? (String)value : JSConstantExpressionIntention.escapeStringCharacters((String)value, quote);
            return quote + escapedValue + quote;
        }
        if (value instanceof BigInteger && DialectDetector.hasFeature((PsiElement)expression, (JSLanguageFeature)JSLanguageFeature.BIG_INT)) {
            return value + "n";
        }
        return String.valueOf(value);
    }

    @NotNull
    private static String escapeStringCharacters(String value, String quote) {
        StringBuilder buffer = new StringBuilder(value.length());
        String string = StringUtil.escapeStringCharacters((int)value.length(), (String)value, (String)quote, (boolean)false, (StringBuilder)buffer).toString();
        if (string == null) {
            JSConstantExpressionIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean shouldUseTemplateString(@NotNull JSExpression expression) {
        if (expression == null) {
            JSConstantExpressionIntention.$$$reportNull$$$0(3);
        }
        if (!DialectDetector.hasFeature((PsiElement)expression, (JSLanguageFeature)JSLanguageFeature.STRING_TEMPLATES)) {
            return false;
        }
        Ref result = new Ref();
        PsiTreeUtil.processElements((PsiElement)expression, element -> {
            if (!result.isNull()) {
                return false;
            }
            if (element instanceof JSStringTemplateExpression) {
                result.set((Object)true);
            }
            return true;
        });
        return Boolean.TRUE == result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseTemplateString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstantExpressionPredicate
    implements JSElementPredicate {
        private ConstantExpressionPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ConstantExpressionPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSExpression)) {
                return false;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            JSExpression expression = (JSExpression)element;
            if (element instanceof JSLiteralExpression || element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() != null || expression instanceof JSCallExpression) {
                return false;
            }
            if (!ExpressionUtil.isConstantExpression((JSExpression)expression, (boolean)false)) {
                return false;
            }
            if (ExpressionUtil.computeConstantExpression((JSExpression)expression) == null) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSExpression)) {
                return true;
            }
            return !ExpressionUtil.isConstantExpression((JSExpression)((JSExpression)parent), (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention$ConstantExpressionPredicate", "satisfiedBy"));
        }
    }
}

