/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import gnu.trove.Equality;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquivalenceChecker {
    private static final int THIS_EXPRESSION = 0;
    private static final int LITERAL_EXPRESSION = 1;
    private static final int CLASS_OBJECT_EXPRESSION = 2;
    private static final int REFERENCE_EXPRESSION = 3;
    private static final int SUPER_EXPRESSION = 4;
    private static final int CALL_EXPRESSION = 5;
    private static final int NEW_EXPRESSION = 6;
    private static final int ARRAY_LITERAL_EXPRESSION = 7;
    private static final int PREFIX_EXPRESSION = 10;
    private static final int POSTFIX_EXPRESSION = 11;
    private static final int BINARY_EXPRESSION = 12;
    private static final int CONDITIONAL_EXPRESSION = 13;
    private static final int ASSIGNMENT_EXPRESSION = 14;
    private static final int INDEXED_PROPERTY_ACCESS_EXPRESSION = 15;
    private static final int OBJECT_LITERAL_EXPRESSION = 16;
    private static final int FUNCTION_EXPRESSION = 17;
    private static final int DEFINITION_EXPRESSION = 18;
    private static final int BLOCK_STATEMENT = 1;
    private static final int BREAK_STATEMENT = 2;
    private static final int CONTINUE_STATEMENT = 3;
    private static final int VAR_STATEMENT = 4;
    private static final int DO_WHILE_STATEMENT = 5;
    private static final int EMPTY_STATEMENT = 6;
    private static final int EXPRESSION_STATEMENT = 8;
    private static final int FOR_STATEMENT = 9;
    private static final int IF_STATEMENT = 10;
    private static final int LABELED_STATEMENT = 11;
    private static final int RETURN_STATEMENT = 12;
    private static final int SWITCH_STATEMENT = 14;
    private static final int THROW_STATEMENT = 16;
    private static final int TRY_STATEMENT = 17;
    private static final int WHILE_STATEMENT = 18;
    private static final int FOR_EACH_STATEMENT = 19;
    private static final int WITH_STATEMENT = 20;
    private static final Equality<JSExpression> EXPRESSION_COMPARATOR = (o1, o2) -> EquivalenceChecker.expressionsAreEquivalent(o1, o2);
    private static final Equality<JSInitializerOwner> INITIALIZER_OWNER_COMPARATOR = new Equality<JSInitializerOwner>(){

        public boolean equals(JSInitializerOwner o1, JSInitializerOwner o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (o1 instanceof JSParameter) {
                return o2 instanceof JSParameter && EquivalenceChecker.parametersAreEquivalent((JSParameter)o1, (JSParameter)o2);
            }
            if (o1 instanceof JSVariable) {
                return o2 instanceof JSVariable && EquivalenceChecker.variablesAreEquivalent((JSVariable)o1, (JSVariable)o2);
            }
            if (o1 instanceof JSDestructuringParameter) {
                if (!(o2 instanceof JSDestructuringParameter)) {
                    return false;
                }
                JSDestructuringParameter p1 = (JSDestructuringParameter)o1;
                JSDestructuringParameter p2 = (JSDestructuringParameter)o2;
                if (p1.isOptional() != p2.isOptional()) {
                    return false;
                }
                if (p1.isRest() != p2.isRest()) {
                    return false;
                }
                return this.destructuringElementsAreEquivalent((JSDestructuringElement)p1, (JSDestructuringElement)p2);
            }
            if (o1 instanceof JSDestructuringElement) {
                return o2 instanceof JSDestructuringElement && this.destructuringElementsAreEquivalent((JSDestructuringElement)o1, (JSDestructuringElement)o2);
            }
            return false;
        }

        private boolean destructuringElementsAreEquivalent(@NotNull JSDestructuringElement e1, @NotNull JSDestructuringElement e2) {
            if (e1 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (e2 == null) {
                1.$$$reportNull$$$0(1);
            }
            JSDestructuringContainer t1 = e1.getTarget();
            JSDestructuringContainer t2 = e2.getTarget();
            if (t1 instanceof JSDestructuringArray && t2 instanceof JSDestructuringArray) {
                JSDestructuringArray array1 = (JSDestructuringArray)t1;
                JSDestructuringArray array2 = (JSDestructuringArray)t2;
                return ArrayUtil.equals((Object[])array1.getElements(), (Object[])array2.getElements(), (Equality)INITIALIZER_OWNER_COMPARATOR) && EquivalenceChecker.arrayRestElementsAreEquivalent(array1.getRestElement(), array2.getRestElement());
            }
            if (t1 instanceof JSDestructuringObject) {
                return t2 instanceof JSDestructuringObject && ArrayUtil.equals((Object[])((JSDestructuringObject)t1).getProperties(), (Object[])((JSDestructuringObject)t2).getProperties(), (Equality)DESTRUCTURING_PROPERTY_COMPARATOR);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e2";
                    break;
                }
            }
            objectArray[1] = "com/sixrr/inspectjs/utils/EquivalenceChecker$1";
            objectArray[2] = "destructuringElementsAreEquivalent";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final Equality<JSDestructuringProperty> DESTRUCTURING_PROPERTY_COMPARATOR = (o1, o2) -> {
        if (!StringUtil.equals((CharSequence)o1.getName(), (CharSequence)o2.getName())) {
            return false;
        }
        return INITIALIZER_OWNER_COMPARATOR.equals((Object)o1.getDestructuringElement(), (Object)o2.getDestructuringElement());
    };

    private EquivalenceChecker() {
    }

    public static boolean statementsAreEquivalent(@Nullable JSSourceElement exp1, @Nullable JSSourceElement exp2) {
        int type2;
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 == null || exp2 == null) {
            return false;
        }
        int type1 = EquivalenceChecker.getStatementType(exp1);
        if (type1 != (type2 = EquivalenceChecker.getStatementType(exp2))) {
            return false;
        }
        switch (type1) {
            case 1: {
                return EquivalenceChecker.blockStatementsAreEquivalent((JSBlockStatement)exp1, (JSBlockStatement)exp2);
            }
            case 2: {
                return EquivalenceChecker.breakStatementsAreEquivalent((JSBreakStatement)exp1, (JSBreakStatement)exp2);
            }
            case 3: {
                return EquivalenceChecker.continueStatementsAreEquivalent((JSContinueStatement)exp1, (JSContinueStatement)exp2);
            }
            case 4: {
                return EquivalenceChecker.varStatementsAreEquivalent((JSVarStatement)exp1, (JSVarStatement)exp2);
            }
            case 5: {
                return EquivalenceChecker.doWhileStatementsAreEquivalent((JSDoWhileStatement)exp1, (JSDoWhileStatement)exp2);
            }
            case 6: {
                return true;
            }
            case 8: {
                return EquivalenceChecker.expressionStatementsAreEquivalent((JSExpressionStatement)exp1, (JSExpressionStatement)exp2);
            }
            case 9: {
                return EquivalenceChecker.forStatementsAreEquivalent((JSForStatement)exp1, (JSForStatement)exp2);
            }
            case 19: {
                return EquivalenceChecker.forInStatementsAreEquivalent((JSForInStatement)exp1, (JSForInStatement)exp2);
            }
            case 10: {
                return EquivalenceChecker.ifStatementsAreEquivalent((JSIfStatement)exp1, (JSIfStatement)exp2);
            }
            case 11: {
                return EquivalenceChecker.labeledStatementsAreEquivalent((JSLabeledStatement)exp1, (JSLabeledStatement)exp2);
            }
            case 12: {
                return EquivalenceChecker.returnStatementsAreEquivalent((JSReturnStatement)exp1, (JSReturnStatement)exp2);
            }
            case 14: {
                return EquivalenceChecker.switchStatementsAreEquivalent((JSSwitchStatement)exp1, (JSSwitchStatement)exp2);
            }
            case 16: {
                return EquivalenceChecker.throwStatementsAreEquivalent((JSThrowStatement)exp1, (JSThrowStatement)exp2);
            }
            case 17: {
                return EquivalenceChecker.tryStatementsAreEquivalent((JSTryStatement)exp1, (JSTryStatement)exp2);
            }
            case 18: {
                return EquivalenceChecker.whileStatementsAreEquivalent((JSWhileStatement)exp1, (JSWhileStatement)exp2);
            }
            case 20: {
                return EquivalenceChecker.withStatementsAreEquivalent((JSWithStatement)exp1, (JSWithStatement)exp2);
            }
        }
        return false;
    }

    private static boolean withStatementsAreEquivalent(JSWithStatement statement1, JSWithStatement statement2) {
        JSExpression expression2;
        JSExpression expression1 = statement1.getExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent(expression1, expression2 = statement2.getExpression())) {
            return false;
        }
        JSStatement body1 = statement1.getStatement();
        JSStatement body2 = statement2.getStatement();
        return EquivalenceChecker.statementsAreEquivalent((JSSourceElement)body1, (JSSourceElement)body2);
    }

    private static boolean varStatementsAreEquivalent(@NotNull JSVarStatement statement1, @NotNull JSVarStatement statement2) {
        JSVariable[] variables2;
        JSVariable[] variables1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(1);
        }
        if ((variables1 = statement1.getVariables()).length != (variables2 = statement2.getVariables()).length) {
            return false;
        }
        for (int i = 0; i < variables2.length; ++i) {
            if (EquivalenceChecker.variablesAreEquivalent(variables1[i], variables2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean variablesAreEquivalent(@Nullable JSVariable var1, @Nullable JSVariable var2) {
        JSType type2;
        JSExpression initializer2;
        if (var1 == null || var2 == null) {
            return var2 == var1;
        }
        JSExpression initializer1 = var1.getInitializer();
        if (!EquivalenceChecker.expressionsAreEquivalent(initializer1, initializer2 = var2.getInitializer())) {
            return false;
        }
        JSType type1 = var1.getJSType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = var2.getJSType())) {
            return false;
        }
        String name1 = var1.getName();
        String name2 = var2.getName();
        if (name1 == null) {
            return name2 == null;
        }
        return name1.equals(name2);
    }

    private static boolean tryStatementsAreEquivalent(@NotNull JSTryStatement statement1, @NotNull JSTryStatement statement2) {
        JSStatement finallyBlock2;
        JSStatement tryBlock2;
        JSStatement tryBlock1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(2);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(3);
        }
        if (!EquivalenceChecker.statementsAreEquivalent((JSSourceElement)(tryBlock1 = statement1.getStatement()), (JSSourceElement)(tryBlock2 = statement2.getStatement()))) {
            return false;
        }
        JSStatement finallyBlock1 = statement1.getFinallyStatement();
        if (!EquivalenceChecker.statementsAreEquivalent((JSSourceElement)finallyBlock1, (JSSourceElement)(finallyBlock2 = statement2.getFinallyStatement()))) {
            return false;
        }
        JSCatchBlock catchBlock1 = statement1.getCatchBlock();
        JSCatchBlock catchBlock2 = statement2.getCatchBlock();
        if (catchBlock1 == null) {
            return catchBlock2 == null;
        }
        if (catchBlock2 == null) {
            return false;
        }
        if (!INITIALIZER_OWNER_COMPARATOR.equals((Object)catchBlock1.getInitializerOwner(), (Object)catchBlock2.getInitializerOwner())) {
            return false;
        }
        JSStatement catchStatement1 = catchBlock1.getStatement();
        JSStatement catchStatement2 = catchBlock2.getStatement();
        return EquivalenceChecker.statementsAreEquivalent((JSSourceElement)catchStatement1, (JSSourceElement)catchStatement2);
    }

    private static boolean parametersAreEquivalent(@NotNull JSParameter parameter1, @NotNull JSParameter parameter2) {
        JSType type2;
        JSType type1;
        if (parameter1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(4);
        }
        if (parameter2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(5);
        }
        if (!EquivalenceChecker.typesAreEquivalent(type1 = parameter1.getJSType(), type2 = parameter2.getJSType())) {
            return false;
        }
        String name1 = parameter1.getName();
        String name2 = parameter2.getName();
        if (name1 == null) {
            return name2 == null;
        }
        return name1.equals(name2);
    }

    private static boolean typesAreEquivalent(@Nullable JSType type1, @Nullable JSType type2) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        return type1.equals(type2);
    }

    private static boolean whileStatementsAreEquivalent(@NotNull JSWhileStatement statement1, @NotNull JSWhileStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(6);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(7);
        }
        JSExpression condition1 = statement1.getCondition();
        JSExpression condition2 = statement2.getCondition();
        JSStatement body1 = statement1.getBody();
        JSStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent((JSSourceElement)body1, (JSSourceElement)body2);
    }

    private static boolean forStatementsAreEquivalent(@NotNull JSForStatement statement1, @NotNull JSForStatement statement2) {
        JSExpression update2;
        JSExpression initialization2;
        JSExpression condition2;
        JSExpression condition1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(8);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(9);
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(condition1 = statement1.getCondition(), condition2 = statement2.getCondition())) {
            return false;
        }
        JSExpression initialization1 = statement1.getInitialization();
        if (!EquivalenceChecker.expressionsAreEquivalent(initialization1, initialization2 = statement2.getInitialization())) {
            return false;
        }
        JSExpression update1 = statement1.getUpdate();
        if (!EquivalenceChecker.expressionsAreEquivalent(update1, update2 = statement2.getUpdate())) {
            return false;
        }
        JSStatement body1 = statement1.getBody();
        JSStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent((JSSourceElement)body1, (JSSourceElement)body2);
    }

    private static boolean forInStatementsAreEquivalent(@NotNull JSForInStatement statement1, @NotNull JSForInStatement statement2) {
        JSVarStatement parameter2;
        JSExpression value2;
        JSExpression value1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(10);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(11);
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(value1 = statement1.getCollectionExpression(), value2 = statement2.getCollectionExpression())) {
            return false;
        }
        JSVarStatement parameter1 = statement1.getDeclarationStatement();
        if (EquivalenceChecker.statementsAreEquivalent((JSSourceElement)parameter1, (JSSourceElement)(parameter2 = statement1.getDeclarationStatement()))) {
            return false;
        }
        JSStatement body1 = statement1.getBody();
        JSStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent((JSSourceElement)body1, (JSSourceElement)body2);
    }

    private static boolean switchStatementsAreEquivalent(@NotNull JSSwitchStatement statement1, @NotNull JSSwitchStatement statement2) {
        JSCaseClause[] clauses2;
        JSExpression swithcExpression2;
        JSExpression switchExpression1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(12);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(13);
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(switchExpression1 = statement1.getSwitchExpression(), swithcExpression2 = statement2.getSwitchExpression())) {
            return false;
        }
        JSCaseClause[] clauses1 = statement1.getCaseClauses();
        if (clauses1.length != (clauses2 = statement2.getCaseClauses()).length) {
            return false;
        }
        for (int i = 0; i < clauses1.length; ++i) {
            JSCaseClause clause1 = clauses1[i];
            JSCaseClause clause2 = clauses2[i];
            if (EquivalenceChecker.caseClausesAreEquivalent(clause1, clause2)) continue;
            return false;
        }
        return true;
    }

    private static boolean caseClausesAreEquivalent(JSCaseClause clause1, JSCaseClause clause2) {
        JSSourceElement[] statements2;
        JSExpression exp2;
        if (clause1.isDefault() != clause2.isDefault()) {
            return false;
        }
        JSExpression exp1 = clause1.getCaseExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent(exp1, exp2 = clause2.getCaseExpression())) {
            return false;
        }
        JSSourceElement[] statements1 = clause1.getStatementListItems();
        if (statements1.length != (statements2 = clause2.getStatementListItems()).length) {
            return false;
        }
        for (int i = 0; i < statements1.length; ++i) {
            if (EquivalenceChecker.statementsAreEquivalent(statements1[i], statements2[i])) continue;
            return false;
        }
        return false;
    }

    private static boolean doWhileStatementsAreEquivalent(@NotNull JSDoWhileStatement statement1, @NotNull JSDoWhileStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(14);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(15);
        }
        JSExpression condition1 = statement1.getCondition();
        JSExpression condition2 = statement2.getCondition();
        JSStatement body1 = statement1.getBody();
        JSStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent((JSSourceElement)body1, (JSSourceElement)body2);
    }

    private static boolean blockStatementsAreEquivalent(@NotNull JSBlockStatement statement1, @NotNull JSBlockStatement statement2) {
        JSSourceElement[] statements2;
        JSSourceElement[] statements1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(16);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(17);
        }
        if ((statements1 = statement1.getStatementListItems()).length != (statements2 = statement2.getStatementListItems()).length) {
            return false;
        }
        for (int i = 0; i < statements1.length; ++i) {
            JSSourceElement first = statements1[i];
            JSSourceElement second = statements2[i];
            if (EquivalenceChecker.statementsAreEquivalent(first, second)) continue;
            return false;
        }
        return true;
    }

    private static boolean breakStatementsAreEquivalent(@NotNull JSBreakStatement statement1, @NotNull JSBreakStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(18);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(19);
        }
        String identifier1 = statement1.getLabel();
        String identifier2 = statement2.getLabel();
        if (identifier1 == null) {
            return identifier2 == null;
        }
        if (identifier2 == null) {
            return false;
        }
        return identifier1.equals(identifier2);
    }

    private static boolean continueStatementsAreEquivalent(@NotNull JSContinueStatement statement1, @NotNull JSContinueStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(20);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(21);
        }
        String identifier1 = statement1.getLabel();
        String identifier2 = statement2.getLabel();
        if (identifier1 == null) {
            return identifier2 == null;
        }
        if (identifier2 == null) {
            return false;
        }
        return identifier1.equals(identifier2);
    }

    private static boolean labeledStatementsAreEquivalent(@NotNull JSLabeledStatement statement1, @NotNull JSLabeledStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(22);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(23);
        }
        PsiElement identifier1 = statement1.getLabelIdentifier();
        PsiElement identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return identifier2 == null;
        }
        if (identifier2 == null) {
            return false;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    private static boolean ifStatementsAreEquivalent(@NotNull JSIfStatement statement1, @NotNull JSIfStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(24);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(25);
        }
        JSExpression condition1 = statement1.getCondition();
        JSExpression condition2 = statement2.getCondition();
        JSStatement thenBranch1 = statement1.getThen();
        JSStatement thenBranch2 = statement2.getThen();
        JSStatement elseBranch1 = statement1.getElse();
        JSStatement elseBranch2 = statement2.getElse();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent((JSSourceElement)thenBranch1, (JSSourceElement)thenBranch2) && EquivalenceChecker.statementsAreEquivalent((JSSourceElement)elseBranch1, (JSSourceElement)elseBranch2);
    }

    private static boolean expressionStatementsAreEquivalent(@NotNull JSExpressionStatement statement1, @NotNull JSExpressionStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(26);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(27);
        }
        JSExpression expression1 = statement1.getExpression();
        JSExpression expression2 = statement2.getExpression();
        return EquivalenceChecker.expressionsAreEquivalent(expression1, expression2);
    }

    private static boolean returnStatementsAreEquivalent(@NotNull JSReturnStatement statement1, @NotNull JSReturnStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(28);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(29);
        }
        JSExpression returnValue1 = statement1.getExpression();
        JSExpression returnValue2 = statement2.getExpression();
        return EquivalenceChecker.expressionsAreEquivalent(returnValue1, returnValue2);
    }

    private static boolean throwStatementsAreEquivalent(@NotNull JSThrowStatement statement1, @NotNull JSThrowStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(30);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(31);
        }
        JSExpression exception1 = statement1.getExpression();
        JSExpression exception2 = statement2.getExpression();
        return EquivalenceChecker.expressionsAreEquivalent(exception1, exception2);
    }

    public static boolean expressionsAreEquivalent(@Nullable JSExpression exp1, @Nullable JSExpression exp2) {
        int type2;
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 == null || exp2 == null) {
            return false;
        }
        JSExpression expToCompare1 = exp1;
        while (expToCompare1 instanceof JSParenthesizedExpression) {
            expToCompare1 = ((JSParenthesizedExpression)expToCompare1).getInnerExpression();
        }
        JSExpression expToCompare2 = exp2;
        while (expToCompare2 instanceof JSParenthesizedExpression) {
            expToCompare2 = ((JSParenthesizedExpression)expToCompare2).getInnerExpression();
        }
        int type1 = EquivalenceChecker.getExpressionType(expToCompare1);
        if (type1 != (type2 = EquivalenceChecker.getExpressionType(expToCompare2))) {
            return false;
        }
        switch (type1) {
            case 0: 
            case 4: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: {
                String text1 = expToCompare1.getText();
                String text2 = expToCompare2.getText();
                return text1.equals(text2);
            }
            case 5: {
                return EquivalenceChecker.methodCallExpressionsAreEquivalent((JSCallExpression)expToCompare1, (JSCallExpression)expToCompare2);
            }
            case 6: {
                return EquivalenceChecker.newExpressionsAreEquivalent((JSNewExpression)expToCompare1, (JSNewExpression)expToCompare2);
            }
            case 7: {
                return EquivalenceChecker.arrayInitializerExpressionsAreEquivalent((JSArrayLiteralExpression)expToCompare1, (JSArrayLiteralExpression)expToCompare2);
            }
            case 10: {
                return EquivalenceChecker.prefixExpressionsAreEquivalent((JSPrefixExpression)expToCompare1, (JSPrefixExpression)expToCompare2);
            }
            case 11: {
                return EquivalenceChecker.postfixExpressionsAreEquivalent((JSPostfixExpression)expToCompare1, (JSPostfixExpression)expToCompare2);
            }
            case 12: {
                return EquivalenceChecker.binaryExpressionsAreEquivalent((JSBinaryExpression)expToCompare1, (JSBinaryExpression)expToCompare2);
            }
            case 14: {
                return EquivalenceChecker.binaryExpressionsAreEquivalent((JSBinaryExpression)((JSAssignmentExpression)expToCompare1), (JSBinaryExpression)((JSAssignmentExpression)expToCompare2));
            }
            case 13: {
                return EquivalenceChecker.conditionalExpressionsAreEquivalent((JSConditionalExpression)expToCompare1, (JSConditionalExpression)expToCompare2);
            }
            case 15: {
                return EquivalenceChecker.indexedAccessExpressionsAreEquivalent((JSIndexedPropertyAccessExpression)expToCompare1, (JSIndexedPropertyAccessExpression)expToCompare2);
            }
            case 16: {
                return EquivalenceChecker.objectLiteralExpressionsAreEquivalent((JSObjectLiteralExpression)expToCompare1, (JSObjectLiteralExpression)expToCompare2);
            }
            case 18: {
                return EquivalenceChecker.definitionExpressionsAreEquivalent((JSDefinitionExpression)expToCompare1, (JSDefinitionExpression)expToCompare2);
            }
        }
        return false;
    }

    private static boolean definitionExpressionsAreEquivalent(JSDefinitionExpression jsDefinitionExpression, JSDefinitionExpression jsDefinitionExpression1) {
        return EquivalenceChecker.expressionsAreEquivalent(jsDefinitionExpression.getExpression(), jsDefinitionExpression1.getExpression());
    }

    private static boolean objectLiteralExpressionsAreEquivalent(JSObjectLiteralExpression exp1, JSObjectLiteralExpression exp2) {
        JSProperty[] properties2;
        JSProperty[] properties1 = exp1.getProperties();
        if (properties1.length != (properties2 = exp2.getProperties()).length) {
            return false;
        }
        for (int i = 0; i < properties2.length; ++i) {
            JSExpression value2;
            JSProperty property1 = properties1[i];
            JSProperty property2 = properties2[i];
            if (!Comparing.equal((String)property1.getName(), (String)property2.getName())) {
                return false;
            }
            JSExpression value1 = property1.getValue();
            if (EquivalenceChecker.expressionsAreEquivalent(value1, value2 = property2.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean indexedAccessExpressionsAreEquivalent(JSIndexedPropertyAccessExpression exp1, JSIndexedPropertyAccessExpression exp2) {
        JSExpression index2;
        JSExpression index1 = exp1.getIndexExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent(index1, index2 = exp2.getIndexExpression())) {
            return false;
        }
        JSExpression qualifier1 = exp1.getQualifier();
        JSExpression qualifier2 = exp2.getQualifier();
        return EquivalenceChecker.expressionsAreEquivalent(qualifier1, qualifier2);
    }

    private static boolean methodCallExpressionsAreEquivalent(@NotNull JSCallExpression methodExp1, @NotNull JSCallExpression methodExp2) {
        JSExpression methodExpression2;
        JSExpression methodExpression1;
        if (methodExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(32);
        }
        if (methodExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(33);
        }
        try {
            methodExpression1 = methodExp1.getMethodExpression();
            methodExpression2 = methodExp2.getMethodExpression();
        }
        catch (Exception e) {
            return false;
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(methodExpression1, methodExpression2)) {
            return false;
        }
        JSArgumentList argumentList1 = methodExp1.getArgumentList();
        if (argumentList1 == null) {
            return false;
        }
        JSExpression[] args1 = argumentList1.getArguments();
        JSArgumentList argumentList2 = methodExp2.getArgumentList();
        if (argumentList2 == null) {
            return false;
        }
        JSExpression[] args2 = argumentList2.getArguments();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static boolean newExpressionsAreEquivalent(@NotNull JSNewExpression newExp1, @NotNull JSNewExpression newExp2) {
        JSExpression methodExpression2;
        JSExpression methodExpression1;
        if (newExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(34);
        }
        if (newExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(35);
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(methodExpression1 = newExp1.getMethodExpression(), methodExpression2 = newExp2.getMethodExpression())) {
            return false;
        }
        JSArgumentList argumentList1 = newExp1.getArgumentList();
        if (argumentList1 == null) {
            return false;
        }
        JSExpression[] args1 = argumentList1.getArguments();
        JSArgumentList argumentList2 = newExp2.getArgumentList();
        if (argumentList2 == null) {
            return false;
        }
        JSExpression[] args2 = argumentList2.getArguments();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static boolean arrayInitializerExpressionsAreEquivalent(@NotNull JSArrayLiteralExpression arrInitExp1, @NotNull JSArrayLiteralExpression arrInitExp2) {
        if (arrInitExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(36);
        }
        if (arrInitExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(37);
        }
        JSExpression[] initializers1 = arrInitExp1.getExpressions();
        JSExpression[] initializers2 = arrInitExp2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(initializers1, initializers2);
    }

    private static boolean prefixExpressionsAreEquivalent(@NotNull JSPrefixExpression prefixExp1, @NotNull JSPrefixExpression prefixExp2) {
        if (prefixExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(38);
        }
        if (prefixExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(39);
        }
        IElementType sign1 = prefixExp1.getOperationSign();
        IElementType sign2 = prefixExp2.getOperationSign();
        if (sign1 == null) {
            return sign1 == sign2;
        }
        if (!sign1.equals(sign2)) {
            return false;
        }
        JSExpression operand1 = prefixExp1.getExpression();
        JSExpression operand2 = prefixExp2.getExpression();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean postfixExpressionsAreEquivalent(@NotNull JSPostfixExpression postfixExp1, @NotNull JSPostfixExpression postfixExp2) {
        IElementType sign2;
        IElementType sign1;
        if (postfixExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(40);
        }
        if (postfixExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(41);
        }
        if (!(sign1 = postfixExp1.getOperationSign()).equals(sign2 = postfixExp2.getOperationSign())) {
            return false;
        }
        JSExpression operand1 = postfixExp1.getExpression();
        JSExpression operand2 = postfixExp2.getExpression();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean binaryExpressionsAreEquivalent(@NotNull JSBinaryExpression binaryExp1, @NotNull JSBinaryExpression binaryExp2) {
        IElementType sign2;
        IElementType sign1;
        if (binaryExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(42);
        }
        if (binaryExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(43);
        }
        if (!(sign1 = binaryExp1.getOperationSign()).equals(sign2 = binaryExp2.getOperationSign())) {
            return false;
        }
        JSExpression lhs1 = binaryExp1.getLOperand();
        JSExpression lhs2 = binaryExp2.getLOperand();
        JSExpression rhs1 = binaryExp1.getROperand();
        JSExpression rhs2 = binaryExp2.getROperand();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean conditionalExpressionsAreEquivalent(@NotNull JSConditionalExpression condExp1, @NotNull JSConditionalExpression condExp2) {
        if (condExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(44);
        }
        if (condExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(45);
        }
        JSExpression condition1 = condExp1.getCondition();
        JSExpression condition2 = condExp2.getCondition();
        JSExpression thenExpression1 = condExp1.getThen();
        JSExpression thenExpression2 = condExp2.getThen();
        JSExpression elseExpression1 = condExp1.getElse();
        JSExpression elseExpression2 = condExp2.getElse();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(thenExpression1, thenExpression2) && EquivalenceChecker.expressionsAreEquivalent(elseExpression1, elseExpression2);
    }

    private static boolean expressionListsAreEquivalent(@NotNull JSExpression[] expressions1, @NotNull JSExpression[] expressions2) {
        if (expressions1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(46);
        }
        if (expressions2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(47);
        }
        return ArrayUtil.equals((Object[])expressions1, (Object[])expressions2, EXPRESSION_COMPARATOR);
    }

    private static int getExpressionType(@Nullable JSExpression exp) {
        if (exp instanceof JSThisExpression) {
            return 0;
        }
        if (exp instanceof JSLiteralExpression) {
            return 1;
        }
        if (exp instanceof JSReferenceExpression) {
            return 3;
        }
        if (exp instanceof JSNewExpression) {
            return 6;
        }
        if (exp instanceof JSCallExpression) {
            return 5;
        }
        if (exp instanceof JSArrayLiteralExpression) {
            return 7;
        }
        if (exp instanceof JSPrefixExpression) {
            return 10;
        }
        if (exp instanceof JSPostfixExpression) {
            return 11;
        }
        if (exp instanceof JSAssignmentExpression) {
            return 14;
        }
        if (exp instanceof JSBinaryExpression) {
            return 12;
        }
        if (exp instanceof JSConditionalExpression) {
            return 13;
        }
        if (exp instanceof JSIndexedPropertyAccessExpression) {
            return 15;
        }
        if (exp instanceof JSFunctionExpression) {
            return 17;
        }
        if (exp instanceof JSObjectLiteralExpression) {
            return 16;
        }
        if (exp instanceof JSDefinitionExpression) {
            return 18;
        }
        return -1;
    }

    private static int getStatementType(@Nullable JSSourceElement statement) {
        if (statement instanceof JSBlockStatement) {
            return 1;
        }
        if (statement instanceof JSBreakStatement) {
            return 2;
        }
        if (statement instanceof JSContinueStatement) {
            return 3;
        }
        if (statement instanceof JSVarStatement) {
            return 4;
        }
        if (statement instanceof JSDoWhileStatement) {
            return 5;
        }
        if (statement instanceof JSEmptyStatement) {
            return 6;
        }
        if (statement instanceof JSExpressionStatement) {
            return 8;
        }
        if (statement instanceof JSForStatement) {
            return 9;
        }
        if (statement instanceof JSForInStatement) {
            return 19;
        }
        if (statement instanceof JSIfStatement) {
            return 10;
        }
        if (statement instanceof JSLabeledStatement) {
            return 11;
        }
        if (statement instanceof JSReturnStatement) {
            return 12;
        }
        if (statement instanceof JSSwitchStatement) {
            return 14;
        }
        if (statement instanceof JSThrowStatement) {
            return 16;
        }
        if (statement instanceof JSTryStatement) {
            return 17;
        }
        if (statement instanceof JSWhileStatement) {
            return 18;
        }
        if (statement instanceof JSWithStatement) {
            return 20;
        }
        return -1;
    }

    private static boolean arrayRestElementsAreEquivalent(@Nullable JSDestructuringArrayRestElement element1, @Nullable JSDestructuringArrayRestElement element2) {
        return element1 == null && element2 == null || element1 != null && element2 != null && EquivalenceChecker.variablesAreEquivalent(element1.getVariable(), element2.getVariable());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter2";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExp1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExp2";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExp1";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExp2";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrInitExp1";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrInitExp2";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExp1";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExp2";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExp1";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExp2";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExp1";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExp2";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condExp1";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condExp2";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions1";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions2";
                break;
            }
        }
        objectArray2[1] = "com/sixrr/inspectjs/utils/EquivalenceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "varStatementsAreEquivalent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryStatementsAreEquivalent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parametersAreEquivalent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "whileStatementsAreEquivalent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "forStatementsAreEquivalent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "forInStatementsAreEquivalent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "switchStatementsAreEquivalent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "doWhileStatementsAreEquivalent";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "blockStatementsAreEquivalent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "breakStatementsAreEquivalent";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "continueStatementsAreEquivalent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "labeledStatementsAreEquivalent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "ifStatementsAreEquivalent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionStatementsAreEquivalent";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "returnStatementsAreEquivalent";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "throwStatementsAreEquivalent";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "methodCallExpressionsAreEquivalent";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "newExpressionsAreEquivalent";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "arrayInitializerExpressionsAreEquivalent";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "prefixExpressionsAreEquivalent";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "postfixExpressionsAreEquivalent";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "binaryExpressionsAreEquivalent";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "conditionalExpressionsAreEquivalent";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionListsAreEquivalent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

