/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bitwise;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class IncompatibleMaskJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("incompatible.mask.operation.display.name", new Object[0]);
        if (string == null) {
            IncompatibleMaskJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BITWISE_GROUP_NAME;
        if (string == null) {
            IncompatibleMaskJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        if (((JSBinaryExpression)args[0]).getOperationSign() == JSTokenTypes.EQEQ) {
            String string = InspectionJSBundle.message("incompatible.mask.operation.problem.descriptor.always.false", new Object[0]);
            if (string == null) {
                IncompatibleMaskJSInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionJSBundle.message("incompatible.mask.operation.problem.descriptor.always.true", new Object[0]);
        if (string == null) {
            IncompatibleMaskJSInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IncompatibleMaskVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/bitwise/IncompatibleMaskJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class IncompatibleMaskVisitor
    extends BaseInspectionVisitor {
        private IncompatibleMaskVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                IncompatibleMaskVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            JSExpression strippedRhs = JSParenthesesUtils.stripParentheses(rhs);
            if (strippedRhs == null) {
                return;
            }
            JSExpression lhs = expression.getLOperand();
            JSExpression strippedLhs = JSParenthesesUtils.stripParentheses(lhs);
            if (strippedLhs == null) {
                return;
            }
            if (IncompatibleMaskVisitor.isConstantMask(strippedLhs) && ExpressionUtil.isConstantExpression(strippedRhs, false)) {
                if (IncompatibleMaskVisitor.isIncompatibleMask((JSBinaryExpression)strippedLhs, strippedRhs)) {
                    this.registerError((PsiElement)expression, expression);
                }
            } else if (IncompatibleMaskVisitor.isConstantMask(strippedRhs) && ExpressionUtil.isConstantExpression(strippedLhs, false) && IncompatibleMaskVisitor.isIncompatibleMask((JSBinaryExpression)strippedRhs, strippedLhs)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean isIncompatibleMask(JSBinaryExpression maskExpression, JSExpression constantExpression) {
            int constantMaskValue;
            IElementType tokenType = maskExpression.getOperationSign();
            Object constantValue = ExpressionUtil.computeConstantExpression(constantExpression);
            if (!(constantValue instanceof Integer)) {
                return false;
            }
            int constantLongValue = (Integer)constantValue;
            JSExpression maskRhs = maskExpression.getROperand();
            JSExpression maskLhs = maskExpression.getLOperand();
            if (ExpressionUtil.isConstantExpression(maskRhs, false)) {
                Object rhsValue = ExpressionUtil.computeConstantExpression(maskRhs);
                if (!(rhsValue instanceof Integer)) {
                    return false;
                }
                constantMaskValue = (Integer)rhsValue;
            } else {
                Object lhsValue = ExpressionUtil.computeConstantExpression(maskLhs);
                if (!(lhsValue instanceof Integer)) {
                    return false;
                }
                constantMaskValue = (Integer)lhsValue;
            }
            if (tokenType == JSTokenTypes.OR) {
                return (constantMaskValue | constantLongValue) != constantLongValue;
            }
            if (tokenType == JSTokenTypes.AND) {
                return (constantMaskValue | constantLongValue) != constantMaskValue;
            }
            return false;
        }

        private static boolean isConstantMask(JSExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationSign();
            if (tokenType != JSTokenTypes.OR && tokenType != JSTokenTypes.AND) {
                return false;
            }
            JSExpression rhs = binaryExpression.getROperand();
            if (ExpressionUtil.isConstantExpression(rhs, false)) {
                return true;
            }
            JSExpression lhs = binaryExpression.getLOperand();
            return ExpressionUtil.isConstantExpression(lhs, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bitwise/IncompatibleMaskJSInspection$IncompatibleMaskVisitor", "visitJSBinaryExpression"));
        }
    }
}

