/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.graph;

import com.intellij.ProjectTopics;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptConfigGraphCache
implements Disposable {
    public static final Logger LOG = Logger.getInstance(TypeScriptConfigGraphCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ConcurrentIntObjectMap<TypeScriptImportGraph> myCache;
    @NotNull
    private final ConcurrentIntObjectMap<TypeScriptImportGraph> myDetachedFilesCache;
    @NotNull
    private final Set<VirtualFile> myFilesToRecalculate;

    public TypeScriptConfigGraphCache(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(0);
        }
        this.myCache = ContainerUtil.createConcurrentIntObjectMap();
        this.myDetachedFilesCache = ContainerUtil.createConcurrentIntObjectSoftValueMap();
        this.myFilesToRecalculate = ContainerUtil.newConcurrentSet();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (TypeScriptConfigGraphCache.this.myCache.isEmpty() && TypeScriptConfigGraphCache.this.myDetachedFilesCache.isEmpty()) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    boolean isFileContentChange;
                    if (!TypeScriptConfigGraphCache.isAcceptableEvent(vFileEvent)) continue;
                    boolean bl = isFileContentChange = vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFilePropertyChangeEvent && !TypeScriptConfigGraphCache.isFileNameChange((VFilePropertyChangeEvent)vFileEvent);
                    if (!isFileContentChange) {
                        TypeScriptConfigGraphCache.this.reset();
                        break;
                    }
                    TypeScriptConfigGraphCache.this.addToRecalculateQueue(vFileEvent.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache$1", "after"));
            }
        });
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                TypeScriptConfigGraphCache.this.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache$2", "rootsChanged"));
            }
        });
        LowMemoryWatcher.register(this::reset, (Disposable)this);
    }

    private static boolean isFileNameChange(@NotNull VFilePropertyChangeEvent event) {
        if (event == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(1);
        }
        return "name".equals(event.getPropertyName());
    }

    private static boolean isAcceptableEvent(@NotNull VFileEvent event) {
        VirtualFile file2;
        if (event == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(2);
        }
        if ((file2 = event.getFile()) == null) {
            return false;
        }
        if (file2.isDirectory()) {
            return true;
        }
        String extension = file2.getExtension();
        return TypeScriptImportsResolverProvider.getAllFileExtensionsWithoutDot().contains(extension);
    }

    @NotNull
    public final TypeScriptImportGraph getGraph(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.myFilesToRecalculate.isEmpty()) {
            this.processFilesToRecalculate();
        }
        VirtualFile configFile = config2.getConfigFile();
        int id = TypeScriptImportGraph.getFileId(configFile);
        TypeScriptFileImports references = config2.getConfigImportResolveStructure();
        TypeScriptImportGraph graph = (TypeScriptImportGraph)this.myCache.get(id);
        if (graph != null && !graph.getFileImports().equals(references)) {
            TypeScriptImportGraph value = TypeScriptConfigGraphCache.createValue(configFile, references, true);
            if (!this.myCache.replace(id, (Object)graph, (Object)value)) {
                value = (TypeScriptImportGraph)this.myCache.get(id);
            }
            TypeScriptImportGraph typeScriptImportGraph = value;
            if (typeScriptImportGraph == null) {
                TypeScriptConfigGraphCache.$$$reportNull$$$0(4);
            }
            return typeScriptImportGraph;
        }
        if (graph == null) {
            TypeScriptImportGraph typeScriptImportGraph = this.createOrUseGraph(configFile, id, references);
            if (typeScriptImportGraph == null) {
                TypeScriptConfigGraphCache.$$$reportNull$$$0(5);
            }
            return typeScriptImportGraph;
        }
        TypeScriptImportGraph typeScriptImportGraph = graph;
        if (typeScriptImportGraph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(6);
        }
        return typeScriptImportGraph;
    }

    @NotNull
    private TypeScriptImportGraph createOrUseGraph(VirtualFile configFile, int id, TypeScriptFileImports references) {
        ProgressManager.checkCanceled();
        TypeScriptImportGraph value = TypeScriptConfigGraphCache.createValue(configFile, references, false);
        TypeScriptImportGraph existingGraph = (TypeScriptImportGraph)this.myCache.putIfAbsent(id, (Object)value);
        if (existingGraph != null) {
            value = existingGraph;
        }
        TypeScriptImportGraph typeScriptImportGraph = value;
        if (typeScriptImportGraph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(7);
        }
        return typeScriptImportGraph;
    }

    @NotNull
    public final TypeScriptImportGraph getGraph(@NotNull VirtualFile detachedFile) {
        int id;
        TypeScriptImportGraph graph;
        if (detachedFile == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(8);
        }
        if (!this.myFilesToRecalculate.isEmpty()) {
            this.processFilesToRecalculate();
        }
        if ((graph = (TypeScriptImportGraph)this.myDetachedFilesCache.get(id = TypeScriptImportGraph.getFileId(detachedFile))) != null) {
            TypeScriptImportGraph typeScriptImportGraph = graph;
            if (typeScriptImportGraph == null) {
                TypeScriptConfigGraphCache.$$$reportNull$$$0(9);
            }
            return typeScriptImportGraph;
        }
        TypeScriptImportGraph result2 = TypeScriptConfigGraphCache.createValue(detachedFile, new TypeScriptFileImportsImpl(this.myProject, detachedFile), false);
        TypeScriptImportGraph existingValue = (TypeScriptImportGraph)this.myDetachedFilesCache.putIfAbsent(id, (Object)result2);
        TypeScriptImportGraph typeScriptImportGraph = existingValue == null ? result2 : existingValue;
        if (typeScriptImportGraph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(10);
        }
        return typeScriptImportGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processFilesToRecalculate() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (this.myFilesToRecalculate.size() == 0) {
            return;
        }
        ArrayList<VirtualFile> toRemove = new ArrayList<VirtualFile>();
        try {
            for (VirtualFile file2 : this.myFilesToRecalculate) {
                ProgressManager.checkCanceled();
                Consumer<TypeScriptImportGraph> consumer = graph -> {
                    if (graph.containsFile(file2)) {
                        TypeScriptConfigGraphCache.recalculateGraphSafe(graph, file2);
                    } else if (TypeScriptImportsResolverProvider.checkForDynamicFiles(this.myProject, file2) && graph.includesInPattern(file2)) {
                        graph.resetGraph();
                    }
                };
                this.myCache.values().forEach(consumer);
                this.myDetachedFilesCache.values().forEach(consumer);
                toRemove.add(file2);
            }
        }
        finally {
            this.myFilesToRecalculate.removeAll(toRemove);
        }
    }

    private static void recalculateGraphSafe(@NotNull TypeScriptImportGraph graph, @NotNull VirtualFile file2) {
        if (graph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(12);
        }
        try {
            graph.recalculateEdges(file2);
        }
        catch (ProcessCanceledException | IllegalStateException e) {
            graph.resetGraph();
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOG.error(e);
        }
    }

    private void addToRecalculateQueue(@Nullable VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (file2 == null) {
            return;
        }
        for (TypeScriptImportGraph graph : this.myCache.values()) {
            if (!graph.isInitialized() || !graph.containsFile(file2) && !graph.includesInPattern(file2)) continue;
            this.myFilesToRecalculate.add(file2);
            return;
        }
        for (TypeScriptImportGraph graph : this.myDetachedFilesCache.values()) {
            if (!graph.isInitialized() || !graph.containsFile(file2)) continue;
            this.myFilesToRecalculate.add(file2);
            return;
        }
    }

    public void addToRecalculateQueue(@NotNull PsiFile file2) {
        if (file2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addToRecalculateQueue(virtualFile);
    }

    public final boolean isConfigInclude(@NotNull VirtualFile file2, @NotNull TypeScriptConfig config2) {
        if (file2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(14);
        }
        if (config2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        TypeScriptImportGraph graph = this.getGraph(config2);
        return graph.containsFile(file2);
    }

    private void reset() {
        this.myCache.clear();
        this.myDetachedFilesCache.clear();
        this.myFilesToRecalculate.clear();
    }

    public void dispose() {
        this.reset();
    }

    @NotNull
    static TypeScriptImportGraph createValue(@NotNull VirtualFile configOrRoot, @NotNull TypeScriptFileImports references, boolean rebuild) {
        if (configOrRoot == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(16);
        }
        if (references == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(17);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested " + (rebuild ? "rebuild" : "build") + " graph for " + configOrRoot.getPath());
        }
        TypeScriptImportGraph typeScriptImportGraph = new TypeScriptImportGraph(references);
        if (typeScriptImportGraph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(18);
        }
        return typeScriptImportGraph;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detachedFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configOrRoot";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrUseGraph";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFileNameChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableEvent";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGraph";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "recalculateGraphSafe";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addToRecalculateQueue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isConfigInclude";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

