/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.JSConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptConfigGraphCache;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptConfigServiceImpl
implements TypeScriptConfigService,
JSConfigService {
    private static final TypeScriptImportGraph[] EMPTY_GRAPH_ARRAY = new TypeScriptImportGraph[0];
    @NotNull
    private final Project myProject;
    @NotNull
    private final CachedValue<List<VirtualFile>> myTypeScriptConfigs;
    @NotNull
    private final CachedValue<List<VirtualFile>> myJSConfigs;
    private final CachedValue<ConcurrentIntObjectMap<ConcurrentIntObjectMap<Boolean>>> myFilesMappings;
    private final SimpleModificationTracker myVirtualConfigFilesTracker;
    @Nullable
    private final TypeScriptConfigLibraryUpdater myUpdater;
    @NotNull
    private final TypeScriptConfigGraphCache myConfigGraphCache;
    private final Collection<TypeScriptConfigsChangedListener> myListeners;
    @NotNull
    private final PsiManager myManager;
    private final TypeScriptLibraryProvider myLibraryProvider;

    public TypeScriptConfigServiceImpl(@NotNull Project project, @Nullable TypeScriptConfigLibraryUpdater updater, @NotNull PsiManager manager2, @NotNull TypeScriptLibraryProvider libraryProvider, @NotNull TypeScriptConfigGraphCache configGraphCache) {
        if (project == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(0);
        }
        if (manager2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(1);
        }
        if (libraryProvider == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(2);
        }
        if (configGraphCache == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(3);
        }
        this.myVirtualConfigFilesTracker = new SimpleModificationTracker();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myUpdater = updater;
        this.myConfigGraphCache = configGraphCache;
        this.myManager = manager2;
        this.myLibraryProvider = libraryProvider;
        this.myTypeScriptConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new TypeScriptCachedConfigsProvider(), false);
        this.myJSConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new JSCachedConfigsProvider(), false);
        this.myFilesMappings = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentIntObjectSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
    }

    private void beforeUpdate() {
        this.myVirtualConfigFilesTracker.incModificationCount();
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isAccessible(@NotNull VirtualFile scope, @NotNull VirtualFile referenced) {
        int refId;
        Boolean value;
        ConcurrentIntObjectMap prevValue;
        int scopeId;
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(4);
        }
        if (referenced == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(5);
        }
        if (scope.equals(referenced)) {
            return true;
        }
        if (!this.isEnabled() || DumbService.isDumb((Project)this.myProject)) {
            return true;
        }
        if (!(scope instanceof VirtualFileWithId) || !(referenced instanceof VirtualFileWithId)) {
            return this.isAccessibleImpl(scope, referenced);
        }
        ConcurrentIntObjectMap filesRefsMap = (ConcurrentIntObjectMap)this.myFilesMappings.getValue();
        ConcurrentIntObjectMap scopeFileMap = (ConcurrentIntObjectMap)filesRefsMap.get(scopeId = ((VirtualFileWithId)scope).getId());
        if (scopeFileMap == null && (prevValue = (ConcurrentIntObjectMap)filesRefsMap.putIfAbsent(scopeId, (Object)(scopeFileMap = ContainerUtil.createConcurrentIntObjectMap()))) != null) {
            scopeFileMap = prevValue;
        }
        if ((value = (Boolean)scopeFileMap.get(refId = ((VirtualFileWithId)referenced).getId())) == null) {
            value = this.isAccessibleImpl(scope, referenced);
            scopeFileMap.put(refId, (Object)value);
        }
        return value;
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAccessScope(@NotNull VirtualFile scope) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(7);
            }
            return condition;
        }
        TypeScriptConfigService.IntPredicate filterId = this.getFilterId(scope);
        Condition condition = candidate -> filterId.contains(TypeScriptImportGraph.getFileId(candidate));
        if (condition == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(8);
        }
        return condition;
    }

    @Override
    @NotNull
    public TypeScriptConfigService.IntPredicate getFilterId(@NotNull VirtualFile scope) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            TypeScriptConfigService.IntPredicate intPredicate = el -> false;
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(10);
            }
            return intPredicate;
        }
        int currentFileId = TypeScriptImportGraph.getFileId(scope);
        TIntHashSet ids = this.myLibraryProvider.getLibrariesIds(true);
        if (ids.contains(currentFileId)) {
            TypeScriptConfigService.IntPredicate intPredicate = arg_0 -> ((TIntHashSet)ids).contains(arg_0);
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(11);
            }
            return intPredicate;
        }
        TIntHashSet customIds = this.myLibraryProvider.getLibrariesIds(false);
        if (customIds.contains(currentFileId)) {
            TypeScriptConfigService.IntPredicate intPredicate = arg_0 -> ((TIntHashSet)customIds).contains(arg_0);
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(12);
            }
            return intPredicate;
        }
        List<VirtualFile> configFiles = this.getConfigFiles();
        if (configFiles.isEmpty()) {
            TypeScriptConfigService.IntPredicate intPredicate = el -> true;
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(13);
            }
            return intPredicate;
        }
        TIntHashSet libraries = this.myLibraryProvider.getEffectiveLibrariesIds();
        TypeScriptImportGraph[] graphs = this.getPreferableIncludeParentGraphs(scope, configFiles);
        if (graphs.length == 0) {
            graphs = new TypeScriptImportGraph[]{this.myConfigGraphCache.getGraph(scope)};
        }
        TypeScriptImportGraph[] finalGraphs = graphs;
        TypeScriptConfigService.IntPredicate intPredicate = id -> {
            if (libraries.contains(id)) {
                return true;
            }
            for (TypeScriptImportGraph graph : finalGraphs) {
                if (!graph.containsId(id)) continue;
                return true;
            }
            return false;
        };
        if (intPredicate == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(14);
        }
        return intPredicate;
    }

    private boolean isAccessibleImpl(@NotNull VirtualFile scope, @NotNull VirtualFile file2) {
        if (scope == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(16);
        }
        return this.getAccessScope(scope).value((Object)file2);
    }

    @Override
    @Nullable
    public TypeScriptConfig getPreferableConfig(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(17);
        }
        ArrayList<VirtualFile> configs = new ArrayList<VirtualFile>(this.getConfigFiles());
        List<VirtualFile> files = this.getConfigFiles();
        Collection<? extends VirtualFile> preferableConfigs = TypeScriptConfigUtil.getNearestParentConfigFiles(scopeFile, files);
        while (!preferableConfigs.isEmpty()) {
            Optional preferable = ((StreamEx)StreamEx.of(preferableConfigs).map(this::parseConfigFile).nonNull().filter(el -> this.configGraphIncludesFile(scopeFile, (TypeScriptConfig)el))).findFirst();
            if (preferable.isPresent()) {
                return (TypeScriptConfig)preferable.get();
            }
            configs.removeAll(preferableConfigs);
            preferableConfigs = TypeScriptConfigUtil.getNearestParentConfigFiles(scopeFile, configs);
            if (!preferableConfigs.isEmpty()) continue;
            if (configs.size() != 1) break;
            preferableConfigs = configs;
        }
        return null;
    }

    @Override
    public boolean configGraphIncludesFile(@NotNull VirtualFile file2, @NotNull TypeScriptConfig tsConfig) {
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(18);
        }
        if (tsConfig == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(19);
        }
        return this.myConfigGraphCache.isConfigInclude(file2, tsConfig);
    }

    @NotNull
    private TypeScriptImportGraph[] getPreferableIncludeParentGraphs(@NotNull VirtualFile scopeFile, @NotNull Collection<VirtualFile> configs) {
        TypeScriptImportGraph[] graphs;
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(20);
        }
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(21);
        }
        if (configs.isEmpty()) {
            TypeScriptImportGraph graph = this.myConfigGraphCache.getGraph(scopeFile);
            TypeScriptImportGraph[] typeScriptImportGraphArray = new TypeScriptImportGraph[]{graph};
            if (typeScriptImportGraphArray == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(22);
            }
            return typeScriptImportGraphArray;
        }
        if (configs.size() == 1) {
            TypeScriptImportGraph[] typeScriptImportGraphArray = this.getIncludeGraphs(scopeFile, this.getConfigs(configs));
            if (typeScriptImportGraphArray == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(23);
            }
            return typeScriptImportGraphArray;
        }
        Collection<? extends VirtualFile> preferableConfigs = TypeScriptConfigUtil.getNearestParentConfigFiles(scopeFile, configs);
        if (!preferableConfigs.isEmpty() && (graphs = this.getIncludeGraphs(scopeFile, this.getConfigs(preferableConfigs))).length != 0) {
            if (graphs == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(24);
            }
            return graphs;
        }
        if (EMPTY_GRAPH_ARRAY == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(25);
        }
        return EMPTY_GRAPH_ARRAY;
    }

    @NotNull
    private TypeScriptImportGraph[] getIncludeGraphs(@NotNull VirtualFile scopeFile, @NotNull Collection<? extends TypeScriptConfig> configs) {
        Object[] graphs;
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(26);
        }
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(27);
        }
        for (TypeScriptImportGraph typeScriptImportGraph : graphs = (TypeScriptImportGraph[])ContainerUtil.map2Array(configs, (Object[])new TypeScriptImportGraph[configs.size()], this.myConfigGraphCache::getGraph)) {
            typeScriptImportGraph.initialize(true);
        }
        TypeScriptImportGraph[] typeScriptImportGraphArray = (TypeScriptImportGraph[])ContainerUtil.findAllAsArray((Object[])graphs, el -> TypeScriptConfigServiceImpl.isGraphIncludeFile(el, scopeFile));
        if (typeScriptImportGraphArray == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(28);
        }
        return typeScriptImportGraphArray;
    }

    @Override
    @Nullable
    public TypeScriptConfig getPreferableJSConfig(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptConfig tsConfig = this.getPreferableConfig(scopeFile);
        if (tsConfig != null) {
            return tsConfig;
        }
        List configs = (List)this.myJSConfigs.getValue();
        if (configs.isEmpty()) {
            return null;
        }
        VirtualFile parent = TypeScriptConfigUtil.getNearestParentConfigFile(scopeFile, configs);
        TypeScriptConfig config2 = this.parseConfigFile(parent);
        if (config2 == null) {
            return null;
        }
        TypeScriptFileImports structure = config2.getConfigImportResolveStructure();
        return structure.includesInPattern(scopeFile) ? config2 : null;
    }

    private static boolean isGraphIncludeFile(@NotNull TypeScriptImportGraph el, @NotNull VirtualFile scopeFile) {
        if (el == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(30);
        }
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(31);
        }
        return el.containsFile(scopeFile);
    }

    @Override
    public void addChangeListener(@NotNull TypeScriptConfigsChangedListener listener2) {
        if (listener2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(32);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public boolean hasConfigs() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection configs = (Collection)this.myTypeScriptConfigs.getValue();
        return !configs.isEmpty();
    }

    @Override
    @Nullable
    public TypeScriptConfig parseConfigFile(@Nullable VirtualFile file2) {
        return TypeScriptConfigBase.parseAndCacheConfig(file2, this.myManager);
    }

    private void afterUpdate(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(33);
        }
        if (this.myUpdater != null) {
            if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                this.myUpdater.processConfigsDirectory(configs);
            } else {
                this.myUpdater.queueToUpdate();
            }
        }
        for (TypeScriptConfigsChangedListener listener2 : this.myListeners) {
            listener2.afterUpdate(configs);
        }
    }

    @Override
    @NotNull
    public ModificationTracker getConfigTracker(@Nullable VirtualFile file2) {
        if (file2 == null) {
            SimpleModificationTracker simpleModificationTracker = this.myVirtualConfigFilesTracker;
            if (simpleModificationTracker == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(34);
            }
            return simpleModificationTracker;
        }
        TypeScriptConfig config2 = this.getPreferableConfig(file2);
        if (config2 == null) {
            SimpleModificationTracker simpleModificationTracker = this.myVirtualConfigFilesTracker;
            if (simpleModificationTracker == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(35);
            }
            return simpleModificationTracker;
        }
        Collection<VirtualFile> dependencies = config2.getDependencies();
        ModificationTracker modificationTracker = () -> {
            long result2 = this.myVirtualConfigFilesTracker.getModificationCount();
            for (VirtualFile dependency : dependencies) {
                result2 += dependency.getModificationCount();
            }
            return result2;
        };
        if (modificationTracker == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(36);
        }
        return modificationTracker;
    }

    @Override
    @NotNull
    public ModificationTracker getTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myVirtualConfigFilesTracker;
        if (simpleModificationTracker == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(37);
        }
        return simpleModificationTracker;
    }

    @Override
    public boolean isImplicitIncludedNodeModulesFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull VirtualFile topDirectory) {
        if (project == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(38);
        }
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(39);
        }
        if (topDirectory == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(40);
        }
        if (NodeModuleUtil.isTypesDir(topDirectory)) {
            return true;
        }
        PsiFile psiFile = this.myManager.findFile(file2);
        if (!(psiFile instanceof JSFile) || ((JSFile)psiFile).isCommonJSModule()) {
            return true;
        }
        VirtualFile result2 = JSExactFileReference.resolveForNpmPackages(topDirectory, (NodeModuleDirectorySearchProcessor)new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project));
        return file2.equals(result2);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getIncludedFiles(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(41);
        }
        TypeScriptImportGraph graph = this.myConfigGraphCache.getGraph(file2);
        Collection collection = graph.getNodes();
        if (collection == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(42);
        }
        return collection;
    }

    @NotNull
    private List<TypeScriptConfig> getConfigs(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(43);
        }
        if (files.isEmpty()) {
            List<TypeScriptConfig> list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(44);
            }
            return list2;
        }
        List list3 = ContainerUtil.mapNotNull(files, this::parseConfigFile);
        if (list3 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(45);
        }
        return list3;
    }

    @Override
    @Deprecated
    @NotNull
    public List<TypeScriptConfig> getConfigs() {
        List files = (List)this.myTypeScriptConfigs.getValue();
        List<TypeScriptConfig> list2 = this.getConfigs(files);
        if (list2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(46);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<VirtualFile> getConfigFiles() {
        List list2 = (List)this.myTypeScriptConfigs.getValue();
        if (list2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(47);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configGraphCache";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 16: 
            case 18: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 20: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsConfig";
                break;
            }
            case 21: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topDirectory";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessScope";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterId";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferableIncludeParentGraphs";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeGraphs";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigTracker";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedFiles";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigs";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAccessScope";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFilterId";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleImpl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableConfig";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "configGraphIncludesFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableIncludeParentGraphs";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeGraphs";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableJSConfig";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isGraphIncludeFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "afterUpdate";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitIncludedNodeModulesFile";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedFiles";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getConfigs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class CachedConfigsProvider
    implements CachedValueProvider<List<VirtualFile>> {
        private CachedConfigsProvider() {
        }

        @NotNull
        public final CachedValueProvider.Result<List<VirtualFile>> compute() {
            CachedValueProvider.Result result2 = (CachedValueProvider.Result)ReadAction.compute(() -> this.computeInReadAction());
            if (result2 == null) {
                CachedConfigsProvider.$$$reportNull$$$0(0);
            }
            return result2;
        }

        @NotNull
        protected CachedValueProvider.Result<List<VirtualFile>> computeInReadAction() {
            Collection<VirtualFile> virtualFiles = this.getFiles();
            HashSet<Object> depends = new HashSet<Object>(virtualFiles.size() + 2);
            depends.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            depends.add(ProjectRootModificationTracker.getInstance((Project)TypeScriptConfigServiceImpl.this.myProject));
            ContainerUtil.addAll(depends, virtualFiles);
            List files = ((StreamEx)StreamEx.of(virtualFiles).sorted(Comparator.comparing(VirtualFile::getPath))).toList();
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)files, depends);
            if (result2 == null) {
                CachedConfigsProvider.$$$reportNull$$$0(1);
            }
            return result2;
        }

        @NotNull
        protected abstract Collection<VirtualFile> getFiles();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl$CachedConfigsProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeInReadAction";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class JSCachedConfigsProvider
    extends CachedConfigsProvider {
        private JSCachedConfigsProvider() {
        }

        @Override
        @NotNull
        protected Collection<VirtualFile> getFiles() {
            Collection collection = FilenameIndex.getVirtualFilesByName((Project)TypeScriptConfigServiceImpl.this.myProject, (String)"jsconfig.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)TypeScriptConfigServiceImpl.this.myProject));
            if (collection == null) {
                JSCachedConfigsProvider.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl$JSCachedConfigsProvider", "getFiles"));
        }
    }

    private class TypeScriptCachedConfigsProvider
    extends CachedConfigsProvider {
        private TypeScriptCachedConfigsProvider() {
        }

        @Override
        @NotNull
        protected Collection<VirtualFile> getFiles() {
            TypeScriptConfigServiceImpl.this.beforeUpdate();
            Collection collection = FileTypeIndex.getFiles((FileType)TypeScriptConfigFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)TypeScriptConfigServiceImpl.this.myProject));
            if (collection == null) {
                TypeScriptCachedConfigsProvider.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @Override
        @NotNull
        protected CachedValueProvider.Result<List<VirtualFile>> computeInReadAction() {
            CachedValueProvider.Result<List<VirtualFile>> compute = super.computeInReadAction();
            TypeScriptConfigServiceImpl.this.afterUpdate((Collection)compute.getValue());
            CachedValueProvider.Result<List<VirtualFile>> result2 = compute;
            if (result2 == null) {
                TypeScriptCachedConfigsProvider.$$$reportNull$$$0(1);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl$TypeScriptCachedConfigsProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeInReadAction";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

