/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class TypeScriptGeneratedFilesStartupActivity
implements StartupActivity {
    public static final String[] JS_AND_DTS_EXTENSIONS = new String[]{".js.map", ".js", ".jsx", ".d.ts"};

    public void runActivity(final @NotNull Project project) {
        TypeScriptExcludeManager generatedFilesManager;
        if (project == null) {
            TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(0);
        }
        if ((generatedFilesManager = TypeScriptExcludeManager.getInstance(project)) == null) {
            return;
        }
        if (!generatedFilesManager.isProjectProcessed()) {
            TypeScriptGeneratedFilesStartupActivity.addPlainJavaScriptAndDeclarationFilesToExclude(project, generatedFilesManager);
        }
        project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                List excludedFiles = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile candidate;
                    if (!(vFileEvent instanceof VFileCreateEvent) || !TypeScriptGeneratedFilesStartupActivity.shouldExcludeFile(candidate = vFileEvent.getFile())) continue;
                    if (excludedFiles == null) {
                        excludedFiles = ContainerUtil.newSmartList();
                    }
                    excludedFiles.add(candidate);
                }
                if (excludedFiles != null) {
                    generatedFilesManager.addFiles(excludedFiles);
                    ApplicationManager.getApplication().invokeLater(() -> TypeScriptGeneratedFilesStartupActivity.updateProject(project, generatedFilesManager));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity$1", "after"));
            }
        });
    }

    private static void updateProject(@NotNull Project project, TypeScriptExcludeManager generatedFilesManager) {
        if (project == null) {
            TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(1);
        }
        TransactionGuard.submitTransaction((Disposable)project, generatedFilesManager::updateProject);
    }

    private static void addPlainJavaScriptAndDeclarationFilesToExclude(@NotNull Project project, TypeScriptExcludeManager generatedFilesManager) {
        if (project == null) {
            TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(2);
        }
        ThrowableComputable action = () -> {
            if (!generatedFilesManager.isExcludeGeneratedFiles()) {
                return Collections.emptyList();
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            ArrayList toExcludeFiles = new ArrayList();
            FileTypeIndex.processFiles((FileType)TypeScriptFileType.INSTANCE, file2 -> TypeScriptGeneratedFilesStartupActivity.addFileToExclude(toExcludeFiles, file2), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            FileTypeIndex.processFiles((FileType)TypeScriptJSXFileType.INSTANCE, file2 -> TypeScriptGeneratedFilesStartupActivity.addFileToExclude(toExcludeFiles, file2), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            return toExcludeFiles;
        };
        ReadAction.nonBlocking(() -> ((ThrowableComputable)action).compute()).inSmartMode(project).finishOnUiThread(ModalityState.defaultModalityState(), el -> TypeScriptGeneratedFilesStartupActivity.processFiles(project, generatedFilesManager, el)).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static void processFiles(@NotNull Project project, @NotNull TypeScriptExcludeManager generatedFilesManager, @NotNull List<VirtualFile> toExcludeFiles) {
        if (project == null) {
            TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(3);
        }
        if (generatedFilesManager == null) {
            TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(4);
        }
        if (toExcludeFiles == null) {
            TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(5);
        }
        generatedFilesManager.setFiles(toExcludeFiles);
        generatedFilesManager.updateVersion();
        if (!toExcludeFiles.isEmpty()) {
            Logger.getInstance(TypeScriptGeneratedFilesStartupActivity.class).info("Exclude " + toExcludeFiles.size() + " generated js files");
            TypeScriptGeneratedFilesStartupActivity.updateProject(project, generatedFilesManager);
        }
    }

    private static boolean shouldExcludeFile(VirtualFile candidateToExclude) {
        if (candidateToExclude == null) {
            return false;
        }
        CharSequence name = candidateToExclude.getNameSequence();
        String jsExtension = JSFileReference.findExtension(name, JS_AND_DTS_EXTENSIONS);
        if (jsExtension == null) {
            return false;
        }
        CharSequence jsFileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(name, jsExtension);
        VirtualFile directory = candidateToExclude.getParent();
        if (directory == null) {
            return false;
        }
        for (String ext : TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS) {
            VirtualFile child = directory.findChild(jsFileNameWithoutExtension + ext);
            if (child == null) continue;
            return true;
        }
        return false;
    }

    private static boolean addFileToExclude(ArrayList<VirtualFile> toExcludeFiles, VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        CharSequence fileName = file2.getNameSequence();
        String extension = JSFileReference.findExtension(fileName, TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
        if (StringUtil.isEmpty((String)extension) || ".d.ts".equals(extension)) {
            return true;
        }
        VirtualFile directory = file2.getParent();
        CharSequence tsFileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(fileName, extension);
        if (!StringUtil.isEmpty((CharSequence)tsFileNameWithoutExtension)) {
            for (String dtsExtension : JS_AND_DTS_EXTENSIONS) {
                VirtualFile candidate = directory.findChild(tsFileNameWithoutExtension + dtsExtension);
                if (candidate == null) continue;
                toExcludeFiles.add(candidate);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedFilesManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExcludeFiles";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addPlainJavaScriptAndDeclarationFilesToExclude";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

