/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInserter {
    private final JSParameterList myParameterList;
    private final int myParameterIndex;
    private String mySemicolon;
    private boolean myOptionalParameter;
    private String myParameterInitializer;
    private final boolean myHasRestParameterAfter;
    private final boolean myHasOptionalParameterBefore;

    private JSParameterInserter(JSParameterList parameterList, int parameterIndex, boolean hasRestParameterAfter, boolean hasOptionalParameterBefore) {
        this.myParameterList = parameterList;
        this.myParameterIndex = parameterIndex;
        this.myHasRestParameterAfter = hasRestParameterAfter;
        this.myHasOptionalParameterBefore = hasOptionalParameterBefore;
    }

    @Nullable
    public static JSParameterInserter build(@NotNull JSFunction fun) {
        JSParameterList parameterList;
        if (fun == null) {
            JSParameterInserter.$$$reportNull$$$0(0);
        }
        if ((parameterList = fun.getParameterList()) == null) {
            return null;
        }
        JSParameterListElement[] existingParameters = parameterList.getParameters();
        int index = 0;
        boolean hasRestParameterAfter = false;
        boolean hasOptionalParameterBefore = false;
        for (int i = existingParameters.length - 1; i >= 0; --i) {
            JSParameterListElement existingParameter = existingParameters[i];
            if (!existingParameter.isRest()) {
                index = i + 1;
                hasOptionalParameterBefore = existingParameter.isOptional();
                break;
            }
            hasRestParameterAfter = true;
        }
        return new JSParameterInserter(parameterList, index, hasRestParameterAfter, hasOptionalParameterBefore);
    }

    public JSParameter doInsert(String s, boolean optionalParameter, String parameterInitializer) {
        this.myParameterInitializer = parameterInitializer;
        this.myOptionalParameter = optionalParameter;
        JSParameterListElement createdParameter = JSPsiElementFactory.createJSSourceElement("function xxx (x," + s + ",x2) {}", (PsiElement)this.myParameterList, JSFunction.class).getParameters()[1];
        JSParameterList parameterList = JSChangeSignatureUtil.addParenthesesIfNeeded(this.myParameterList);
        boolean hasExistingParameters = parameterList.getParameters().length > 0;
        PsiElement insertionAnchor = hasExistingParameters && this.myParameterIndex > 0 ? parameterList.getParameters()[this.myParameterIndex - 1] : ((ASTNode)ObjectUtils.assertNotNull((Object)parameterList.getNode().findChildByType(JSTokenTypes.LPAR))).getPsi();
        parameterList.addRangeAfter((PsiElement)(hasExistingParameters && this.myParameterIndex > 0 ? createdParameter.getPrevSibling() : createdParameter), (PsiElement)(hasExistingParameters && this.myParameterIndex == 0 ? createdParameter.getNextSibling() : createdParameter), insertionAnchor);
        return (JSParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)insertionAnchor, JSParameter.class);
    }

    public void fixCall(JSCallExpression callExpression) {
        JSExpression[] expressions = callExpression.getArguments();
        int effectiveParametersCount = expressions.length - (this.myHasRestParameterAfter ? 1 : 0);
        if (effectiveParametersCount < this.myParameterIndex || effectiveParametersCount == this.myParameterIndex && this.myOptionalParameter && !this.myHasOptionalParameterBefore) {
            return;
        }
        if (this.mySemicolon == null) {
            this.mySemicolon = JSCodeStyleSettings.getSemicolon((PsiElement)callExpression.getContainingFile());
        }
        String s = "";
        if (callExpression instanceof JSNewExpression) {
            s = s + "new ";
        }
        s = s + callExpression.getMethodExpression().getText() + "(";
        int index = 0;
        if (index == this.myParameterIndex) {
            s = s + this.myParameterInitializer;
            s = s + ",";
        }
        for (JSExpression e : expressions) {
            if (index == this.myParameterIndex && index > 0) {
                s = s + this.myParameterInitializer;
                s = s + ",";
            }
            s = s + e.getText();
            s = s + ",";
            ++index;
        }
        if (index == this.myParameterIndex && index > 0) {
            s = s + this.myParameterInitializer;
            s = s + ",";
        }
        s = StringUtil.trimEnd((String)s, (String)",");
        s = s + ")";
        s = s + this.mySemicolon;
        callExpression.replace(JSPsiElementFactory.createJSExpression(s, (PsiElement)callExpression));
    }

    public boolean mustBeOptional() {
        return this.myHasOptionalParameterBefore;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/validation/fixes/JSParameterInserter", "build"));
    }
}

