/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ActionScriptAddConstructorAndSuperInvocationFix
implements IntentionAction {
    private final SmartPsiElementPointer<JSClass> myClass;
    private final SmartPsiElementPointer<JSFunction> mySuperConstructor;

    public ActionScriptAddConstructorAndSuperInvocationFix(@NotNull JSClass clazz, @NotNull JSFunction _superCall) {
        if (clazz == null) {
            ActionScriptAddConstructorAndSuperInvocationFix.$$$reportNull$$$0(0);
        }
        if (_superCall == null) {
            ActionScriptAddConstructorAndSuperInvocationFix.$$$reportNull$$$0(1);
        }
        this.myClass = SmartPointerManager.createPointer((PsiElement)clazz);
        this.mySuperConstructor = SmartPointerManager.createPointer((PsiElement)_superCall);
    }

    public static String getConstructorText(JSClass jsClass, JSFunction superConstructor, Collection<? super String> toImport) {
        int i;
        JSAttributeList attributeList = jsClass.getAttributeList();
        StringBuilder fun = new StringBuilder();
        if (attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC) {
            fun.append(JSVisibilityUtil.getVisibilityKeyword(JSAttributeList.AccessType.PUBLIC)).append(" ");
        }
        fun.append("function ").append(jsClass.getName()).append("(");
        JSParameterListElement[] parameters = superConstructor.getParameters();
        for (i = 0; i < parameters.length; ++i) {
            JSExpression initializer;
            if (i > 0) {
                fun.append(",");
            }
            if (parameters[i].isRest()) {
                fun.append("...").append(parameters[i].getName());
                continue;
            }
            fun.append(parameters[i].getName());
            JSType jsType = parameters[i].getJSType();
            if (jsType != null) {
                String type = jsType.getResolvedTypeText();
                if (ImportUtils.needsImport((JSQualifiedNamedElement)jsClass, StringUtil.getPackageName((String)type))) {
                    toImport.add(type);
                }
                fun.append(":").append(type);
            }
            if ((initializer = parameters[i].getInitializer()) == null) continue;
            fun.append("=").append(initializer.getText());
        }
        fun.append("){\nsuper(");
        for (i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                fun.append(",");
            }
            fun.append(parameters[i].getName());
        }
        fun.append(")").append(JSCodeStyleSettings.getSemicolon((PsiElement)jsClass.getContainingFile())).append("\n}");
        return fun.toString();
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.fix.create.constructor.invoke.super", (Object[])new Object[0]);
        if (string == null) {
            ActionScriptAddConstructorAndSuperInvocationFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ActionScriptAddConstructorAndSuperInvocationFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ActionScriptAddConstructorAndSuperInvocationFix.$$$reportNull$$$0(4);
        }
        JSClass jsClass = (JSClass)this.myClass.getElement();
        JSFunction superConstructorElement = (JSFunction)this.mySuperConstructor.getElement();
        return jsClass != null && superConstructorElement != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            ActionScriptAddConstructorAndSuperInvocationFix.$$$reportNull$$$0(5);
        }
        JSClass jsClass = (JSClass)this.myClass.getElement();
        JSFunction superConstructor = (JSFunction)this.mySuperConstructor.getElement();
        assert (superConstructor != null);
        assert (jsClass != null);
        HashSet<String> toImport = new HashSet<String>();
        String text = ActionScriptAddConstructorAndSuperInvocationFix.getConstructorText(jsClass, superConstructor, toImport);
        jsClass.add(JSChangeUtil.createJSTreeFromText(jsClass.getProject(), text, JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi());
        if (!toImport.isEmpty()) {
            ImportUtils.insertImportStatements((PsiElement)jsClass, toImport);
            new ECMAScriptImportOptimizer().processFile(jsClass.getContainingFile()).run();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_superCall";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ActionScriptAddConstructorAndSuperInvocationFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ActionScriptAddConstructorAndSuperInvocationFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

