/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.surroundWith.JSStatementSurrounder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Objects;

public class JSWithFunctionExpressionSurrounder
extends JSStatementSurrounder {
    public String getTemplateDescription() {
        return JSBundle.message((String)"javascript.surround.with.function.expression", (Object[])new Object[0]);
    }

    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "aaa = function () { }" + JSCodeStyleSettings.getSemicolon((PsiElement)context.getContainingFile());
    }

    @Override
    protected ASTNode getInsertBeforeNode(ASTNode statementNode) {
        JSFunctionExpression stmt = JSWithFunctionExpressionSurrounder.getFunctionExpr(statementNode);
        return Objects.requireNonNull(stmt.getBlock()).getLastChild().getNode();
    }

    private static JSFunctionExpression getFunctionExpr(ASTNode statementNode) {
        return (JSFunctionExpression)((JSAssignmentExpression)((JSExpressionStatement)statementNode.getPsi()).getExpression()).getROperand();
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSFunctionExpression stmt = JSWithFunctionExpressionSurrounder.getFunctionExpr(statementNode);
        ASTNode conditionNode = stmt.findNameIdentifier();
        int offset = conditionNode.getStartOffset();
        stmt.getParent().getNode().removeChild(conditionNode);
        return new TextRange(offset, offset);
    }
}

