/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.refactoring.convertToClass.ClassInheritanceNode;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassDataProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSToClassConversionResults;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class ReferenceUnbounder {
    private final MultiMap<Case, PairProcessor<JSReferenceExpression, UsageInfo>> myProcessors;
    private final Map<String, ChildConvertorHolder> myChildConvertors;

    ReferenceUnbounder(@NotNull MultiMap<Case, PairProcessor<JSReferenceExpression, UsageInfo>> processors) {
        if (processors == null) {
            ReferenceUnbounder.$$$reportNull$$$0(0);
        }
        this.myProcessors = processors;
        this.myChildConvertors = new HashMap<String, ChildConvertorHolder>();
    }

    public void formChildConvertors(@NotNull Map<String, JSItemToClassDataProcessor> childConvertors, @NotNull JSToClassConversionResults conversionResults) {
        if (childConvertors == null) {
            ReferenceUnbounder.$$$reportNull$$$0(1);
        }
        if (conversionResults == null) {
            ReferenceUnbounder.$$$reportNull$$$0(2);
        }
        for (Map.Entry<String, ChildConvertorHolder> entry : this.myChildConvertors.entrySet()) {
            String name = entry.getKey();
            ChildConvertorHolder holder = entry.getValue();
            if (holder.isValid()) {
                childConvertors.put(name, holder.createConvertor());
                continue;
            }
            for (Pair<JSReferenceExpression, UsageInfo> pair : holder.getUsages()) {
                conversionResults.notConverted((UsageInfo)pair.getSecond());
            }
        }
    }

    public boolean processReferenceRecursively(@NotNull JSReferenceExpression reference, @NotNull UsageInfo info) {
        PsiElement parent;
        if (reference == null) {
            ReferenceUnbounder.$$$reportNull$$$0(3);
        }
        if (info == null) {
            ReferenceUnbounder.$$$reportNull$$$0(4);
        }
        if ((parent = reference.getParent()) instanceof JSReferenceExpression) {
            JSAssignmentExpression assignment;
            String parentRefName = ((JSReferenceExpression)parent).getReferenceName();
            if ("__proto__".equals(parentRefName)) {
                return false;
            }
            if ("prototype".equals(parentRefName)) {
                if (parent.getParent() instanceof JSReferenceExpression) {
                    JSReferenceExpression grand = (JSReferenceExpression)parent.getParent();
                    String granRefName = grand.getReferenceName();
                    if ("__proto__".equals(granRefName)) {
                        if (parent.getParent().getParent() instanceof JSReferenceExpression) {
                            return false;
                        }
                        return this.applyProcessors(Case._proto, grand, info);
                    }
                    return this.applyProcessors(Case._member, grand, info);
                }
                return this.applyProcessors(Case._prototype, (JSReferenceExpression)parent, info);
            }
            ChildConvertorHolder holder = this.myChildConvertors.get(parentRefName);
            if (holder == null) {
                holder = new ChildConvertorHolder();
                this.myChildConvertors.put(parentRefName, holder);
            }
            if (!(parent.getParent() instanceof JSReferenceExpression) && (assignment = ClassInheritanceNode.findParentAssignment((PsiReference)parent)) != null && assignment.getDefinitionExpression() != null && assignment.getDefinitionExpression().getInitializer() instanceof JSFunction) {
                holder.registerConstructor((JSFunction)assignment.getDefinitionExpression().getInitializer());
                return true;
            }
            holder.addUsage((JSReferenceExpression)parent, info);
            return true;
        }
        return this.applyProcessors(Case._static, reference, info);
    }

    private boolean applyProcessors(@NotNull Case aCase, @NotNull JSReferenceExpression reference, @NotNull UsageInfo info) {
        if (aCase == null) {
            ReferenceUnbounder.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            ReferenceUnbounder.$$$reportNull$$$0(6);
        }
        if (info == null) {
            ReferenceUnbounder.$$$reportNull$$$0(7);
        }
        Collection processors = this.myProcessors.get((Object)aCase);
        for (PairProcessor processor : processors) {
            if (!processor.process((Object)reference, (Object)info)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childConvertors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conversionResults";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aCase";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/ReferenceUnbounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "formChildConvertors";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processReferenceRecursively";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "applyProcessors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChildConvertorHolder {
        private final List<Pair<JSReferenceExpression, UsageInfo>> myUsages = new ArrayList<Pair<JSReferenceExpression, UsageInfo>>();
        private JSAssignmentExpression myAssignment;
        private JSFunction myConstructorFunction;

        ChildConvertorHolder() {
        }

        void addUsage(@NotNull JSReferenceExpression expression, @NotNull UsageInfo info) {
            if (expression == null) {
                ChildConvertorHolder.$$$reportNull$$$0(0);
            }
            if (info == null) {
                ChildConvertorHolder.$$$reportNull$$$0(1);
            }
            this.myUsages.add((Pair<JSReferenceExpression, UsageInfo>)Pair.create((Object)expression, (Object)info));
        }

        void registerConstructor(@NotNull JSFunction function) {
            if (function == null) {
                ChildConvertorHolder.$$$reportNull$$$0(2);
            }
            if (!(function.getParent() instanceof JSAssignmentExpression)) {
                return;
            }
            this.myAssignment = (JSAssignmentExpression)function.getParent();
            this.myConstructorFunction = function;
        }

        boolean isValid() {
            return this.myAssignment != null;
        }

        public JSItemToClassDataProcessor createConvertor() {
            JSItemToClassDataProcessor convertor = new JSItemToClassDataProcessor(this.myConstructorFunction, this.myAssignment, null);
            convertor.processUsages(this.myUsages);
            return convertor;
        }

        public List<Pair<JSReferenceExpression, UsageInfo>> getUsages() {
            return this.myUsages;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/ReferenceUnbounder$ChildConvertorHolder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addUsage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerConstructor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum Case {
        _prototype,
        _proto,
        _member,
        _static;

    }
}

