/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTupleTypeImpl
extends JSCompositeTypeBaseImpl
implements JSTupleType {
    private final boolean myStrict;
    private final boolean myReadonly;
    private final int myFirstOptional;

    @NotNull
    public static JSType createTupleType(@NotNull JSTypeSource source, @NotNull Collection<? extends JSType> _types, boolean strict, int firstOptional, boolean isReadonly) {
        JSType singleType;
        if (source == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(0);
        }
        if (_types == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(1);
        }
        if (_types.size() == 1 && (singleType = _types.iterator().next()) instanceof JSSpreadType) {
            JSType componentType = ((JSSpreadType)singleType).getComponentType();
            if (!isReadonly) {
                JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(componentType, source);
                if (jSArrayTypeImpl == null) {
                    JSTupleTypeImpl.$$$reportNull$$$0(2);
                }
                return jSArrayTypeImpl;
            }
            JSReadonlyArrayTypeImpl jSReadonlyArrayTypeImpl = new JSReadonlyArrayTypeImpl(componentType, source);
            if (jSReadonlyArrayTypeImpl == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(3);
            }
            return jSReadonlyArrayTypeImpl;
        }
        JSTupleTypeImpl jSTupleTypeImpl = new JSTupleTypeImpl(source, _types, strict, firstOptional, isReadonly);
        if (jSTupleTypeImpl == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(4);
        }
        return jSTupleTypeImpl;
    }

    @Deprecated
    public JSTupleTypeImpl(JSTypeSource source, Collection<? extends JSType> _types, boolean strict, int firstOptional) {
        this(source, _types, strict, firstOptional, false);
    }

    public JSTupleTypeImpl(JSTypeSource source, Collection<? extends JSType> _types, boolean strict, int firstOptional, boolean isReadonly) {
        super(source, _types);
        this.myStrict = strict;
        this.myFirstOptional = firstOptional;
        this.myReadonly = isReadonly;
    }

    protected JSTupleTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(5);
        }
        if (inputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(6);
        }
        super(source, inputStream);
        this.myStrict = JSTypeSerializer.readBoolean(inputStream);
        this.myReadonly = JSTypeSerializer.readBoolean(inputStream);
        this.myFirstOptional = JSTypeSerializer.readInt(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(7);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myStrict, outputStream);
        JSTypeSerializer.writeBoolean(this.myReadonly, outputStream);
        JSTypeSerializer.writeInt(this.myFirstOptional, outputStream);
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if ("," == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(8);
        }
        return ",";
    }

    public int getOptionalStart() {
        return this.myFirstOptional;
    }

    public int getMinLength() {
        List<JSType> types2 = this.getTypes();
        JSType lastItem = (JSType)ContainerUtil.getLastItem(types2);
        if (this.myFirstOptional != -1) {
            return this.myFirstOptional;
        }
        return lastItem instanceof JSSpreadType ? types2.size() - 1 : types2.size();
    }

    public int getMaxLength() {
        List<JSType> types2 = this.getTypes();
        JSType lastItem = (JSType)ContainerUtil.getLastItem(types2);
        return lastItem instanceof JSSpreadType ? Integer.MAX_VALUE : types2.size();
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(10);
        }
        if (this.isTypeScript() && this.isReadonly()) {
            builder.append("readonly ");
        }
        builder.append("[");
        super.buildTypeTextImpl(format, builder);
        builder.append("]");
    }

    @Override
    protected boolean areTypesPresentablyEquivalent(JSType t, JSType type, JSType.TypeTextFormat format, ProcessingContext ctx) {
        return false;
    }

    @Override
    protected void buildNestedTypePresentation(@NotNull JSType t, @NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (t == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(11);
        }
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(13);
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE && t instanceof JSNullType) {
            builder.append("*");
            return;
        }
        super.buildNestedTypePresentation(t, format, builder);
    }

    @Override
    @NotNull
    protected String getTypeSeparatorForTypeText(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(14);
        }
        if (", " == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(15);
        }
        return ", ";
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean sourceOnly) {
        if (transformedTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(16);
        }
        if (newSource == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(17);
        }
        JSType jSType = JSTupleTypeImpl.createTupleType(newSource, transformedTypes, this.myStrict, this.myFirstOptional, this.myReadonly);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(19);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(20);
        }
        if (this.myStrict && elementType instanceof JSTupleType) {
            if (!this.myReadonly && ((JSTupleType)elementType).isReadonly()) {
                return false;
            }
            List elementTypes = ((JSTupleType)elementType).getTypes();
            List<JSType> currentTypes = this.getTypes();
            int min = Math.min(elementTypes.size(), currentTypes.size());
            for (int i = 0; i < min; ++i) {
                JSType nestedElement;
                JSType nestedCurrent = currentTypes.get(i);
                if (nestedCurrent instanceof JSSpreadType) {
                    nestedCurrent = ((JSSpreadType)nestedCurrent).getComponentType();
                }
                if ((nestedElement = (JSType)elementTypes.get(i)) instanceof JSSpreadType) {
                    nestedElement = ((JSSpreadType)nestedElement).getComponentType();
                }
                if (nestedCurrent.isDirectlyAssignableType(nestedElement, processingContext)) continue;
                return false;
            }
            if (currentTypes.size() == elementTypes.size()) {
                JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
                JSType lastOther = (JSType)ContainerUtil.getLastItem((List)elementTypes);
                if (this.isTypeScript() && lastOther instanceof JSSpreadType && lastCurrent != null && !(lastCurrent instanceof JSSpreadType)) {
                    return false;
                }
            }
            if (currentTypes.size() < elementTypes.size()) {
                JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
                if (!(lastCurrent instanceof JSSpreadType)) {
                    return !this.isTypeScript();
                }
                if (currentTypes.size() - elementTypes.size() + 1 == 0 && ContainerUtil.getLastItem((List)elementTypes) instanceof JSSpreadType) {
                    return true;
                }
                return !this.isTypeScript() || JSTupleTypeImpl.checkWithSpreads(processingContext, elementTypes, min, ((JSSpreadType)lastCurrent).getComponentType(), false);
            }
            if (elementTypes.size() < currentTypes.size()) {
                JSType lastItem = (JSType)ContainerUtil.getLastItem((List)elementTypes);
                if (!(lastItem instanceof JSSpreadType)) {
                    return this.myFirstOptional != -1 && min >= this.myFirstOptional || elementTypes.size() - currentTypes.size() + 1 == 0 && ContainerUtil.getLastItem(currentTypes) instanceof JSSpreadType;
                }
                JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
                if (this.isTypeScript() && lastCurrent instanceof JSSpreadType) {
                    return false;
                }
                JSType componentType = ((JSSpreadType)lastItem).getComponentType();
                return JSTupleTypeImpl.checkWithSpreads(processingContext, currentTypes, min, componentType, true);
            }
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private static boolean checkWithSpreads(@NotNull ProcessingContext processingContext, @NotNull List<JSType> currentTypes, int min, @NotNull JSType componentType, boolean forward) {
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(21);
        }
        if (currentTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(22);
        }
        if (componentType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(23);
        }
        for (int i = min; i < currentTypes.size(); ++i) {
            JSType type = currentTypes.get(i);
            if (type instanceof JSSpreadType) {
                type = ((JSSpreadType)type).getComponentType();
            }
            if ((forward ? type : componentType).isDirectlyAssignableType(forward ? componentType : type, processingContext)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public JSType getTypeByIndex(int index) {
        JSType type;
        if (index < 0) {
            return null;
        }
        List<JSType> types2 = this.getTypes();
        int lastIndex = types2.size() - 1;
        if (index <= lastIndex) {
            JSType type2 = types2.get(index);
            if (index == lastIndex && type2 instanceof JSSpreadType) {
                return ((JSSpreadType)type2).getComponentType();
            }
            return type2;
        }
        if (lastIndex >= 0 && (type = types2.get(lastIndex)) instanceof JSSpreadType) {
            return ((JSSpreadType)type).getComponentType();
        }
        return null;
    }

    public boolean hasTypeByIndex(int index) {
        if (index < 0) {
            return false;
        }
        List<JSType> types2 = this.getTypes();
        int lastIndex = types2.size() - 1;
        if (index <= lastIndex) {
            return true;
        }
        if (lastIndex >= 0) {
            return types2.get(lastIndex) instanceof JSSpreadType;
        }
        return false;
    }

    @Nullable
    public JSType excludePrefix(int length) {
        if (length <= 0) {
            return this;
        }
        List<JSType> types2 = this.getTypes();
        int lastIndex = types2.size() - 1;
        if (length > lastIndex) {
            JSType lastType;
            if (lastIndex >= 0 && (lastType = types2.get(lastIndex)) instanceof JSSpreadType) {
                return JSTupleTypeImpl.createTupleType(this.getSource(), ContainerUtil.createMaybeSingletonList((Object)lastType), this.myStrict, -1, this.myReadonly);
            }
            return null;
        }
        List<JSType> newTypes = types2.subList(length, types2.size());
        return JSTupleTypeImpl.createTupleType(this.getSource(), newTypes, this.myStrict, this.myFirstOptional == -1 || this.myFirstOptional + length >= newTypes.size() ? -1 : this.myFirstOptional + length, this.myReadonly);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(24);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(25);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(26);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.toArrayType(true).isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(27);
        }
        return assignableResult3;
    }

    @NotNull
    public final JSType toArrayType(boolean allowResolve) {
        JSType jSType = this.toArrayImpl(allowResolve);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    @NotNull
    private JSType toArrayImpl(boolean allowResolve) {
        JSTypeSource source = this.getSource();
        List<JSType> types2 = this.getTypes();
        List providers = ContainerUtil.map(types2, el -> () -> el instanceof JSSpreadType ? ((JSSpreadType)el).getComponentType() : el);
        JSType commonType = JSTypeUtils.getCommonType(providers, source.getSourceElement(), allowResolve);
        if (commonType instanceof JSNullType) {
            commonType = JSAnyType.get(source.getSourceElement(), false);
        }
        JSArrayTypeImpl jSArrayTypeImpl = this.myReadonly ? new JSReadonlyArrayTypeImpl(commonType, source) : new JSArrayTypeImpl(commonType, source);
        if (jSArrayTypeImpl == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(29);
        }
        return jSArrayTypeImpl;
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType parent = this.toArrayImpl(true).asRecordType();
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> members = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>(parent.getTypeMembers());
        List<JSType> types2 = this.getTypes();
        for (int i = 0; i < types2.size(); ++i) {
            members.add(new JSRecordTypeImpl.PropertySignatureImpl(String.valueOf(i), types2.get(i), false, false));
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(parent.getSource(), members);
        if (jSRecordTypeImpl == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(30);
        }
        return jSRecordTypeImpl;
    }

    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create("Array", null);
    }

    public boolean hasQualifiedName() {
        return true;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(super.resolvedHashCodeImpl(), this.myStrict, this.myFirstOptional, this.myReadonly);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(31);
        }
        return super.isEquivalentToWithSameClass(type, processingContext, allowResolve) && this.myReadonly == ((JSTupleTypeImpl)type).myReadonly && this.myStrict == ((JSTupleTypeImpl)type).myStrict && this.myFirstOptional == ((JSTupleTypeImpl)type).myFirstOptional;
    }

    @NotNull
    public String getDefaultValue() {
        StringBuilder type = new StringBuilder("[");
        List<JSType> types2 = this.getTypes();
        int size = types2.size();
        int i = 0;
        for (JSType jsType : types2) {
            type.append(JSTypeUtils.defaultValueOfType(jsType));
            if (i < size - 1) {
                type.append(",");
            }
            ++i;
        }
        String string = type.append("]").toString();
        if (string == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 15: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 15: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 15: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 20: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTypes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTupleType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparatorForTypeText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "toArrayType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toArrayImpl";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTupleType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 15: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildNestedTypePresentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSeparatorForTypeText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkWithSpreads";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 15: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

