/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.InvalidEnumConstantValue;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSResolvedTypeInfoImpl
implements JSResolvedTypeInfo {
    @NotNull
    private final Set<? extends PsiElement> myElements;
    @NotNull
    private final String myResolvedType;
    private boolean myIsEnum;
    private boolean myIsEnumLiteral;
    private boolean myIsEnumWithLiteralValues;
    private boolean myIsLocal;
    private boolean myIsAbstract;
    private boolean myIsInterface;
    @Nullable
    private JSType myAliasedType;
    @NotNull
    private EnumConstantValue myEnumConstValue;

    public JSResolvedTypeInfoImpl(@NotNull String resolvedType, @NotNull Collection<? extends PsiElement> elements) {
        if (resolvedType == null) {
            JSResolvedTypeInfoImpl.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            JSResolvedTypeInfoImpl.$$$reportNull$$$0(1);
        }
        this.myEnumConstValue = InvalidEnumConstantValue.INSTANCE;
        this.myResolvedType = resolvedType;
        this.myElements = Collections.unmodifiableSet(new THashSet(elements));
        this.setTypeScriptAdditionalParams();
    }

    private void setTypeScriptAdditionalParams() {
        for (PsiElement psiElement : this.myElements) {
            if (psiElement instanceof TypeScriptTypeAlias) {
                this.myAliasedType = ((TypeScriptTypeAlias)psiElement).getParsedTypeDeclaration();
                break;
            }
            if (psiElement instanceof JSClass) {
                if (!((JSClass)psiElement).isNamespaceExplicitlyDeclared()) {
                    this.myIsLocal = true;
                }
                if (psiElement instanceof TypeScriptClass) {
                    this.myIsAbstract = TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)((TypeScriptClass)psiElement));
                } else if (psiElement instanceof TypeScriptInterface) {
                    this.myIsInterface = ((TypeScriptInterface)psiElement).isInterface();
                }
            }
            if (psiElement instanceof TypeScriptEnum) {
                this.myIsEnum = true;
                this.myIsEnumWithLiteralValues = ((TypeScriptEnum)psiElement).hasConstValues();
            }
            if (!(psiElement instanceof TypeScriptEnumField)) continue;
            this.myIsEnumLiteral = true;
            this.myEnumConstValue = ((TypeScriptEnumField)psiElement).getConstantValue();
        }
    }

    @Override
    @NotNull
    public String getResolvedTypeText() {
        String string = this.myResolvedType;
        if (string == null) {
            JSResolvedTypeInfoImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public <T extends PsiElement> T getDeclarationOfType(@NotNull Class<T> klass) {
        if (klass == null) {
            JSResolvedTypeInfoImpl.$$$reportNull$$$0(3);
        }
        for (PsiElement psiElement : this.myElements) {
            if (!klass.isInstance(psiElement)) continue;
            PsiElement declaration = psiElement;
            return (T)declaration;
        }
        return null;
    }

    @Override
    @NotNull
    public <T extends PsiElement> Collection<T> getDeclarationsOfType(@NotNull Class<T> klass) {
        if (klass == null) {
            JSResolvedTypeInfoImpl.$$$reportNull$$$0(4);
        }
        List list2 = ContainerUtil.mapNotNull(this.myElements, el -> klass.isInstance(el) ? el : null);
        if (list2 == null) {
            JSResolvedTypeInfoImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<? extends PsiElement> getDeclarations() {
        Set<? extends PsiElement> set = this.myElements;
        if (set == null) {
            JSResolvedTypeInfoImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Override
    public boolean isEnum() {
        return this.myIsEnum;
    }

    @Override
    public boolean isEnumWithLiteralValues() {
        return this.myIsEnumWithLiteralValues;
    }

    @Override
    public boolean isEnumLiteral() {
        return this.myIsEnumLiteral;
    }

    @Override
    public boolean isInterface() {
        return this.myIsInterface;
    }

    @Override
    public boolean isLocal() {
        return this.myIsLocal;
    }

    @Override
    public boolean isAbstract() {
        return this.myIsAbstract;
    }

    @Override
    @Nullable
    public JSType getAliasedType() {
        return this.myAliasedType;
    }

    @Override
    @NotNull
    public EnumConstantValue getEnumConstValue() {
        EnumConstantValue enumConstantValue = this.myEnumConstValue;
        if (enumConstantValue == null) {
            JSResolvedTypeInfoImpl.$$$reportNull$$$0(7);
        }
        return enumConstantValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSResolvedTypeInfoImpl info = (JSResolvedTypeInfoImpl)o;
        return Objects.equals(this.myElements, info.myElements);
    }

    public int hashCode() {
        return Objects.hash(this.myElements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeInfoImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeInfoImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsOfType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumConstValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationOfType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

