/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGeneratorReturnType
extends JSFunctionReturnWrapperType {
    private final boolean myIsAsync;
    @Nullable
    private final JSType myReturnType;

    public JSGeneratorReturnType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(1);
        }
        super(source, inputStream);
        this.myIsAsync = JSTypeSerializer.readBoolean(inputStream);
        this.myReturnType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
    }

    public JSGeneratorReturnType(@NotNull JSTypeSource typeSource, @Nullable JSType innerType, @Nullable JSType returnType, boolean isAsync) {
        if (typeSource == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(2);
        }
        super(typeSource, innerType);
        this.myIsAsync = isAsync;
        this.myReturnType = returnType;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myIsAsync, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myReturnType, outputStream);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        JSType returnTransformed;
        if (childTransform == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(4);
        }
        JSType innerTransformed = this.myInnerType == null ? null : (JSType)childTransform.fun((Object)this.myInnerType);
        JSType jSType = returnTransformed = this.myReturnType == null ? null : (JSType)childTransform.fun((Object)this.myReturnType);
        if (innerTransformed == this.myInnerType && returnTransformed == this.myReturnType) {
            JSGeneratorReturnType jSGeneratorReturnType = this;
            if (jSGeneratorReturnType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(5);
            }
            return jSGeneratorReturnType;
        }
        JSGeneratorReturnType jSGeneratorReturnType = new JSGeneratorReturnType(this.getSource(), innerTransformed, returnTransformed, this.myIsAsync);
        if (jSGeneratorReturnType == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(6);
        }
        return jSGeneratorReturnType;
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(7);
        }
        return super.isEquivalentToWithSameClass(type, context, allowResolve) && JSGeneratorReturnType.areEquivalent(this.myReturnType, ((JSGeneratorReturnType)type).myReturnType, context, allowResolve);
    }

    @Override
    protected JSType createInstance(@NotNull JSTypeSource typeSource, @Nullable JSType innerType) {
        if (typeSource == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(8);
        }
        return new JSGeneratorReturnType(typeSource, innerType, this.myReturnType, this.myIsAsync);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(9);
        }
        if (this.myInnerType != null) {
            this.myInnerType.accept(visitor);
        }
        if (this.myReturnType != null) {
            this.myReturnType.accept(visitor);
        }
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.getClass(), this.myIsAsync, this.myInnerType == null ? 0 : this.myInnerType.resolvedHashCode(), this.myReturnType == null ? 0 : this.myReturnType.resolvedHashCode());
    }

    @Override
    protected String getPrefix() {
        return "iret";
    }

    @Override
    protected JSType doSubstitute(@Nullable JSType type, @NotNull JSTypeSource source, JSTypeSubstitutionContext context) {
        JSType expandedReturn;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(10);
        }
        String typeName = this.getTypeName(source);
        JSType iterableType = JSNamedTypeFactory.createType(typeName, source, JSContext.INSTANCE);
        JSType expandedType = type == null ? null : context.substituteNested(type);
        JSType jSType = expandedReturn = this.myReturnType == null ? null : context.substituteNested(this.myReturnType);
        if (typeName == "AsyncIterableIterator" || typeName == "IterableIterator") {
            return new JSGenericTypeImpl(source, iterableType, JSGeneratorReturnType.combineObsoleteGeneratorType(source, expandedType, expandedReturn));
        }
        if (expandedType == null) {
            expandedType = JSAnyType.get(source);
        }
        if (expandedReturn == null) {
            expandedReturn = JSAnyType.get(source);
        }
        return new JSGenericTypeImpl(source, iterableType, Arrays.asList(expandedType, JSTypeUtils.widenLiteralTypes(expandedReturn)));
    }

    @NotNull
    private static JSType combineObsoleteGeneratorType(@NotNull JSTypeSource source, JSType expandedType, JSType expandedReturn) {
        boolean expandedIsNullOrVoid;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(11);
        }
        boolean bl = expandedIsNullOrVoid = expandedType == null || expandedType instanceof JSVoidType;
        if (expandedIsNullOrVoid && expandedReturn == null) {
            JSAnyType jSAnyType = JSAnyType.get(source);
            if (jSAnyType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(12);
            }
            return jSAnyType;
        }
        if (expandedIsNullOrVoid) {
            JSType jSType = expandedReturn;
            if (jSType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        if (expandedReturn == null) {
            JSType jSType = expandedType;
            if (jSType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(expandedType, expandedReturn, source, true);
        if (jSType == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(15);
        }
        return jSType;
    }

    @NotNull
    private String getTypeName(JSTypeSource source) {
        String defaultName;
        PsiElement sourceElement = source.getSourceElement();
        String string = defaultName = this.myIsAsync ? "AsyncIterableIterator" : "IterableIterator";
        if (sourceElement == null) {
            String string2 = defaultName;
            if (string2 == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(16);
            }
            return string2;
        }
        JSTypeResolveResult result2 = JSImportHandler.getInstance().resolveTypeName("Generator", sourceElement);
        if (result2.hasElements() && result2.getElements().stream().anyMatch(e -> e instanceof TypeScriptTypeParameterListOwner && ((TypeScriptTypeParameterListOwner)e).getTypeParameters().length > 0)) {
            String string3 = this.myIsAsync ? "AsyncGenerator" : "Generator";
            if (string3 == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(17);
            }
            return string3;
        }
        String string4 = defaultName;
        if (string4 == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(18);
        }
        return string4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGeneratorReturnType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGeneratorReturnType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "combineObsoleteGeneratorType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doSubstitute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "combineObsoleteGeneratorType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

