/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSFunctionType,
JSUtilType {
    @NotNull
    private final List<JSParameterTypeDecorator> myParameters;
    @Nullable
    private final JSType myThisType;
    @Nullable
    private final JSType myNewType;
    @Nullable
    private final JSType myReturnType;
    private final Class[] TO_PARENTHESIZE;

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull List<? extends JSParameterTypeDecorator> parameters, @Nullable JSType returnType) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(1);
        }
        this(source, parameters, returnType, null, null);
    }

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull List<? extends JSParameterTypeDecorator> parameters, @Nullable JSType returnType, @Nullable JSType thisType, @Nullable JSType newType) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(3);
        }
        super(source);
        this.TO_PARENTHESIZE = new Class[]{JSUnionOrIntersectionType.class};
        this.myParameters = Collections.unmodifiableList(parameters);
        this.myReturnType = returnType;
        this.myThisType = thisType;
        this.myNewType = newType;
    }

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(4);
        }
        if (inputStream == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(5);
        }
        super(source);
        this.TO_PARENTHESIZE = new Class[]{JSUnionOrIntersectionType.class};
        this.myParameters = JSTypeSerializer.PARAMETER_LIST.read(source, inputStream);
        this.myThisType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        this.myNewType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        this.myReturnType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(6);
        }
        super.serialize(outputStream);
        JSTypeSerializer.PARAMETER_LIST.write(this.myParameters, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myThisType, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myNewType, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myReturnType, outputStream);
    }

    @Override
    protected final void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(8);
        }
        this.buildTypeTextImpl(format, builder, true);
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.getClass(), JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.getNewType()), JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.getThisType()), JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.getReturnType()), JSTypeResolvedHashCodeUtil.getResolvedHashCodeForDecorators(this.getParameters()));
    }

    public void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder, boolean defaultPresentation) {
        boolean typeScriptCodeFormat;
        if (format == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(10);
        }
        if (format == JSType.TypeTextFormat.CODE && this.isEcma()) {
            builder.append(this.getFunctionName());
            return;
        }
        boolean bl = typeScriptCodeFormat = (format == JSType.TypeTextFormat.CODE || format == JSType.TypeTextFormat.PRESENTABLE) && this.isTypeScript();
        if (format == JSType.TypeTextFormat.RESOLVED) {
            builder.append(this.getFunctionName());
            return;
        }
        if (!typeScriptCodeFormat && defaultPresentation) {
            builder.append("function");
        }
        builder.append("(");
        String prefix = "";
        if (this.myThisType != null) {
            builder.append("this:").appendWithParentheses(this.myThisType, format, this.TO_PARENTHESIZE);
            prefix = ", ";
        }
        if (this.myNewType != null && !typeScriptCodeFormat) {
            builder.append(prefix);
            builder.append("new:").appendWithParentheses(this.myNewType, format, this.TO_PARENTHESIZE);
            prefix = ", ";
        }
        int pIndex = 1;
        for (JSParameterTypeDecorator decorator : this.myParameters) {
            JSType parameterType = this.getParameterType(decorator, format);
            builder.append(prefix);
            if (typeScriptCodeFormat) {
                if (decorator.isRest()) {
                    builder.append("...");
                }
                builder.append(this.getParameterName(decorator, pIndex++));
                if (decorator.isOptional()) {
                    builder.append("?");
                }
                if (parameterType == null) {
                    prefix = ", ";
                    continue;
                }
                builder.append(": ");
            }
            if (parameterType == null) {
                parameterType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), false);
            }
            if (decorator.isRest()) {
                if (typeScriptCodeFormat) {
                    if (parameterType instanceof JSRestTypeImpl) {
                        ((JSRestTypeImpl)parameterType).getIterableType().buildTypeText(format, builder);
                    } else {
                        parameterType.buildTypeText(format, builder);
                        if (!(parameterType instanceof JSTupleType) && !(parameterType instanceof JSGenericTypeImpl)) {
                            builder.append("[]");
                        }
                    }
                } else {
                    builder.append("...[");
                    parameterType.buildTypeText(format, builder);
                    builder.append("]");
                }
            } else {
                builder.appendWithParentheses(parameterType, format, this.TO_PARENTHESIZE);
            }
            if (decorator.isOptional() && !typeScriptCodeFormat) {
                builder.append("=");
            }
            prefix = ", ";
        }
        builder.append(")");
        JSType returnType = this.myReturnType;
        if (returnType == null && typeScriptCodeFormat && defaultPresentation) {
            returnType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), true);
        }
        if (returnType != null) {
            builder.append(typeScriptCodeFormat && defaultPresentation ? " => " : this.getTypeSeparator()).appendWithParentheses(returnType, format, this.TO_PARENTHESIZE);
        }
    }

    @NotNull
    private String getFunctionName() {
        String string = JSTypeUtils.getFunctionTypeName(this.getSource().getScope(), false);
        if (string == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public List<Pair<String, JSParameterTypeDecorator>> getParametersWithName() {
        ArrayList<Pair<String, JSParameterTypeDecorator>> result2 = new ArrayList<Pair<String, JSParameterTypeDecorator>>();
        int i = 1;
        for (JSParameterTypeDecorator decorator : this.getParameters()) {
            result2.add((Pair<String, JSParameterTypeDecorator>)Pair.create((Object)this.getParameterName(decorator, i++), (Object)decorator));
        }
        ArrayList<Pair<String, JSParameterTypeDecorator>> arrayList = result2;
        if (arrayList == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Nullable
    protected JSType getParameterType(@NotNull JSParameterTypeDecorator decorator, @NotNull JSType.TypeTextFormat format) {
        JSType parameter;
        if (decorator == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(13);
        }
        if (format == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(14);
        }
        if ((parameter = decorator.getSimpleType()) == null) {
            parameter = JSAnyType.getWithLanguage(this.getSource().getLanguage(), false);
        }
        return parameter;
    }

    @Nullable
    protected String getParameterName(@NotNull JSParameterTypeDecorator decorator, int index) {
        if (decorator == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(15);
        }
        return decorator.getName();
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(16);
        }
        if (processingContext == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(17);
        }
        if (elementType instanceof JSFunctionTypeImpl) {
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)elementType;
            if (this.isTypeScript()) {
                return JSRecordTypeImpl.checkFunctionsArgumentsAndReturnType(this, (JSFunctionTypeImpl)elementType, processingContext);
            }
            if (this.myThisType != null && functionType.myThisType != null && !this.myThisType.isDirectlyAssignableType(functionType.myThisType, processingContext)) {
                return false;
            }
            if (this.myNewType != null && functionType.myNewType != null && !this.myNewType.isDirectlyAssignableType(functionType.myNewType, processingContext)) {
                return false;
            }
            if (this.myReturnType != null && functionType.myReturnType != null && !this.myReturnType.isDirectlyAssignableType(functionType.myReturnType, processingContext)) {
                return false;
            }
            return JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), this.getParameters(), processingContext, true, true, false);
        }
        if (elementType instanceof JSRecordType) {
            JSRecordType recordType = (JSRecordType)elementType;
            for (JSRecordType.CallSignature typeMember : recordType.getCallSignatures()) {
                if (typeMember.hasNew() || !this.isDirectlyAssignableType((JSType)typeMember.getFunctionType(), processingContext)) continue;
                return true;
            }
            return false;
        }
        if (elementType instanceof JSTypeImpl || elementType instanceof JSGenericTypeImpl) {
            if (elementType instanceof JSTypeImpl && ((JSTypeImpl)elementType).inheritsFunction()) {
                return true;
            }
            if (this.isTypeScript()) {
                JSType resolvedElementType = elementType.substitute();
                if (resolvedElementType == elementType) {
                    resolvedElementType = elementType.asRecordType();
                }
                if (resolvedElementType != elementType) {
                    return this.isDirectlyAssignableType(resolvedElementType, processingContext);
                }
            }
        } else if (elementType instanceof JSPrimitiveFunctionType || elementType instanceof JSNullType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        JSFunctionTypeImpl functionType;
        if (type == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(18);
        }
        if (!JSFunctionTypeImpl.isEquivalentToSafe(this.myThisType, (functionType = (JSFunctionTypeImpl)type).getThisType(), processingContext, allowResolve)) {
            return false;
        }
        if (!JSFunctionTypeImpl.isEquivalentToSafe(this.myNewType, functionType.getNewType(), processingContext, allowResolve)) {
            return false;
        }
        if (!JSFunctionTypeImpl.isEquivalentToSafe(this.myReturnType, functionType.getReturnType(), processingContext, allowResolve)) {
            return false;
        }
        Iterator<JSParameterTypeDecorator> iterator = functionType.getParameters().iterator();
        for (JSParameterTypeDecorator p : this.getParameters()) {
            if (!iterator.hasNext()) {
                return false;
            }
            JSParameterTypeDecorator next = iterator.next();
            JSType paramType = p.getSimpleType();
            if (p.isOptional() == next.isOptional() && p.isRest() == next.isRest() && p.isExplicitlyDeclared() == next.isExplicitlyDeclared() && JSFunctionTypeImpl.isEquivalentToSafe(paramType, next.getSimpleType(), processingContext, allowResolve)) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    private static boolean isEquivalentToSafe(@Nullable JSType lType, @Nullable JSType rType, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        return lType == rType || lType != null && lType.isEquivalentTo(rType, processingContext, allowResolve);
    }

    @NotNull
    public List<JSParameterTypeDecorator> getParameters() {
        List<JSParameterTypeDecorator> list2 = this.myParameters;
        if (list2 == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    public final JSFunctionType copyWithReturnType(@NotNull JSType newReturnType) {
        if (newReturnType == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(20);
        }
        if (newReturnType.isEquivalentTo(this.myReturnType, null)) {
            JSFunctionTypeImpl jSFunctionTypeImpl = this;
            if (jSFunctionTypeImpl == null) {
                JSFunctionTypeImpl.$$$reportNull$$$0(21);
            }
            return jSFunctionTypeImpl;
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = this.createType(this.getSource(), (Function<JSType, JSType>)Functions.id(), this.myParameters, this.myNewType, newReturnType, this.myThisType, true);
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(22);
        }
        return jSFunctionTypeImpl;
    }

    @Nullable
    public JSType getThisType() {
        return this.myThisType;
    }

    public boolean hasGenericArguments() {
        return false;
    }

    @Nullable
    public JSType getNewType() {
        return this.myNewType;
    }

    @Nullable
    public JSType getReturnType() {
        return this.myReturnType;
    }

    @Override
    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(23);
        }
        visitor.visitJSFunctionType((JSType)this);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(24);
        }
        if (this.myNewType != null) {
            this.myNewType.accept(visitor);
        }
        if (this.myReturnType != null) {
            this.myReturnType.accept(visitor);
        }
        if (this.myThisType != null) {
            this.myThisType.accept(visitor);
        }
        for (JSParameterTypeDecorator parameter : this.myParameters) {
            JSType type = parameter.getSimpleType();
            if (type == null) continue;
            type.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(25);
        }
        JSType oldNewType = this.getNewType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldNewType, childTransform);
        JSType oldReturnType = this.getReturnType();
        JSType returnType = JSTypeUtils.transformTypeHierarchySafe(oldReturnType, childTransform);
        JSType oldThis = this.getThisType();
        JSType thisType = JSTypeUtils.transformTypeHierarchySafe(oldThis, childTransform);
        boolean hasChangedParameterDecorator = false;
        ArrayList<JSParameterTypeDecorator> newParameters = new ArrayList<JSParameterTypeDecorator>();
        for (JSParameterTypeDecorator typeDecorator : this.getParameters()) {
            JSParameterTypeDecorator newDecorator = typeDecorator.copyTypeHierarchy(childTransform);
            if (newDecorator != typeDecorator) {
                hasChangedParameterDecorator = true;
            }
            newParameters.add(newDecorator);
        }
        boolean hasChanges = hasChangedParameterDecorator || oldNewType != newType || oldReturnType != returnType || oldThis != thisType;
        JSFunctionTypeImpl jSFunctionTypeImpl = this.createType(this.getSource(), childTransform, newParameters, newType, returnType, thisType, hasChanges);
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(26);
        }
        return jSFunctionTypeImpl;
    }

    @NotNull
    protected JSFunctionTypeImpl createType(@NotNull JSTypeSource newSource, @NotNull Function<JSType, JSType> childTransform, @NotNull List<JSParameterTypeDecorator> newParameters, @Nullable JSType newType, @Nullable JSType returnType, @Nullable JSType thisType, boolean hasChanges) {
        if (newSource == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(27);
        }
        if (childTransform == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(28);
        }
        if (newParameters == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(29);
        }
        if (!hasChanges) {
            JSFunctionTypeImpl jSFunctionTypeImpl = this;
            if (jSFunctionTypeImpl == null) {
                JSFunctionTypeImpl.$$$reportNull$$$0(30);
            }
            return jSFunctionTypeImpl;
        }
        if (returnType instanceof JSFreshObjectLiteralType) {
            returnType = ((JSFreshObjectLiteralType)returnType).removeFreshness();
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(newSource, newParameters, returnType, thisType, newType);
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(31);
        }
        return jSFunctionTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(32);
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(source, this.getParameters(), this.getReturnType(), this.getThisType(), this.getNewType());
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(33);
        }
        return jSFunctionTypeImpl;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordTypeImpl.CallSignatureImpl callSignature = new JSRecordTypeImpl.CallSignatureImpl(false, this);
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), Collections.singletonList(callSignature));
        if (jSRecordTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(34);
        }
        return jSRecordTypeImpl;
    }

    @Nullable
    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create(this.getFunctionName(), null);
    }

    public boolean hasQualifiedName() {
        return true;
    }

    @NotNull
    public String getDefaultValue() {
        StringBuilder function = new StringBuilder("function(");
        int i = 1;
        for (JSParameterTypeDecorator parameter : this.getParameters()) {
            function.append("p").append(i);
            JSType type = parameter.getSimpleType();
            if (type != null && DialectDetector.hasFeature(this.getSource().getSourceElement(), JSLanguageFeature.TYPES)) {
                String typeText = type.getTypeText(JSType.TypeTextFormat.CODE);
                function.append(": ").append(typeText);
            }
            function.append(",");
            ++i;
        }
        JSType returnT = this.getReturnType();
        String returnType = returnT != null && !(returnT instanceof JSVoidType) && !(returnT instanceof JSAnyType) ? "return " + JSTypeUtils.defaultValueOfType(returnT) + ";" : "";
        String string = StringUtil.trimEnd((String)function.toString(), (String)",") + "){" + returnType + "}";
        if (string == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(36);
        }
        Stream<JSType> stream = Stream.of(this);
        if (stream == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(37);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 17: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newReturnType";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersWithName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithReturnType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getParameterName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyWithReturnType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

