/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementIndexingDataImpl
implements JSElementIndexingData {
    @Nullable
    private Collection<JSImplicitElement> myElements;
    @Nullable
    private Collection<Pair<String, String>> myTypedefs;
    @Nullable
    private Collection<Pair<String, String>> myBaseTypes;
    private boolean myIsClassExplicitly;
    private boolean myIsInterfaceExplicitly;
    private boolean myAddUnderlyingElementToSymbolIndex;
    private Map<String, String> myUserStrings;

    public JSElementIndexingDataImpl() {
    }

    public JSElementIndexingDataImpl(@NotNull JSElementIndexingDataStructure structure, @Nullable PsiElement provider2) {
        if (structure == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(0);
        }
        Collection elements = structure.getImplicitElements();
        this.myElements = elements == null ? null : ContainerUtil.map((Collection)elements, s -> s.toImplicitElement(provider2));
        this.myTypedefs = structure.getTypedefs();
        this.myBaseTypes = structure.getBaseTypes();
        this.myIsClassExplicitly = structure.isClassExplicitly();
        this.myIsInterfaceExplicitly = structure.isInterfaceExplicitly();
        this.myUserStrings = structure.getUserStrings();
    }

    public void addImplicitElement(@NotNull JSImplicitElement element) {
        if (element == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(1);
        }
        if (this.myElements == null) {
            this.myElements = new SmartList();
        }
        this.myElements.add(element);
    }

    public void addImplicitElements(@NotNull Collection<JSImplicitElement> elements) {
        if (elements == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(2);
        }
        if (this.myElements == null) {
            this.myElements = new SmartList();
        }
        this.myElements.addAll(elements);
    }

    @Nullable
    public Collection<JSImplicitElement> getImplicitElements() {
        return this.myElements;
    }

    public void setImplicitElements(@Nullable Collection<JSImplicitElement> elements) {
        this.myElements = elements;
    }

    public void addAccessorsFromObjectLiteral(@NotNull JSObjectLiteralExpression objectLiteral) {
        if (objectLiteral == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(3);
        }
        JSSymbolUtil.forEachIdentifierProperty(objectLiteral, new JSSymbolUtil.PropertyProcessor(){

            @Override
            public void process(String titleCasedPropName, JSProperty property) {
                JSImplicitElementImpl.Builder getterBuilder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestGetterName(titleCasedPropName), (PsiElement)property).setProperties(JSImplicitElement.Property.GetFunction).setNamespaceExplicitlyDeclared(false);
                JSElementIndexingDataImpl.this.addImplicitElement((JSImplicitElement)getterBuilder.toImplicitElement());
                JSImplicitElementImpl.Builder setterBuilder = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestSetterName(titleCasedPropName), (PsiElement)property).setProperties(JSImplicitElement.Property.SetFunction).setNamespaceExplicitlyDeclared(false);
                JSElementIndexingDataImpl.this.addImplicitElement((JSImplicitElement)setterBuilder.toImplicitElement());
            }
        });
    }

    @Nullable
    public Collection<Pair<String, String>> getTypedefs() {
        return this.myTypedefs;
    }

    public void addTypedef(String name, String type) {
        if (this.myTypedefs == null) {
            this.myTypedefs = new SmartList();
        }
        this.myTypedefs.add((Pair<String, String>)Pair.create((Object)name, (Object)type));
    }

    @Nullable
    public Collection<Pair<String, String>> getBaseTypes() {
        return this.myBaseTypes;
    }

    public void addBaseType(@NotNull String qualifiedName, @NotNull String baseType) {
        if (qualifiedName == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(4);
        }
        if (baseType == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(5);
        }
        if (this.myBaseTypes == null) {
            this.myBaseTypes = new SmartList();
        }
        this.myBaseTypes.add((Pair<String, String>)Pair.create((Object)qualifiedName, (Object)baseType));
    }

    public boolean isClassExplicitly() {
        return this.myIsClassExplicitly;
    }

    public void setIsClassExplicitly() {
        this.myIsClassExplicitly = true;
    }

    public boolean isInterfaceExplicitly() {
        return this.myIsInterfaceExplicitly;
    }

    public void setIsInterfaceExplicitly() {
        this.myIsInterfaceExplicitly = true;
    }

    @Nullable
    public Map<String, String> getUserStrings() {
        return this.myUserStrings;
    }

    public void putUserString(@NotNull String key, @NotNull String value) {
        if (key == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(6);
        }
        if (value == null) {
            JSElementIndexingDataImpl.$$$reportNull$$$0(7);
        }
        ourUserStringKeysRegisty.checkRegistered(key);
        if (this.myUserStrings == null) {
            this.myUserStrings = new THashMap(1);
        }
        this.myUserStrings.put(key, value);
    }

    public boolean isEmpty() {
        boolean hasImplicitElements = this.getImplicitElements() != null && !this.getImplicitElements().isEmpty();
        boolean hasTypedefs = this.getTypedefs() != null && !this.getTypedefs().isEmpty();
        boolean hasBaseTypes = this.getBaseTypes() != null && !this.getBaseTypes().isEmpty();
        boolean hasUserStrings = this.getUserStrings() != null && !this.getUserStrings().isEmpty();
        return !hasImplicitElements && !hasTypedefs && !hasBaseTypes && !hasUserStrings && !this.isClassExplicitly() && !this.isInterfaceExplicitly();
    }

    public JSElementIndexingDataStructureImpl toStructure() {
        List elements = this.myElements != null ? this.myElements.stream().filter(el -> el instanceof JSIndexableImplicitElement).map(el -> (JSIndexableImplicitElement)el).map(JSIndexableImplicitElement::getStructure).collect(Collectors.toList()) : null;
        return new JSElementIndexingDataStructureImpl(elements, this.myTypedefs, this.myBaseTypes, this.myIsClassExplicitly, this.myIsInterfaceExplicitly, this.myUserStrings);
    }

    public void setAddUnderlyingElementToSymbolIndex(boolean addUnderlyingElementToSymbolIndex) {
        this.myAddUnderlyingElementToSymbolIndex = addUnderlyingElementToSymbolIndex;
    }

    public boolean addUnderlyingElementToSymbolIndex() {
        return this.myAddUnderlyingElementToSymbolIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addImplicitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addImplicitElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addAccessorsFromObjectLiteral";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addBaseType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "putUserString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

