/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.ES6ExportOnlyAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptClassTypeParametersChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptConfigAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessibilityProcessingHandler {
    protected boolean acceptPrivateMembers = true;
    protected boolean acceptProtectedMembers = true;
    private boolean acceptProtectedMembersSet;
    protected boolean processStatics;
    protected boolean allowUnqualifiedStaticsFromInstance;
    @Nullable
    protected Set<JSClass> myClassScopes;
    protected boolean myClassDeclarationStarted;
    @Nullable
    protected final PsiElement place;
    protected boolean myProcessingInheritedClasses;
    private boolean myClassScopeExplicitlySet;
    private boolean myCheckProtectedQualifier = true;
    protected static final Collection<JSAccessibilityChecker> CHECKERS = ContainerUtil.immutableList((Object[])new JSAccessibilityChecker[]{TypeScriptConfigAccessibilityChecker.INSTANCE, TypeScriptModuleAccessibilityChecker.INSTANCE, ES6ExportOnlyAccessibilityChecker.INSTANCE, TypeScriptClassTypeParametersChecker.INSTANCE});
    private static final int MAX_DEPTH = 10;

    public AccessibilityProcessingHandler(@Nullable PsiElement _place) {
        this.place = _place != null ? AccessibilityProcessingHandler.getRealElement(_place) : null;
    }

    public boolean accepts(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(0);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(1);
        }
        if (!this.checkConstructorWithNew(element, resolveProcessor)) {
            return false;
        }
        String errorFromCheckers = this.processCheckers(element, resolveProcessor);
        if (!StringUtil.isEmpty((String)errorFromCheckers)) {
            resolveProcessor.addPossibleCandidateResult(element, errorFromCheckers);
            return false;
        }
        if (this.processStatics && this.myClassDeclarationStarted && element instanceof JSImplicitElement && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Tag) {
            return false;
        }
        if (element instanceof JSVariable || element instanceof JSFunction || element instanceof JSNamespaceDeclaration || element instanceof JSLocalImplicitElementImpl) {
            return this.acceptsForMembersVisibility((JSPsiElementBase)element, resolveProcessor);
        }
        return true;
    }

    public boolean acceptsConstructorWithNew(@NotNull PsiElement constructor, @NotNull String className2) {
        if (constructor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(2);
        }
        if (className2 == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(3);
        }
        return this.checkConstructorWithNew(constructor, new SinkResolveProcessor<ResolveResultSink>(className2, this.place, new ResolveResultSink(this.place, className2)));
    }

    private static JSFunction findOwnOrParentConstructor(@NotNull JSClass jsClass, int depth) {
        JSFunction constructor;
        if (jsClass == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(4);
        }
        if ((constructor = JSResolveUtil.getClassConstructor(jsClass)) != null || depth >= 10) {
            return constructor;
        }
        JSClass[] classes = jsClass.getSuperClasses();
        if (classes.length == 0) {
            return null;
        }
        for (JSClass cl : classes) {
            constructor = AccessibilityProcessingHandler.findOwnOrParentConstructor(cl, depth + 1);
            if (constructor == null) continue;
            return constructor;
        }
        return null;
    }

    protected boolean checkConstructorWithNew(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(5);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(6);
        }
        if (this.place == null || !(this.place.getContext() instanceof JSNewExpression) || !(element instanceof JSClass)) {
            return true;
        }
        JSFunction constructor = AccessibilityProcessingHandler.findOwnOrParentConstructor((JSClass)element, 0);
        if (constructor == null) {
            return true;
        }
        AccessibilityProcessingHandler handler = new AccessibilityProcessingHandler(this.place);
        handler.myCheckProtectedQualifier = false;
        handler.startingParent(element);
        return handler.accepts((PsiElement)constructor, resolveProcessor);
    }

    protected boolean acceptsForMembersVisibility(@NotNull JSPsiElementBase element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(7);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(8);
        }
        if (!JSClassUtils.isClassMember((PsiElement)element)) {
            return true;
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        PsiElement parentOfElement = JSResolveUtil.findParent((PsiElement)element);
        if (this.needCheckAccessFromPlace(element, parentOfElement)) {
            if (!this.acceptPrivateMembers && accessType == JSAttributeList.AccessType.PRIVATE) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, element instanceof JSFunction && ((JSFunction)element).isConstructor() ? "javascript.private.constructor.is.not.accessible.message" : "javascript.private.member.is.not.accessible.message");
                return false;
            }
            if (!this.acceptProtectedMembers && accessType == JSAttributeList.AccessType.PROTECTED && (this.myClassScopes != null || AccessibilityProcessingHandler.isParentClassContext((PsiElement)element))) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, element instanceof JSFunction && ((JSFunction)element).isConstructor() ? "javascript.protected.constructor.is.not.accessible.message" : "javascript.protected.member.is.not.accessible.message");
                return false;
            }
        }
        if (JSUtils.isPrivateFieldSharpAccessContext(this.place)) {
            if (accessType != JSAttributeList.AccessType.PRIVATE) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.public.member.is.not.accessible.via.sharp.message");
                return false;
            }
        } else if (JSUtils.isPrivateSharpItem((PsiElement)element) && resolveProcessor.getResultSink() instanceof ResolveResultSink) {
            resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.private.member.is.not.accessible.without.sharp.message");
            return false;
        }
        if (this.processStatics) {
            if (element.getJSContext() == JSContext.INSTANCE) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.instance.member.is.not.accessible.message");
                return false;
            }
        } else if (this.myClassDeclarationStarted && !this.allowUnqualifiedStaticsFromInstance && element.getJSContext() == JSContext.STATIC) {
            resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.static.member.is.not.accessible.message");
            return false;
        }
        return true;
    }

    private boolean needCheckAccessFromPlace(@NotNull JSPsiElementBase element, PsiElement parentOfElement) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(9);
        }
        if (this.place != null && parentOfElement instanceof TypeScriptModule) {
            PsiElement parent = JSResolveUtil.findParent(this.place);
            return parent != null && !PsiTreeUtil.isAncestor((PsiElement)parentOfElement, (PsiElement)parent, (boolean)false);
        }
        return JSResolveUtil.getClassOfContext(this.place) != JSUtils.getMemberContainingClass((PsiElement)element);
    }

    protected Collection<JSAccessibilityChecker> getCheckers() {
        return CHECKERS;
    }

    @Nullable
    protected String processCheckers(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(10);
        }
        if (resolveProcessor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(11);
        }
        for (JSAccessibilityChecker checker : this.getCheckers()) {
            String check;
            if (!checker.isAvailable(this, resolveProcessor) || StringUtil.isEmpty((String)(check = checker.check(this.place, element)))) continue;
            return check;
        }
        return null;
    }

    protected static boolean isParentClassContext(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(12);
        }
        return (parent = JSResolveUtil.findParent(element)) instanceof JSClass || parent instanceof TypeScriptFunction && ((TypeScriptFunction)parent).isConstructor();
    }

    public void setTypeName(String qualifiedName) {
    }

    public void configureClassScope(JSClass jsClass) {
        this.myClassScopeExplicitlySet = true;
        this.configureCurrentClassScope(jsClass);
    }

    @Nullable
    private static JSClass getParentClass(@NotNull PsiElement element) {
        if (element == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(13);
        }
        return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
    }

    private void configureCurrentClassScope(@Nullable JSClass jsClass) {
        if (jsClass != null) {
            jsClass = AccessibilityProcessingHandler.getRealElement(jsClass);
            this.myClassScopes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<JSClass>(){

                public int computeHashCode(JSClass object) {
                    String name = object.getQualifiedName();
                    return name != null ? name.hashCode() : object.hashCode();
                }

                public boolean equals(JSClass left, JSClass right) {
                    return left.isEquivalentTo((PsiElement)right);
                }
            });
            this.myClassScopes.add(jsClass);
            JSClass parentClass = AccessibilityProcessingHandler.getParentClass((PsiElement)jsClass);
            while (parentClass != null) {
                this.myClassScopes.add(parentClass);
                parentClass = AccessibilityProcessingHandler.getParentClass((PsiElement)parentClass);
            }
            this.acceptProtectedMembersSet = false;
        } else {
            this.acceptProtectedMembers = false;
            this.acceptProtectedMembersSet = true;
        }
    }

    @NotNull
    private static <T extends PsiElement> T getRealElement(@NotNull T psiElement) {
        PsiElement realElement;
        if (psiElement == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(14);
        }
        Object object = (realElement = CompletionUtilCoreImpl.getOriginalElement(psiElement)) != null ? realElement : psiElement;
        if (object == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(15);
        }
        return (T)object;
    }

    public void startingParent(PsiElement parent) {
        this.myClassDeclarationStarted = parent instanceof JSClass;
        if (parent instanceof JSClass) {
            JSClass jsClass = AccessibilityProcessingHandler.getRealElement((JSClass)parent);
            if (!this.myProcessingInheritedClasses && !this.myClassScopeExplicitlySet) {
                this.configureCurrentClassScope(JSResolveUtil.getClassOfContext(this.place));
            }
            if (this.acceptPrivateMembers) {
                boolean bl = this.acceptPrivateMembers = this.myClassScopes != null && this.myClassScopes.contains(jsClass);
            }
            if (!this.acceptProtectedMembersSet) {
                this.acceptProtectedMembersSet = true;
                if (this.myClassScopes != null) {
                    this.acceptProtectedMembers = this.computeAcceptProtected(jsClass);
                }
            }
        } else if (parent instanceof JSAttributeListOwner) {
            if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)parent, JSAttributeList.ModifierType.STATIC)) {
                this.processStatics = true;
            }
        } else if (parent instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof XmlTag) {
            this.processStatics = false;
        }
    }

    private boolean computeAcceptProtected(final @NotNull JSClass jsClass) {
        boolean acceptProtected;
        if (jsClass == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(16);
        }
        boolean bl = acceptProtected = this.myClassScopes != null && this.myClassScopes.contains(jsClass);
        if (this.place == null || this.myClassScopes == null) {
            return acceptProtected;
        }
        for (PsiElement psiElement : this.myClassScopes) {
            if (acceptProtected || !(psiElement instanceof JSClass)) continue;
            boolean b = psiElement.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){
                {
                    super(name);
                    this.setTypeContext(true);
                    this.setToProcessMembers(false);
                    this.setToProcessHierarchy(true);
                    this.setLocalResolve(true);
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (!(element instanceof JSClass)) {
                        return true;
                    }
                    return !jsClass.isEquivalentTo(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$2";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, ResolveState.initial(), psiElement, psiElement);
            boolean bl2 = acceptProtected = !b;
            if (!(this.place instanceof JSReferenceExpression) || !this.myCheckProtectedQualifier || ((JSReferenceExpression)this.place).getQualifier() instanceof JSSuperExpression) continue;
            acceptProtected = acceptProtected && this.processStatics;
        }
        return acceptProtected;
    }

    public void setProcessStatics(boolean processStatics) {
        this.processStatics = processStatics;
    }

    public void setAllowUnqualifiedStaticsFromInstance(boolean allowUnqualifiedStaticsFromInstance) {
        this.allowUnqualifiedStaticsFromInstance = allowUnqualifiedStaticsFromInstance;
    }

    public boolean isProcessStatics() {
        return this.processStatics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends JSResolveProcessor> boolean processWithStatic(@NotNull T processor, boolean newStatic, @NotNull Supplier<Boolean> action) {
        if (processor == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(17);
        }
        if (action == null) {
            AccessibilityProcessingHandler.$$$reportNull$$$0(18);
        }
        if (!(processor instanceof ResolveProcessor)) {
            return action.get();
        }
        AccessibilityProcessingHandler handler = ((ResolveProcessor)processor).getAccessibilityProcessingHandler();
        boolean oldValue = handler.processStatics;
        handler.setProcessStatics(newStatic);
        try {
            boolean bl = action.get();
            return bl;
        }
        finally {
            handler.setProcessStatics(oldValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsConstructorWithNew";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findOwnOrParentConstructor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorWithNew";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptsForMembersVisibility";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "needCheckAccessFromPlace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processCheckers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isParentClassContext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParentClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRealElement";
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeAcceptProtected";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processWithStatic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

