/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexingDataHolder;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSCachingTypeOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSPropertyStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyImpl
extends JSQualifiedNamedElementBaseImpl<JSPropertyStub>
implements JSProperty,
JSInitializerOwner,
JSCachingTypeOwner,
StubBasedPsiElement<JSPropertyStub>,
JSIndexingDataHolder {
    private static final TokenSet STUB_SAFE_PROPERTY_INITIALIZERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_EXPRESSIONS, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.OBJECT_LITERAL_EXPRESSION, JSStubElementTypes.LITERAL_EXPRESSION})});
    private static final TokenSet PROPERTY_NAME_SEARCH_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.PROPERTY_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.COLON})});
    private static Map<String, SmartList<FrameworkIndexingHandler>> ourFrameworkHandlers = null;

    public JSPropertyImpl(ASTNode node) {
        super(node);
    }

    public JSPropertyImpl(JSPropertyStub stub) {
        this(stub, (IStubElementType)JSStubElementTypes.PROPERTY);
    }

    protected JSPropertyImpl(JSPropertyStub stub, IStubElementType type) {
        super(stub, type);
    }

    public PsiReference getReference() {
        return this.getPropertyNameReference();
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray;
        PsiPolyVariantReference propertyNameReference = this.getPropertyNameReference();
        if (propertyNameReference != null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = propertyNameReference;
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            JSPropertyImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    @Nullable
    public PsiPolyVariantReference getPropertyNameReference() {
        return (PsiPolyVariantReference)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            String name = this.getName();
            return CachedValueProvider.Result.create((Object)(name != null ? new JSPropertyNameReference(this, name) : null), (Object[])new Object[]{this});
        });
    }

    public String getName() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return JSPsiImplUtils.getNameFromIdentifier(node);
        }
        return null;
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            JSNamespace jSNamespace = stub.getJSNamespace();
            if (jSNamespace == null) {
                JSPropertyImpl.$$$reportNull$$$0(1);
            }
            return jSNamespace;
        }
        JSNamespace jSNamespace = this.getCachedData().mySymbolNamespace;
        if (jSNamespace == null) {
            JSPropertyImpl.$$$reportNull$$$0(2);
        }
        return jSNamespace;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        JSNamespace symbolNamespace = this.getCachedData().mySymbolNamespace;
        return symbolNamespace.isLocal() ? null : symbolNamespace.getQualifiedName();
    }

    public boolean isNamespaceExplicitlyDeclared() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getCachedData().mySymbolNamespace.isExplicitlyDeclared();
    }

    private JSPropertyCachedData getCachedData() {
        return JSPropertyImpl.getCachedData(this);
    }

    public static JSPropertyCachedData getCachedData(@NotNull JSProperty property) {
        if (property == null) {
            JSPropertyImpl.$$$reportNull$$$0(3);
        }
        return (JSPropertyCachedData)CachedValuesManager.getCachedValue((PsiElement)property, () -> {
            JSPropertyCachedData data = JSPropertyImpl.calculateCachedData(property);
            return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{property});
        });
    }

    @NotNull
    private static JSPropertyCachedData calculateCachedData(@NotNull JSProperty property) {
        if (property == null) {
            JSPropertyImpl.$$$reportNull$$$0(4);
        }
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
        JSDocComment ownDocComment = JSDocumentationUtils.findOwnDocComment((PsiElement)property);
        JSAnyType symbolNamespace = null;
        if (ownDocComment != null) {
            JSAttributeList.AccessType docCommentAccessType;
            JSQualifiedName namespace = ownDocComment.getNamespace();
            boolean namespaceExplicitlyDeclared = ownDocComment.isNamespaceExplicitlyDeclared();
            JSContext jsContext = ownDocComment.getJSContext();
            if (namespaceExplicitlyDeclared || namespace != null) {
                symbolNamespace = JSNamedTypeFactory.createNamespace(namespace, jsContext, (PsiElement)property, namespaceExplicitlyDeclared);
            }
            if ((docCommentAccessType = ownDocComment.getAccessType()) != null) {
                accessType = docCommentAccessType;
            }
        }
        PsiElement parent = property.getParent();
        if (symbolNamespace == null && parent instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression objectLiteral = (JSObjectLiteralExpression)parent;
            JSQualifiedName namespace = JSPropertyImpl.findNamespaceFromSpecialProperties(objectLiteral);
            symbolNamespace = namespace != null ? JSNamedTypeFactory.createNamespace(namespace, JSContext.UNKNOWN, (PsiElement)property, true) : JSSymbolUtil.findNamespace((JSExpression)objectLiteral);
        }
        if (symbolNamespace == null) {
            symbolNamespace = JSAnyType.get((PsiElement)property, false);
        }
        JSPropertyCachedData jSPropertyCachedData = new JSPropertyCachedData(symbolNamespace, accessType);
        if (jSPropertyCachedData == null) {
            JSPropertyImpl.$$$reportNull$$$0(5);
        }
        return jSPropertyCachedData;
    }

    @Nullable
    public static JSQualifiedName findNamespaceFromSpecialProperties(JSObjectLiteralExpression expression) {
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)expression)) {
            String context = handler.resolveContextFromProperty(expression, true);
            if (context == null) continue;
            return JSQualifiedNameImpl.fromQualifiedName(context);
        }
        return null;
    }

    public ASTNode findNameIdentifier() {
        return JSPropertyImpl.findNameIdentifier(this.getNode());
    }

    public static ASTNode findNameIdentifier(ASTNode myNode) {
        ASTNode funExprNode;
        ASTNode nameNode = myNode.findChildByType(PROPERTY_NAME_SEARCH_SET);
        if (nameNode == null && (funExprNode = myNode.findChildByType(JSElementTypes.FUNCTION_EXPRESSIONS)) != null) {
            ASTNode firstIdentifier = funExprNode.findChildByType(JSKeywordSets.IDENTIFIER_NAMES);
            if ((JSPropertyImpl.isGetIdentifier(firstIdentifier) || JSPropertyImpl.isSetIdentifier(firstIdentifier)) && firstIdentifier.getTreeNext() != null) {
                return funExprNode.findChildByType(JSKeywordSets.IDENTIFIER_NAMES, firstIdentifier.getTreeNext());
            }
            return firstIdentifier;
        }
        return nameNode != null && JSKeywordSets.PROPERTY_NAMES.contains(nameNode.getElementType()) ? nameNode : null;
    }

    public boolean isGetProperty() {
        JSFunctionExpression functionExpression = this.tryGetFunctionInitializer();
        return functionExpression != null && functionExpression.isGetProperty();
    }

    @Nullable
    static ASTNode findAccessNodeAsIdentifier(IElementType accessType, ASTNode funExprNode) {
        ASTNode maybeAccessNode = funExprNode.findChildByType(JSTokenTypes.IDENTIFIER);
        if (maybeAccessNode != null) {
            return accessType == JSTokenTypes.GET_KEYWORD && JSPropertyImpl.isGetIdentifier(maybeAccessNode) || accessType == JSTokenTypes.SET_KEYWORD && JSPropertyImpl.isSetIdentifier(maybeAccessNode) ? maybeAccessNode : null;
        }
        return null;
    }

    private static boolean isGetIdentifier(ASTNode node) {
        return node != null && node.getElementType() == JSTokenTypes.GET_KEYWORD;
    }

    private static boolean isSetIdentifier(ASTNode node) {
        return node != null && node.getElementType() == JSTokenTypes.SET_KEYWORD;
    }

    public boolean isSetProperty() {
        JSFunctionExpression functionExpression = this.tryGetFunctionInitializer();
        return functionExpression != null && functionExpression.isSetProperty();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSPropertyImpl.$$$reportNull$$$0(6);
        }
        ASTNode renamedNode = this.findNameIdentifier();
        assert (renamedNode != null);
        ASTNode nameElement = JSChangeUtil.createPropertyNameWithContext(name, renamedNode);
        renamedNode.getTreeParent().replaceChild(renamedNode, nameElement);
        return this;
    }

    public JSExpression getValue() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public JSExpression getInitializer() {
        return this.getValue();
    }

    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSPropertyImpl.$$$reportNull$$$0(7);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSProperty((JSProperty)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSPropertyImpl.$$$reportNull$$$0(8);
        }
        if (state == null) {
            JSPropertyImpl.$$$reportNull$$$0(9);
        }
        if (place == null) {
            JSPropertyImpl.$$$reportNull$$$0(10);
        }
        if (JSPropertyImpl.shouldProcessProperty(lastParent, place)) {
            return processor.execute((PsiElement)this, state);
        }
        return true;
    }

    static boolean shouldProcessProperty(PsiElement lastParent, @NotNull PsiElement place) {
        if (place == null) {
            JSPropertyImpl.$$$reportNull$$$0(11);
        }
        return lastParent == null && place instanceof JSProperty || JSPropertyImpl.placeToProcessProperties(place);
    }

    static boolean placeToProcessProperties(PsiElement place) {
        return place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() instanceof JSThisExpression;
    }

    public int getTextOffset() {
        ASTNode name = this.findNameIdentifier();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        JSFunctionExpression value = this.tryGetFunctionInitializer();
        if (value != null) {
            ((JSFunctionBaseImpl)value).clearCaches();
        }
    }

    public Icon getIcon(int flags) {
        return JSPropertyImpl.getIcon((JSPsiElementBase)this, this.tryGetFunctionInitializer() != null ? PlatformIcons.METHOD_ICON : PlatformIcons.PROPERTY_ICON, flags);
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof JSObjectLiteralExpression) {
            JSChangeUtil.removeRangeWithRemovalOfCommas((PsiElement)this, (PsiElement[])((JSObjectLiteralExpression)parent).getPropertiesIncludingSpreads());
        }
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    private Collection<FrameworkIndexingHandler> getFrameworkHandlersForPropertyName(String name) {
        if (ourFrameworkHandlers == null) {
            THashMap result2 = new THashMap();
            for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions(this)) {
                for (String s : handler.interestedProperties()) {
                    SmartList handlersForPropertyName = (SmartList)result2.get(s);
                    if (handlersForPropertyName == null) {
                        handlersForPropertyName = new SmartList();
                        result2.put(s, handlersForPropertyName);
                    }
                    handlersForPropertyName.add((Object)handler);
                }
            }
            ourFrameworkHandlers = result2;
        }
        return (Collection)ourFrameworkHandlers.get(name);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        String name = this.getName();
        boolean toProcessProperty = true;
        Collection<FrameworkIndexingHandler> handlers = this.getFrameworkHandlersForPropertyName(name);
        JSElementIndexingDataImpl indexingData = null;
        if (name != null && handlers != null) {
            indexingData = new JSElementIndexingDataImpl();
            for (FrameworkIndexingHandler f : handlers) {
                if (f.processProperty(name, this, indexingData)) continue;
                toProcessProperty = false;
            }
            if (!toProcessProperty) {
                return indexingData;
            }
            indexingData = null;
        }
        for (FrameworkIndexingHandler indexingHandler : FrameworkIndexingHandler.getExtensions(this)) {
            indexingData = indexingHandler.processAnyProperty(this, indexingData);
        }
        return indexingData;
    }

    @Nullable
    public JSElementIndexingData getIndexingData() {
        return JSImplicitElementProviderImpl.getIndexingData(this);
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                JSPropertyImpl.$$$reportNull$$$0(12);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = this.getCachedData().myAccessType;
        if (accessType == null) {
            JSPropertyImpl.$$$reportNull$$$0(13);
        }
        return accessType;
    }

    @Nullable
    public String getInitializerReference() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            return stub.getInitializerReference();
        }
        JSExpression value = this.getValue();
        if (value instanceof JSReferenceExpression && ((JSReferenceExpression)value).getQualifier() == null) {
            return ((JSReferenceExpression)value).getReferencedName();
        }
        return null;
    }

    @Nullable
    public JSFunctionExpression tryGetFunctionInitializer() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            StubElement type = StubTreeUtil.findChildStubByType(stub, JSElementTypes.FUNCTION_EXPRESSIONS);
            return type != null ? (JSFunctionExpression)type.getPsi() : null;
        }
        JSExpression value = this.getValue();
        return value instanceof JSFunctionExpression ? (JSFunctionExpression)value : null;
    }

    @Nullable
    public JSObjectLiteralExpression getObjectLiteralExpressionInitializer() {
        return (JSObjectLiteralExpression)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
    }

    @Nullable
    public JSLiteralExpression getLiteralExpressionInitializer() {
        return (JSLiteralExpression)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.LITERAL_EXPRESSION);
    }

    @NotNull
    public JSContext getJSContext() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSPropertyImpl.$$$reportNull$$$0(14);
            }
            return jSContext;
        }
        JSContext jSContext = this.getCachedData().mySymbolNamespace.getJSContext();
        if (jSContext == null) {
            JSPropertyImpl.$$$reportNull$$$0(15);
        }
        return jSContext;
    }

    @Nullable
    private JSType findTypeFromJSDoc() {
        String typeName;
        JSQualifiedNamedElement element;
        PsiElement parent = this.getParent();
        String enumType = JSDocumentationUtils.findEnumType(parent);
        if (enumType != null && parent instanceof JSObjectLiteralExpression && (element = JSPsiImplUtils.getInitializedElement((JSExpression)parent)) != null && (typeName = element.getQualifiedName()) != null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(this, true);
            JSType enumNamespace = JSNamedTypeFactory.createType(typeName, source, JSContext.STATIC);
            JSType enumElementType = JSTypeUtils.createType(enumType, source);
            return enumElementType != null ? new JSCompositeTypeImpl(source, enumNamespace, enumElementType) : enumNamespace;
        }
        String s = JSDocumentationUtils.findType(this);
        if (s != null) {
            return JSTypeUtils.createType(s, JSTypeSourceFactory.createTypeSource(this, true));
        }
        return null;
    }

    @Override
    @Nullable
    public JSType calculateType() {
        JSTypeHelper typeHelper = JSDialectSpecificHandlersFactory.forElement(this).getTypeHelper();
        if (DialectDetector.isJavaScript(this)) {
            return this.calculateTypeForJavaScript(typeHelper);
        }
        return typeHelper.getTypeForIndexing(this.getValue(), this);
    }

    @Nullable
    private JSType calculateTypeForJavaScript(@NotNull JSTypeHelper typeHelper) {
        JSType typeFromJSDoc;
        if (typeHelper == null) {
            JSPropertyImpl.$$$reportNull$$$0(16);
        }
        if ((typeFromJSDoc = this.findTypeFromJSDoc()) != null) {
            return typeFromJSDoc;
        }
        JSType type = typeHelper.getTypeForIndexing(this.getValue(), this);
        if (type != null) {
            boolean isConstProperty;
            boolean bl = isConstProperty = this.isGetProperty() || type instanceof JSRequireCallExpressionType;
            if (!isConstProperty) {
                JSPropertyImpl parent = this;
                while ((parent = parent.getParent()) instanceof JSObjectLiteralExpression || parent instanceof JSProperty) {
                }
                isConstProperty = JSPropertyImpl.isDirectlyExported(parent);
            }
            if (!isConstProperty) {
                type = type.copyWithStrict(false);
            }
        }
        return type;
    }

    private static boolean isDirectlyExported(@NotNull PsiElement expressionParent) {
        JSQualifiedName name;
        JSExpression expression;
        JSExpression lOperand;
        JSAttributeList attributeList;
        if (expressionParent == null) {
            JSPropertyImpl.$$$reportNull$$$0(17);
        }
        if (expressionParent instanceof JSExportAssignment) {
            return true;
        }
        if (expressionParent instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)expressionParent).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
            return true;
        }
        return expressionParent instanceof JSAssignmentExpression && (lOperand = ((JSAssignmentExpression)expressionParent).getLOperand()) instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && (CommonJSUtil.isExportNamespace(name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)expression))) || name != null && CommonJSUtil.isExportNamespace(name.getParent()));
    }

    public boolean canBeLocallyEvaluated() {
        return !this.isGetProperty() && !this.isSetProperty();
    }

    @Override
    public boolean isExported() {
        return false;
    }

    @Override
    public boolean isExportedWithDefault() {
        return false;
    }

    @Nullable
    public JSExpression getInitializerOrStub() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            StubElement type = StubTreeUtil.findChildStubByType(stub, STUB_SAFE_PROPERTY_INITIALIZERS);
            return type != null ? (JSExpression)ObjectUtils.tryCast((Object)type.getPsi(), JSExpression.class) : null;
        }
        return this.getInitializer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSPropertyImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHelper";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSPropertyImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCachedData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCachedData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateCachedData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateTypeForJavaScript";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyExported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSPropertyCachedData {
        @NotNull
        public final JSNamespace mySymbolNamespace;
        @NotNull
        public final JSAttributeList.AccessType myAccessType;

        private JSPropertyCachedData(@NotNull JSNamespace symbolNamespace, @NotNull JSAttributeList.AccessType type) {
            if (symbolNamespace == null) {
                JSPropertyCachedData.$$$reportNull$$$0(0);
            }
            if (type == null) {
                JSPropertyCachedData.$$$reportNull$$$0(1);
            }
            this.mySymbolNamespace = symbolNamespace;
            this.myAccessType = type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbolNamespace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/impl/JSPropertyImpl$JSPropertyCachedData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

