/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeLocalDependenciesAction
extends AnAction
implements DumbAware {
    public InstallNodeLocalDependenciesAction() {
        super("Run 'npm install'", null, AllIcons.Actions.Install);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        VirtualFile packageJson = InstallNodeLocalDependenciesAction.getPackageJsonFile(e);
        boolean show = project != null && packageJson != null;
        e.getPresentation().setEnabledAndVisible(show);
        if (show) {
            e.getPresentation().setText("Run '" + NpmManager.getInstance(project).getNpmInstallPresentableText() + "'");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        VirtualFile packageJson = InstallNodeLocalDependenciesAction.getPackageJsonFile(e);
        if (project != null && packageJson != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
        }
    }

    @Nullable
    private static VirtualFile getPackageJsonFile(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(2);
        }
        if ((file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && PackageJsonUtil.isPackageJsonFile(file2) && file2.isValid()) {
            return file2;
        }
        return null;
    }

    public static void runAndShowConsole(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(3);
        }
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(4);
        }
        InstallNodeLocalDependenciesAction.runAndShowConsole(project, Collections.singletonList(packageJson));
    }

    public static void runAndShowConsole(@NotNull Project project, final @NotNull List<VirtualFile> packageJsonFiles) {
        VirtualFile packageJson;
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(5);
        }
        if (packageJsonFiles == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(6);
        }
        if ((packageJson = (VirtualFile)ContainerUtil.getFirstItem(packageJsonFiles)) == null) {
            return;
        }
        InstallNodeLocalDependenciesAction.saveFile(packageJson);
        final NpmCommand npmCommand = NpmCommand.INSTALL;
        final String title = InstallNodeLocalDependenciesAction.getTitle(project, packageJson);
        ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(project, DefaultRunExecutor.getRunExecutorInstance()).runProfile(new RunProfile(){

            public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new MyRunProfileState(environment.getProject(), packageJson, npmCommand, packageJsonFiles.subList(1, packageJsonFiles.size()));
            }

            @NotNull
            public String getName() {
                String string = title;
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            public Icon getIcon() {
                return AllIcons.Actions.Install;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environment";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
    }

    @NotNull
    private static String getTitle(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(7);
        }
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(8);
        }
        String title = NpmManager.getInstance(project).getNpmInstallPresentableText();
        VirtualFile dir = packageJson.getParent();
        if (dir != null) {
            title = title + " in " + JsbtUtil.getRelativePath(project, dir);
        }
        String string = title;
        if (string == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    static void saveFile(@NotNull VirtualFile file2) {
        Document doc;
        FileDocumentManager fileDocumentManager;
        if (file2 == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(10);
        }
        if ((fileDocumentManager = FileDocumentManager.getInstance()).isFileModified(file2) && (doc = fileDocumentManager.getDocument(file2)) != null) {
            fileDocumentManager.saveDocument(doc);
        }
    }

    @NotNull
    private static NodeCommandLineConfigurator getCommandLineConfigurer(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles) throws ExecutionException {
        NodeCommandLineConfigurator nodeCommandLineConfigurator;
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(11);
        }
        if (packageJsonFiles == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(12);
        }
        try {
            nodeCommandLineConfigurator = NodeCommandLineConfigurator.find(NodeJsInterpreterManager.getInstance(project).getInterpreterRef(), project);
        }
        catch (ExecutionException e) {
            throw new NodeInterpreterException(project, packageJsonFiles, e.getMessage());
        }
        if (nodeCommandLineConfigurator == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(13);
        }
        return nodeCommandLineConfigurator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineConfigurer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runAndShowConsole";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 9: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommandLineConfigurer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeInterpreterException
    extends ExecutionException
    implements HyperlinkListener {
        private final Project myProject;
        private final List<VirtualFile> myPackageJsonFiles;

        private NodeInterpreterException(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles, @NotNull String details) {
            if (project == null) {
                NodeInterpreterException.$$$reportNull$$$0(0);
            }
            if (packageJsonFiles == null) {
                NodeInterpreterException.$$$reportNull$$$0(1);
            }
            if (details == null) {
                NodeInterpreterException.$$$reportNull$$$0(2);
            }
            super(details + "<p/>Please specify local Node.js interpreter in <a href=''>Node.js and NPM</a>");
            this.myProject = project;
            this.myPackageJsonFiles = packageJsonFiles;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                NodeJSSettingsManager.editSettingsAppropriately(this.myProject);
                NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter();
                try {
                    NodeJsLocalInterpreter.castAndValidate(interpreter);
                    InstallNodeLocalDependenciesAction.runAndShowConsole(this.myProject, this.myPackageJsonFiles);
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageJsonFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "details";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$NodeInterpreterException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRunProfileState
    implements RunProfileState {
        private final Project myProject;
        private final VirtualFile myPackageJson;
        private final NpmCommand myNpmCommand;
        private final List<VirtualFile> myEnqueuedPackageJsonFiles;

        private MyRunProfileState(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull NpmCommand npmCommand, @NotNull List<VirtualFile> enqueuedPackageJsonFiles) {
            if (project == null) {
                MyRunProfileState.$$$reportNull$$$0(0);
            }
            if (packageJson == null) {
                MyRunProfileState.$$$reportNull$$$0(1);
            }
            if (npmCommand == null) {
                MyRunProfileState.$$$reportNull$$$0(2);
            }
            if (enqueuedPackageJsonFiles == null) {
                MyRunProfileState.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myPackageJson = packageJson;
            this.myNpmCommand = npmCommand;
            this.myEnqueuedPackageJsonFiles = enqueuedPackageJsonFiles;
        }

        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            GeneralCommandLine commandLine;
            NodePackage pkg;
            VirtualFile dir;
            if (runner == null) {
                MyRunProfileState.$$$reportNull$$$0(4);
            }
            if ((dir = this.myPackageJson.getParent()) == null) {
                throw new ExecutionException("Cannot determine package.json directory");
            }
            List packageJsonFiles = ContainerUtil.concat(Collections.singletonList(this.myPackageJson), this.myEnqueuedPackageJsonFiles);
            NodeCommandLineConfigurator configurer = InstallNodeLocalDependenciesAction.getCommandLineConfigurer(this.myProject, packageJsonFiles);
            ConsoleCommandLineFolder folder = new ConsoleCommandLineFolder(new String[0]);
            try {
                pkg = NpmManager.getInstance(this.myProject).getPackageOrThrow();
                commandLine = MyRunProfileState.createCommandLine(configurer, dir, pkg, this.myNpmCommand, folder);
            }
            catch (ExecutionException e) {
                throw new NpmManager.InvalidNpmPackageException(this.myProject, e.getMessage() + "<p/>Please specify <a href=''>Package Manager</a>.", () -> InstallNodeLocalDependenciesAction.runAndShowConsole(this.myProject, packageJsonFiles));
            }
            OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, true);
            final Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(this.myProject).externalUpdateStarted(this.myPackageJson, null);
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            ConsoleView console = this.createConsole((ProcessHandler)processHandler, dir);
            console.attachToProcess((ProcessHandler)processHandler);
            ConsoleProgress.install(console, (ProcessHandler)processHandler);
            folder.foldCommandLine(console, (ProcessHandler)processHandler);
            ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(this.myProject, NpmManager.getNpmInstallPresentableText(pkg));
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.doWhenRefreshed(dir, () -> {
                        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(myProject);
                        done.run();
                        DaemonCodeAnalyzer.getInstance((Project)myProject).restart();
                        if (event.getExitCode() == 0 && !myEnqueuedPackageJsonFiles.isEmpty()) {
                            this.scheduleNextInstall();
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState$1", "processTerminated"));
                }
            });
            AnAction[] actions = console instanceof TerminalExecutionConsole ? ((TerminalExecutionConsole)console).detachConsoleActions(true) : AnAction.EMPTY_ARRAY;
            return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler, actions);
        }

        private void doWhenRefreshed(@NotNull VirtualFile dir, @NotNull Runnable onDone) {
            if (dir == null) {
                MyRunProfileState.$$$reportNull$$$0(5);
            }
            if (onDone == null) {
                MyRunProfileState.$$$reportNull$$$0(6);
            }
            new SingleAlarm(() -> ReadAction.run(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                HashSet<VirtualFile> refreshDirs = new HashSet<VirtualFile>();
                refreshDirs.add(dir);
                PackageJsonUtil.processUpPackageJsonFiles(this.myProject, dir, (Processor<? super VirtualFile>)((Processor)packageJsonFile -> {
                    ContainerUtil.addIfNotNull((Collection)refreshDirs, (Object)packageJsonFile.getParent());
                    return true;
                }));
                AtomicInteger count = new AtomicInteger(refreshDirs.size());
                for (VirtualFile refreshDir : refreshDirs) {
                    refreshDir.refresh(true, true, () -> {
                        if (count.decrementAndGet() == 0 && !this.myProject.isDisposed()) {
                            onDone.run();
                        }
                    });
                }
            }), 300, (Disposable)this.myProject, Alarm.ThreadToUse.POOLED_THREAD).request();
        }

        private void scheduleNextInstall() {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myProject).addRequest(() -> InstallNodeLocalDependenciesAction.runAndShowConsole(this.myProject, this.myEnqueuedPackageJsonFiles), 2000);
        }

        @NotNull
        private ConsoleView createConsole(@NotNull ProcessHandler processHandler, @Nullable VirtualFile dir) {
            if (processHandler == null) {
                MyRunProfileState.$$$reportNull$$$0(7);
            }
            ConsoleView consoleView = NodeCommandLineUtil.createConsole(processHandler, this.myProject, false);
            consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myProject, dir));
            ConsoleView consoleView2 = consoleView;
            if (consoleView2 == null) {
                MyRunProfileState.$$$reportNull$$$0(8);
            }
            return consoleView2;
        }

        @NotNull
        private static GeneralCommandLine createCommandLine(@NotNull NodeCommandLineConfigurator configurer, @NotNull VirtualFile workingDir, @NotNull NodePackage npmPackage, @NotNull NpmCommand npmCommand, @NotNull ConsoleCommandLineFolder folder) throws ExecutionException {
            if (configurer == null) {
                MyRunProfileState.$$$reportNull$$$0(9);
            }
            if (workingDir == null) {
                MyRunProfileState.$$$reportNull$$$0(10);
            }
            if (npmPackage == null) {
                MyRunProfileState.$$$reportNull$$$0(11);
            }
            if (npmCommand == null) {
                MyRunProfileState.$$$reportNull$$$0(12);
            }
            if (folder == null) {
                MyRunProfileState.$$$reportNull$$$0(13);
            }
            GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLine(true);
            commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
            NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
            commandLine.setWorkDirectory(workingDir.getPath());
            commandLine.setCharset(StandardCharsets.UTF_8);
            String cliJsFilePath = NpmUtil.getValidNpmCliJsFilePath(npmPackage);
            commandLine.addParameter(cliJsFilePath);
            boolean yarn = NpmUtil.isYarnAlikePackage(npmPackage);
            folder.addPlaceholderText(NpmManager.getNpmPackagePresentableName(yarn));
            commandLine.addParameter(npmCommand.getCliOption(yarn));
            folder.addLastParameterFrom(commandLine);
            if (!yarn) {
                commandLine.addParameter("--scripts-prepend-node-path=auto");
            }
            configurer.configure(commandLine);
            GeneralCommandLine generalCommandLine = commandLine;
            if (generalCommandLine == null) {
                MyRunProfileState.$$$reportNull$$$0(14);
            }
            return generalCommandLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 2: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npmCommand";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enqueuedPackageJsonFiles";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onDone";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurer";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDir";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npmPackage";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConsole";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCommandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doWhenRefreshed";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createConsole";
                    break;
                }
                case 8: 
                case 14: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createCommandLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

