/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jslint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.intellij.lang.javascript.linter.jslint.JSLintOption;
import com.intellij.lang.javascript.linter.jslint.JSLintOptionsState;
import com.intellij.lang.javascript.linter.jslint.JSLintState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.CustomFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLintOptionsView {
    private static final JSLintOption[][] TOLERATE_CHECKBOX_OPTIONS_LAYOUT = new JSLintOption[][]{{JSLintOption.BITWISE}, {JSLintOption.EVAL}, {JSLintOption.FOR}, {JSLintOption.MULTIVAR}, {JSLintOption.SINGLE}, {JSLintOption.THIS}, {JSLintOption.WHITE}};
    private static final JSLintOption[][] ASSUME_CHECKBOX_OPTIONS_LAYOUT = new JSLintOption[][]{{JSLintOption.DEVEL}, {JSLintOption.ES6}, {JSLintOption.BROWSER}, {JSLintOption.COUCH}, {JSLintOption.NODE}};
    private static final JSLintOption[] TEXT_FIELD_OPTIONS_LAYOUT = new JSLintOption[]{JSLintOption.MAXLEN, JSLintOption.MAXERR, JSLintOption.GLOBALS};
    private final JPanel myOptionsComponent;
    private final ImmutableMap<JSLintOption, JComponent> myComponentByOptionMap;
    private final JCheckBox myJsonCheckbox = new JCheckBox("JSON");
    private final List<Runnable> myUpdatingJobs = new ArrayList<Runnable>();

    private static void validateLayout(@NotNull JSLintOption[][] layout, @NotNull Set<JSLintOption.Type> expectedOptionTypes, @NotNull Set<JSLintOption> alreadyAddedOptions) {
        if (layout == null) {
            JSLintOptionsView.$$$reportNull$$$0(0);
        }
        if (expectedOptionTypes == null) {
            JSLintOptionsView.$$$reportNull$$$0(1);
        }
        if (alreadyAddedOptions == null) {
            JSLintOptionsView.$$$reportNull$$$0(2);
        }
        int rowSize = layout[0].length;
        for (int i = 0; i < layout.length; ++i) {
            JSLintOption[] optionsRow = layout[i];
            if (optionsRow.length != rowSize) {
                throw new RuntimeException("Row " + i + " is expected to have " + rowSize + " element!");
            }
            for (JSLintOption option : optionsRow) {
                if (option == null) continue;
                if (alreadyAddedOptions.contains((Object)option)) {
                    throw new RuntimeException("Duplicate option: " + (Object)((Object)option) + "!");
                }
                if (!expectedOptionTypes.contains((Object)option.getType())) {
                    throw new RuntimeException("Expected types: " + expectedOptionTypes + ", found type: " + (Object)((Object)option.getType()));
                }
                alreadyAddedOptions.add(option);
            }
        }
    }

    private static void validate() {
        EnumSet<JSLintOption> usedOptions = EnumSet.noneOf(JSLintOption.class);
        JSLintOptionsView.validateLayout(TOLERATE_CHECKBOX_OPTIONS_LAYOUT, EnumSet.of(JSLintOption.Type.BOOLEAN), usedOptions);
        JSLintOptionsView.validateLayout(ASSUME_CHECKBOX_OPTIONS_LAYOUT, EnumSet.of(JSLintOption.Type.BOOLEAN), usedOptions);
        JSLintOptionsView.validateLayout(new JSLintOption[][]{TEXT_FIELD_OPTIONS_LAYOUT}, EnumSet.of(JSLintOption.Type.STRING, JSLintOption.Type.INTEGER), usedOptions);
        EnumSet<JSLintOption> allOptions = EnumSet.allOf(JSLintOption.class);
        if (!usedOptions.equals(allOptions)) {
            allOptions.removeAll(usedOptions);
            throw new RuntimeException("used options != all options, unused options are " + allOptions);
        }
    }

    public JSLintOptionsView() {
        HashMap<JSLintOption, JComponent> componentByOptionMap = new HashMap<JSLintOption, JComponent>();
        JPanel tolerateCheckboxesPanel = JSLintOptionsView.createCheckboxOptionsPanel(TOLERATE_CHECKBOX_OPTIONS_LAYOUT, "Tolerate", componentByOptionMap);
        JPanel assumeCheckboxesPanel = JSLintOptionsView.createCheckboxOptionsPanel(ASSUME_CHECKBOX_OPTIONS_LAYOUT, "Assume", componentByOptionMap);
        JPanel textFieldsPanel = JSLintOptionsView.createTextOptionsPanel(componentByOptionMap);
        JPanel northPanel = SwingHelper.newHorizontalPanel((float)0.0f, (Component[])new Component[]{tolerateCheckboxesPanel, Box.createHorizontalStrut(JBUIScale.scale((int)20)), assumeCheckboxesPanel});
        JPanel southPanel = this.createOtherFileTypesPanel(componentByOptionMap);
        this.myOptionsComponent = SwingHelper.wrapWithHorizontalStretch((JComponent)SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{northPanel, Box.createVerticalStrut(JBUIScale.scale((int)5)), textFieldsPanel, Box.createVerticalStrut(JBUIScale.scale((int)15)), southPanel}));
        this.myOptionsComponent.setBorder((Border)new JBEmptyBorder(0, 0, 5, 0));
        this.myComponentByOptionMap = ImmutableMap.copyOf(componentByOptionMap);
    }

    @NotNull
    private JPanel createOtherFileTypesPanel(@NotNull Map<JSLintOption, JComponent> componentByOptionMap) {
        if (componentByOptionMap == null) {
            JSLintOptionsView.$$$reportNull$$$0(3);
        }
        JPanel jsonPanel = this.createFileType(this.myJsonCheckbox, new JSLintOption[0][], componentByOptionMap);
        JPanel panel = SwingHelper.newHorizontalPanel((float)0.0f, (Component[])new Component[]{jsonPanel});
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)"Validate also"));
        JPanel jPanel = panel;
        if (jPanel == null) {
            JSLintOptionsView.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createFileType(@NotNull JCheckBox titleCheckBox, @NotNull JSLintOption[][] options, @NotNull Map<JSLintOption, JComponent> componentByOptionMap) {
        if (titleCheckBox == null) {
            JSLintOptionsView.$$$reportNull$$$0(5);
        }
        if (options == null) {
            JSLintOptionsView.$$$reportNull$$$0(6);
        }
        if (componentByOptionMap == null) {
            JSLintOptionsView.$$$reportNull$$$0(7);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)titleCheckBox, "North");
        if (options.length > 0) {
            JPanel center = JSLintOptionsView.createCheckboxOptionsPanel(options, null, componentByOptionMap);
            center.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            panel.add((Component)center, "Center");
            final Runnable r = () -> UIUtil.setEnabled((Component)center, (boolean)titleCheckBox.isSelected(), (boolean)true);
            titleCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    r.run();
                }
            });
            this.myUpdatingJobs.add(r);
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            JSLintOptionsView.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    private static JPanel createCheckboxOptionsPanel(@NotNull JSLintOption[][] layout, @Nullable String title, @NotNull Map<JSLintOption, JComponent> componentByOptionMap) {
        if (layout == null) {
            JSLintOptionsView.$$$reportNull$$$0(9);
        }
        if (componentByOptionMap == null) {
            JSLintOptionsView.$$$reportNull$$$0(10);
        }
        int columnCount = layout[0].length;
        JPanel checkboxesPanel = new JPanel(new GridBagLayout());
        if (title != null) {
            checkboxesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false));
        }
        CustomFocusTraversalPolicy focusPolicy = CustomFocusTraversalPolicy.createAndInstallOn((Container)checkboxesPanel);
        Integer checkboxHeight = null;
        for (int j = 0; j < columnCount; ++j) {
            for (int i = 0; i < layout.length; ++i) {
                JSLintOption option = layout[i][j];
                if (option == null) continue;
                if (option.getType() != JSLintOption.Type.BOOLEAN) {
                    throw new RuntimeException("Boolean type is expected: " + (Object)((Object)option) + "!");
                }
                String description = option.getDescription();
                if (title != null) {
                    description = StringUtil.trimStart((String)description, (String)(title + " ")).trim();
                }
                JCheckBox checkBox = new JCheckBox(description);
                checkBox.setToolTipText(option.getMeaning());
                componentByOptionMap.put(option, checkBox);
                focusPolicy.addNextComponentInTraversalOrder((Component)checkBox);
                if (checkboxHeight == null) {
                    checkboxHeight = checkBox.getPreferredSize().height;
                }
                int topInsets = 1;
                if (columnCount == 1 && i > 0 && layout[i - 1][j] == null) {
                    topInsets += checkboxHeight + 1;
                }
                checkboxesPanel.add((Component)checkBox, new GridBagConstraints(j, i, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)topInsets, (int)0, (int)0, (int)1), 0, 0));
            }
        }
        checkboxesPanel.add((Component)new JPanel(), new GridBagConstraints(0, layout.length, columnCount, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        return checkboxesPanel;
    }

    @NotNull
    private static JPanel createTextOptionsPanel(@NotNull Map<JSLintOption, JComponent> componentByOptionMap) {
        if (componentByOptionMap == null) {
            JSLintOptionsView.$$$reportNull$$$0(11);
        }
        FormBuilder builder = FormBuilder.createFormBuilder().setAlignLabelOnRight(true);
        for (JSLintOption option : TEXT_FIELD_OPTIONS_LAYOUT) {
            JTextComponent textComponent;
            boolean stringFieldType;
            JLabel label = new JLabel(option.getDescription() + ":");
            label.setToolTipText(option.getMeaning());
            boolean bl = stringFieldType = option.getType() == JSLintOption.Type.STRING;
            if (stringFieldType) {
                JTextArea textArea = new JTextArea();
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                textArea.setRows(3);
                textComponent = textArea;
            } else {
                JFormattedTextField formattedTextField = new JFormattedTextField();
                NumberFormat formatter = NumberFormat.getIntegerInstance();
                formatter.setParseIntegerOnly(true);
                formattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(formatter)));
                formattedTextField.setColumns(6);
                textComponent = formattedTextField;
            }
            textComponent.setDisabledTextColor(UIUtil.getLabelDisabledForeground());
            JTextArea comp = textComponent;
            if (textComponent instanceof JTextArea) {
                comp = new JBScrollPane((Component)textComponent);
            }
            builder.addLabeledComponent((JComponent)label, (JComponent)comp);
            componentByOptionMap.put(option, textComponent);
        }
        JPanel panel = builder.getPanel();
        panel.setBorder((Border)new JBEmptyBorder(0, 10, 0, 10));
        JPanel jPanel = panel;
        if (jPanel == null) {
            JSLintOptionsView.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    public void setState(@NotNull JSLintState state) {
        if (state == null) {
            JSLintOptionsView.$$$reportNull$$$0(13);
        }
        this.myJsonCheckbox.setSelected(state.isValidateJson());
        JSLintOptionsState optionsState = state.getOptionsState();
        for (JSLintOption option : JSLintOption.values()) {
            Object value = optionsState.getValue(option);
            JComponent component = (JComponent)this.myComponentByOptionMap.get((Object)option);
            Preconditions.checkNotNull((Object)component, (String)"Component for %s is null!", (Object)((Object)option));
            JSLintOptionsView.setOptionState(component, value, option.getType());
        }
    }

    private static void setOptionState(@NotNull JComponent component, @Nullable Object value, @NotNull JSLintOption.Type optionType) {
        if (component == null) {
            JSLintOptionsView.$$$reportNull$$$0(14);
        }
        if (optionType == null) {
            JSLintOptionsView.$$$reportNull$$$0(15);
        }
        if (optionType == JSLintOption.Type.BOOLEAN) {
            JCheckBox checkBox = (JCheckBox)component;
            Boolean boolValue = (Boolean)value;
            boolean selected = boolValue != null && boolValue != false;
            checkBox.setSelected(selected);
        } else if (optionType == JSLintOption.Type.INTEGER) {
            JFormattedTextField formattedTextField = (JFormattedTextField)component;
            formattedTextField.setValue(value);
        } else if (optionType == JSLintOption.Type.STRING) {
            JTextArea textArea = (JTextArea)component;
            String strValue = (String)value;
            textArea.setText(StringUtil.notNullize((String)strValue));
        }
    }

    @NotNull
    public JSLintState.Builder getStateBuilder() {
        JSLintOptionsState optionsState = this.getOptionsState();
        JSLintState.Builder builder = new JSLintState.Builder();
        builder.setOptionsState(optionsState);
        builder.setValidateJson(this.myJsonCheckbox.isSelected());
        JSLintState.Builder builder2 = builder;
        if (builder2 == null) {
            JSLintOptionsView.$$$reportNull$$$0(16);
        }
        return builder2;
    }

    @NotNull
    private JSLintOptionsState getOptionsState() {
        JSLintOptionsState.Builder builder = new JSLintOptionsState.Builder();
        for (JSLintOption option : JSLintOption.values()) {
            JTextArea textField;
            String text;
            JComponent component = (JComponent)this.myComponentByOptionMap.get((Object)option);
            Preconditions.checkNotNull((Object)component, (String)"Component for %s is null!", (Object)((Object)option));
            if (option.getType() == JSLintOption.Type.BOOLEAN) {
                JCheckBox checkBox = (JCheckBox)component;
                builder.put(option, checkBox.isSelected());
                continue;
            }
            if (option.getType() == JSLintOption.Type.INTEGER) {
                JFormattedTextField formattedTextField = (JFormattedTextField)component;
                Object value = formattedTextField.getValue();
                if (value == null || !option.getType().isProperValue(value)) continue;
                builder.put(option, value);
                continue;
            }
            if (option.getType() != JSLintOption.Type.STRING || StringUtil.isEmptyOrSpaces((String)(text = (textField = (JTextArea)component).getText()))) continue;
            builder.put(option, text);
        }
        JSLintOptionsState jSLintOptionsState = builder.build();
        if (jSLintOptionsState == null) {
            JSLintOptionsView.$$$reportNull$$$0(17);
        }
        return jSLintOptionsState;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myOptionsComponent;
        if (jPanel == null) {
            JSLintOptionsView.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    public void handleEnableStatusChanged(boolean enabled) {
        if (enabled) {
            for (Runnable job : this.myUpdatingJobs) {
                job.run();
            }
        }
    }

    static {
        JSLintOptionsView.validate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedOptionTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyAddedOptions";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentByOptionMap";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jslint/JSLintOptionsView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleCheckBox";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jslint/JSLintOptionsView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createOtherFileTypesPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextOptionsPanel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateBuilder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validateLayout";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createOtherFileTypesPanel";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFileType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCheckboxOptionsPanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTextOptionsPanel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setOptionState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

