/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintUtil {
    public static final OptionEnumType QUOTMARK_TYPE = new OptionEnumType(Arrays.asList(new OptionEnumVariant(false, "Both quotes allowed"), new OptionEnumVariant(true, "Only single or only double quotes allowed"), new OptionEnumVariant("single", "Only single quotes allowed"), new OptionEnumVariant("double", "Only double quotes allowed")));
    public static final OptionEnumType UNUSED_TYPE = new OptionEnumType(Arrays.asList(new OptionEnumVariant(false, "Don't check anything"), new OptionEnumVariant(true, "<html><body>Check all variables and parameters, but allow <br>unused parameters after a used parameter</body></html>"), new OptionEnumVariant("vars", "Check for variables, not function parameters"), new OptionEnumVariant("strict", "Check all variables and parameters")));
    public static final OptionEnumType LATEDEF_TYPE = new OptionEnumType(Arrays.asList(new OptionEnumVariant(false, "Don't warn"), new OptionEnumVariant(true, "Prohibit the use of a variable before it was defined"), new OptionEnumVariant("nofunc", "<html><body>Prohibit the use of a variable before it was defined, <br>but allow function declarations.</body></html>")));

    private JSHintUtil() {
    }

    @Nullable
    public static <T> T cast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            JSHintUtil.$$$reportNull$$$0(0);
        }
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        throw new ClassCastException("Expected type: " + clazz.getName() + ", actual: " + obj.getClass().getName());
    }

    @Nullable
    public static Integer castToInteger(@Nullable Object obj) {
        return JSHintUtil.cast(obj, Integer.class);
    }

    @Nullable
    public static String castToString(@Nullable Object obj) {
        return JSHintUtil.cast(obj, String.class);
    }

    public static JEditorPane createReadonlyBrowser(@NotNull String type, @NotNull String text) {
        if (type == null) {
            JSHintUtil.$$$reportNull$$$0(1);
        }
        if (text == null) {
            JSHintUtil.$$$reportNull$$$0(2);
        }
        final JEditorPane browser = new JEditorPane(type, text);
        browser.setEditable(false);
        browser.setCaret(new NonAdjustableCaret());
        browser.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 40) {
                    JSHintUtil.handleArrow(browser, true, true);
                } else if (keyCode == 38) {
                    JSHintUtil.handleArrow(browser, true, false);
                } else if (keyCode == 37) {
                    JSHintUtil.handleArrow(browser, false, false);
                } else if (keyCode == 39) {
                    JSHintUtil.handleArrow(browser, false, true);
                }
            }
        });
        return browser;
    }

    private static void handleArrow(@NotNull JEditorPane browser, boolean vertical, boolean downRight) {
        if (browser == null) {
            JSHintUtil.$$$reportNull$$$0(3);
        }
        Rectangle visibleRect = browser.getVisibleRect();
        int direction = downRight ? 1 : -1;
        int unit = browser.getScrollableUnitIncrement(visibleRect, vertical ? 1 : 0, direction);
        Rectangle newVisibleRect = new Rectangle(visibleRect);
        if (vertical) {
            newVisibleRect.y += unit * direction;
        } else {
            newVisibleRect.x += unit * direction;
        }
        browser.scrollRectToVisible(newVisibleRect);
    }

    @NotNull
    public static JComponent createIOExceptionBalloonComponent(@NotNull String text, final @NotNull Runnable retryCallback, boolean addConfigureHttpProxyLink) {
        if (text == null) {
            JSHintUtil.$$$reportNull$$$0(4);
        }
        if (retryCallback == null) {
            JSHintUtil.$$$reportNull$$$0(5);
        }
        JTextPane messageComponent = new JTextPane();
        messageComponent.setFont(StartupUiUtil.getLabelFont());
        HTMLEditorKit editorKit = new HTMLEditorKit();
        editorKit.getStyleSheet().addRule(UIUtil.displayPropertiesToCSS((Font)StartupUiUtil.getLabelFont(), (Color)UIUtil.getLabelForeground()));
        messageComponent.setEditorKit(editorKit);
        messageComponent.setContentType("text/html");
        String retry = "retry";
        String proxy = "proxy";
        messageComponent.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                if ("retry".equals(e.getDescription())) {
                    retryCallback.run();
                } else if ("proxy".equals(e.getDescription())) {
                    HttpConfigurable.editConfigurable(null);
                }
            }
        });
        StringBuilder html = new StringBuilder("<html><body>").append(text).append("<br/>");
        if (addConfigureHttpProxyLink) {
            html.append(JSHintUtil.hyperlink("proxy", "Configure HTTP proxy")).append(" or ");
        }
        html.append(JSHintUtil.hyperlink("retry", "Retry"));
        html.append("</body></html>");
        messageComponent.setText(html.toString());
        messageComponent.setEditable(false);
        if (messageComponent.getCaret() != null) {
            messageComponent.setCaretPosition(0);
        }
        messageComponent.setOpaque(false);
        messageComponent.setBackground(UIUtil.TRANSPARENT_COLOR);
        messageComponent.setForeground(UIUtil.getLabelForeground());
        JTextPane jTextPane = messageComponent;
        if (jTextPane == null) {
            JSHintUtil.$$$reportNull$$$0(6);
        }
        return jTextPane;
    }

    private static String hyperlink(@NotNull String href, @NotNull String description) {
        if (href == null) {
            JSHintUtil.$$$reportNull$$$0(7);
        }
        if (description == null) {
            JSHintUtil.$$$reportNull$$$0(8);
        }
        return "<a href=\"" + href + "\">" + description + "</a>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retryCallback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "href";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createIOExceptionBalloonComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cast";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createReadonlyBrowser";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleArrow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createIOExceptionBalloonComponent";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hyperlink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonAdjustableCaret
    extends DefaultCaret {
        private NonAdjustableCaret() {
        }

        @Override
        protected void adjustVisibility(Rectangle newLocation) {
        }
    }
}

