/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigFileView {
    private final JPanel myComponent;
    private final JRadioButton myDefaultRadioButton;
    private final JRadioButton myCustomRadioButton;
    private final TextFieldWithHistoryWithBrowseButton myCustomConfigField;
    private final List<Pair<JRadioButton, JComponent>> myRadioButtonWithContentList;
    private final JLabel myCustomConfigFileErrorLabel;

    public JSHintConfigFileView(@NotNull Project project) {
        if (project == null) {
            JSHintConfigFileView.$$$reportNull$$$0(0);
        }
        this.myDefaultRadioButton = new JBRadioButton(JSBundle.message((String)"jshint.config.option.default.name", (Object[])new Object[0]));
        JEditorPane defaultContentEditor = JSLinterUtil.createDefaultContent(JSBundle.message((String)"jshint.config.default.description", (Object[])new Object[0]));
        JPanel defaultContent = SwingHelper.wrapWithHorizontalStretch((JComponent)defaultContentEditor);
        this.myCustomRadioButton = new JBRadioButton(JSBundle.message((String)"jshint.config.option.custom.name", (Object[])new Object[0]));
        this.myCustomConfigField = JSHintConfigFileView.createCustomConfigField(project);
        this.myCustomConfigFileErrorLabel = new JLabel();
        this.myCustomConfigFileErrorLabel.setFont(UIUtil.getTitledBorderFont());
        JPanel customContent = JSHintConfigFileView.createCustomContent(this.myCustomConfigField, this.myCustomConfigFileErrorLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myDefaultRadioButton);
        buttonGroup.add(this.myCustomRadioButton);
        this.myRadioButtonWithContentList = ContainerUtil.newArrayList((Object[])new Pair[]{Pair.create((Object)this.myDefaultRadioButton, (Object)defaultContent), Pair.create((Object)this.myCustomRadioButton, (Object)customContent)});
        this.selectOption(this.myDefaultRadioButton, true);
        ((TextFieldWithHistory)this.myCustomConfigField.getChildComponent()).getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSHintConfigFileView.this.updateCustomErrorMessage();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView$1", "textChanged"));
            }
        });
        this.myComponent = this.createResultPanel(this.myRadioButtonWithContentList);
    }

    private void selectOption(@NotNull JRadioButton radioButton, boolean selected) {
        if (radioButton == null) {
            JSHintConfigFileView.$$$reportNull$$$0(1);
        }
        for (Pair<JRadioButton, JComponent> pair : this.myRadioButtonWithContentList) {
            boolean pairSelected = pair.getFirst() == radioButton ? selected : !selected;
            ((JRadioButton)pair.getFirst()).setSelected(pairSelected);
            UIUtil.setEnabled((Component)((Component)pair.getSecond()), (boolean)pairSelected, (boolean)true);
        }
        this.updateCustomErrorMessage();
    }

    private void updateCustomErrorMessage() {
        boolean visible = this.myCustomRadioButton.isSelected() && this.myCustomRadioButton.isEnabled();
        this.myCustomConfigFileErrorLabel.setVisible(visible);
        if (visible) {
            String errorMessage = JSHintConfigFileView.formatErrorMessage(((TextFieldWithHistory)this.myCustomConfigField.getChildComponent()).getText());
            if (errorMessage != null) {
                String html = XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>" + errorMessage + "</font>"));
                this.myCustomConfigFileErrorLabel.setText(html);
            } else {
                this.myCustomConfigFileErrorLabel.setText("");
            }
        }
    }

    @Nullable
    private static String formatErrorMessage(@NotNull String path) {
        if (path == null) {
            JSHintConfigFileView.$$$reportNull$$$0(2);
        }
        if (path.trim().isEmpty()) {
            return "Empty path";
        }
        File file2 = new File(path);
        if (!file2.isAbsolute() || !file2.isFile()) {
            return "No such file";
        }
        return null;
    }

    @NotNull
    private JPanel createResultPanel(@NotNull List<Pair<JRadioButton, JComponent>> contentByRadioButton) {
        if (contentByRadioButton == null) {
            JSHintConfigFileView.$$$reportNull$$$0(3);
        }
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            final JRadioButton jRadioButton = (JRadioButton)pair.getFirst();
            jRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JSHintConfigFileView.this.selectOption(jRadioButton, jRadioButton.isSelected());
                }
            });
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            if (!components.isEmpty()) {
                components.add(Box.createVerticalStrut(10));
            }
            JRadioButton radioButton = (JRadioButton)pair.getFirst();
            components.add(radioButton);
            int leftMargin = JSLinterUtil.getMarginForRadioButton(radioButton);
            JPanel wrap = SwingHelper.wrapWithHorizontalStretch((JComponent)((JComponent)pair.getSecond()));
            wrap.setBorder(BorderFactory.createEmptyBorder(0, leftMargin, 0, 0));
            components.add(wrap);
        }
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel(components);
        jPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Location", (boolean)false));
        JPanel jPanel2 = SwingHelper.wrapWithHorizontalStretch((JComponent)jPanel);
        if (jPanel2 == null) {
            JSHintConfigFileView.$$$reportNull$$$0(4);
        }
        return jPanel2;
    }

    @NotNull
    private static JPanel createCustomContent(@NotNull TextFieldWithHistoryWithBrowseButton configField, @NotNull JLabel configErrorLabel) {
        if (configField == null) {
            JSHintConfigFileView.$$$reportNull$$$0(5);
        }
        if (configErrorLabel == null) {
            JSHintConfigFileView.$$$reportNull$$$0(6);
        }
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(configErrorLabel);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        JPanel jPanel = FormBuilder.createFormBuilder().setHorizontalGap(10).setVerticalGap(4).addLabeledComponent("&Path:", (JComponent)configField).addComponentToRightColumn((JComponent)panel).getPanel();
        if (jPanel == null) {
            JSHintConfigFileView.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createCustomConfigField(@NotNull Project project) {
        if (project == null) {
            JSHintConfigFileView.$$$reportNull$$$0(8);
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"jshint.config.option.custom.browser.title", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), () -> {
            List<VirtualFile> files = JSHintConfigFileView.listConfigFilesInContentScope(project);
            List filePaths = ContainerUtil.map(files, file2 -> FileUtil.toSystemDependentName((String)file2.getPath()));
            Collections.sort(filePaths);
            return filePaths;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            JSHintConfigFileView.$$$reportNull$$$0(9);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private static List<VirtualFile> listConfigFilesInContentScope(@NotNull Project project) {
        if (project == null) {
            JSHintConfigFileView.$$$reportNull$$$0(10);
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
        Collection configs = FileTypeIndex.getFiles((FileType)JSHintConfigFileType.INSTANCE, (GlobalSearchScope)scope);
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile config2 : configs) {
            String path;
            if (config2 == null || !config2.isValid() || config2.isDirectory() || (path = config2.getPath()).contains("/node_modules/") || path.contains("/bower_components/")) continue;
            result2.add(config2);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            JSHintConfigFileView.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public void onEnabledStateChange(boolean enabled) {
        if (enabled) {
            this.selectOption(this.myDefaultRadioButton, this.myDefaultRadioButton.isSelected());
        }
        this.updateCustomErrorMessage();
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomRadioButton.isSelected();
    }

    @NotNull
    public String getCustomConfigFilePath() {
        String string = StringUtil.notNullize((String)((TextFieldWithHistory)this.myCustomConfigField.getChildComponent()).getText());
        if (string == null) {
            JSHintConfigFileView.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void setCustomConfigFileUsed(boolean used) {
        this.myCustomRadioButton.setSelected(used);
    }

    public void setCustomConfigFilePath(@NotNull String customConfigFilePath) {
        if (customConfigFilePath == null) {
            JSHintConfigFileView.$$$reportNull$$$0(13);
        }
        TextFieldWithHistory history = (TextFieldWithHistory)this.myCustomConfigField.getChildComponent();
        history.setText(customConfigFilePath);
        history.addCurrentTextToHistory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "radioButton";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentByRadioButton";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configField";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configErrorLabel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customConfigFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createResultPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomContent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomConfigField";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "listConfigFilesInContentScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomConfigFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectOption";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createResultPanel";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCustomConfigField";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "listConfigFilesInContentScope";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCustomConfigFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

