/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesPackageJsonListener;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiRootJSLinterLanguageServiceManager<TService extends JSLanguageServiceBase>
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(MultiRootJSLinterLanguageServiceManager.class);
    protected final Project myProject;
    @NotNull
    private final DaemonCodeAnalyzer myDaemonCodeAnalyzer;
    private final Set<ServiceInfo> myActiveServices;
    private ConcurrentHashMap<Location, ServiceInfo<TService>> myServices;
    private final String myPackageName;

    public MultiRootJSLinterLanguageServiceManager(@NotNull Project project, @NotNull NodeModulesDirectoryManager nodeModulesDirectoryManager, @NotNull DaemonCodeAnalyzer daemonCodeAnalyzer, @NotNull String packageName) {
        if (project == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(0);
        }
        if (nodeModulesDirectoryManager == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(1);
        }
        if (daemonCodeAnalyzer == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(2);
        }
        if (packageName == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(3);
        }
        this.myActiveServices = ContainerUtil.newConcurrentSet();
        this.myServices = new ConcurrentHashMap();
        this.myProject = project;
        this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        this.myPackageName = packageName;
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            nodeModulesDirectoryManager.addNodeModulesPackageJsonListener((changedPackageName, packageJson, changeType) -> {
                if (StringUtil.equals((CharSequence)changedPackageName, (CharSequence)this.myPackageName)) {
                    this.handlePackageJsonChanged(packageJson, changeType);
                }
            }, (Disposable)project);
            project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void after(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent instanceof VFileDeleteEvent) && !MultiRootJSLinterLanguageServiceManager.isRenameFileEvent(vFileEvent)) continue;
                        MultiRootJSLinterLanguageServiceManager.this.handleContainingDirectoryChanged(vFileEvent);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager$1", "after"));
                }
            });
        });
    }

    private void handleContainingDirectoryChanged(@NotNull VFileEvent event) {
        if (event == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(4);
        }
        String changed = event.getPath();
        for (Map.Entry<Location, ServiceInfo<TService>> entry : this.myServices.entrySet()) {
            String packagePath = entry.getKey().nodePackage.getSystemIndependentPath();
            if (!FileUtil.isAncestor((String)changed, (String)packagePath, (boolean)false)) continue;
            MultiRootJSLinterLanguageServiceManager.markAsDeleted(packagePath, entry.getValue(), String.format("VFS event %s", event));
        }
    }

    private void handlePackageJsonChanged(@NotNull VirtualFile packageJson, @NotNull NodeModulesPackageJsonListener.ChangeType changeType) {
        VirtualFile packageDir;
        if (packageJson == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(5);
        }
        if (changeType == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(6);
        }
        String changedPackagePath = (packageDir = packageJson.getParent()) != null ? packageDir.getPath() : null;
        for (Map.Entry<Location, ServiceInfo<TService>> entry : this.myServices.entrySet()) {
            String packagePath = entry.getKey().nodePackage.getSystemIndependentPath();
            if (!StringUtil.equals((CharSequence)changedPackagePath, (CharSequence)packagePath)) continue;
            MultiRootJSLinterLanguageServiceManager.markAsDeleted(packagePath, entry.getValue(), String.format("package.json was %s", new Object[]{changeType}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TResult, TThrowable extends Throwable> TResult useService(@NotNull VirtualFile virtualFile, @NotNull NodePackageRef storedPackage, @NotNull Callback<? super TService, TResult, TThrowable> callback) throws TThrowable {
        ServiceInfo serviceInfo;
        if (virtualFile == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(7);
        }
        if (storedPackage == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(9);
        }
        if ((serviceInfo = (ServiceInfo)ReadAction.compute(() -> this.acquireService(virtualFile, storedPackage))) != null) {
            this.myActiveServices.add(serviceInfo);
        }
        try {
            JSLanguageServiceBase service = serviceInfo != null ? (JSLanguageServiceBase)serviceInfo.myService : null;
            TResult TResult = callback.fun(service);
            return TResult;
        }
        finally {
            if (serviceInfo != null) {
                this.myActiveServices.remove(serviceInfo);
            }
        }
    }

    @Nullable
    private ServiceInfo<TService> acquireService(@NotNull VirtualFile virtualFile, @NotNull NodePackageRef storedPackage) {
        NodePackage resolvedPackage;
        if (virtualFile == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(10);
        }
        if (storedPackage == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(11);
        }
        if ((resolvedPackage = AutodetectLinterPackage.resolve(storedPackage, this.myProject, virtualFile, this.myPackageName)) == null) {
            return null;
        }
        VirtualFile workingDirectory = this.getWorkingDirectory(resolvedPackage, this.myProject, virtualFile);
        this.terminateUnusedServices();
        ServiceInfo serviceInfo = this.myServices.computeIfAbsent(new Location(resolvedPackage, workingDirectory), location -> {
            LOG.debug(String.format("Creating new service for path %s", ((Location)location).nodePackage.getSystemDependentPath()));
            return new ServiceInfo((Disposable)this.createServiceInstance(resolvedPackage, ((Location)location).workingDirectory), null);
        });
        serviceInfo.deleted = false;
        return serviceInfo;
    }

    @NotNull
    protected abstract TService createServiceInstance(@NotNull NodePackage var1, @NotNull VirtualFile var2);

    private void terminateUnusedServices() {
        boolean changed = false;
        for (Map.Entry<Location, ServiceInfo<TService>> entry : this.myServices.entrySet()) {
            Location path;
            ServiceInfo<TService> value = entry.getValue();
            if (this.myActiveServices.contains(value) || !((ServiceInfo)value).deleted || (value = this.myServices.remove(path = entry.getKey())) == null) continue;
            LOG.debug(String.format("Terminating service with path %s because %s", path, "deleted"));
            Disposer.dispose((Disposable)((ServiceInfo)value).myService);
            changed = true;
        }
        if (changed) {
            this.myDaemonCodeAnalyzer.restart();
        }
    }

    public void terminateServices() {
        Collection<ServiceInfo<TService>> oldServices = this.myServices.values();
        this.myServices = new ConcurrentHashMap();
        for (ServiceInfo<TService> value : oldServices) {
            Disposer.dispose((Disposable)((ServiceInfo)value).myService);
        }
    }

    public void dispose() {
        this.terminateServices();
    }

    private static void markAsDeleted(String path, ServiceInfo info, String reason) {
        LOG.debug(String.format("Marking service with path %s as deleted because %s", path, reason));
        info.deleted = true;
    }

    @NotNull
    protected VirtualFile getWorkingDirectory(@NotNull NodePackage resolvedPackage, @NotNull Project project, @NotNull VirtualFile file2) {
        if (resolvedPackage == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(12);
        }
        if (project == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(14);
        }
        VirtualFile fromLocalNodeModules = MultiRootJSLinterLanguageServiceManager.getLocalNodeModulesParent(resolvedPackage, project);
        VirtualFile fromDeclaredDependency = this.getPackageJsonWithDependencyParentDir(file2, project);
        if (fromLocalNodeModules != null && fromDeclaredDependency != null && VfsUtilCore.isAncestor((VirtualFile)fromLocalNodeModules, (VirtualFile)fromDeclaredDependency, (boolean)false)) {
            VirtualFile virtualFile = fromDeclaredDependency;
            if (virtualFile == null) {
                MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(15);
            }
            return virtualFile;
        }
        if (fromDeclaredDependency != null) {
            VirtualFile virtualFile = fromDeclaredDependency;
            if (virtualFile == null) {
                MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(16);
            }
            return virtualFile;
        }
        if (fromLocalNodeModules != null) {
            VirtualFile virtualFile = fromLocalNodeModules;
            if (virtualFile == null) {
                MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(17);
            }
            return virtualFile;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile packageJson = PackageJsonUtil.findUpPackageJson(file2);
        VirtualFile virtualFile = (VirtualFile)ObjectUtils.coalesce((Object)(packageJson != null ? packageJson.getParent() : null), (Object)projectFileIndex.getContentRootForFile(file2, false), (Object)file2.getParent());
        if (virtualFile == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(18);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile getLocalNodeModulesParent(@NotNull NodePackage resolvedPackage, @NotNull Project project) {
        if (resolvedPackage == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(19);
        }
        if (project == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(20);
        }
        VirtualFile packageVFile = LocalFileSystem.getInstance().findFileByPath(resolvedPackage.getSystemDependentPath());
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile packageParent = packageVFile != null ? packageVFile.getParent() : null;
        return packageParent != null && StringUtil.equals((CharSequence)packageParent.getNameSequence(), (CharSequence)"node_modules") && projectFileIndex.getContentRootForFile(packageParent, false) != null ? packageParent.getParent() : null;
    }

    @Nullable
    private VirtualFile getPackageJsonWithDependencyParentDir(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(21);
        }
        if (project == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(22);
        }
        Ref result2 = new Ref();
        PackageJsonUtil.processUpPackageJsonFiles(project, file2, (Processor<? super VirtualFile>)((Processor)packageJsonFile -> {
            PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJsonFile);
            if (data.isDependencyOfAnyType(this.myPackageName)) {
                result2.set((Object)packageJsonFile.getParent());
            }
            return true;
        }));
        return (VirtualFile)result2.get();
    }

    private static boolean isRenameFileEvent(@NotNull VFileEvent event) {
        if (event == null) {
            MultiRootJSLinterLanguageServiceManager.$$$reportNull$$$0(23);
        }
        if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent changeEvent = (VFilePropertyChangeEvent)event;
            return "name".equals(changeEvent.getPropertyName()) && Objects.equals(changeEvent.getOldValue(), changeEvent.getNewValue());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirectoryManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "daemonCodeAnalyzer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeType";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storedPackage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedPackage";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleContainingDirectoryChanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handlePackageJsonChanged";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "useService";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acquireService";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLocalNodeModulesParent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonWithDependencyParentDir";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isRenameFileEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ServiceInfo<T extends Disposable> {
        @NotNull
        private final T myService;
        private boolean deleted;

        private ServiceInfo(@NotNull T service) {
            if (service == null) {
                ServiceInfo.$$$reportNull$$$0(0);
            }
            this.myService = service;
        }

        /* synthetic */ ServiceInfo(Disposable x0, 1 x1) {
            this(x0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager$ServiceInfo", "<init>"));
        }
    }

    private static class Location {
        @NotNull
        private final NodePackage nodePackage;
        @NotNull
        private final VirtualFile workingDirectory;

        private Location(@NotNull NodePackage resolvedPackage, @NotNull VirtualFile workingDirectory) {
            if (resolvedPackage == null) {
                Location.$$$reportNull$$$0(0);
            }
            if (workingDirectory == null) {
                Location.$$$reportNull$$$0(1);
            }
            this.nodePackage = resolvedPackage;
            this.workingDirectory = workingDirectory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (!this.nodePackage.equals(location.nodePackage)) {
                return false;
            }
            return this.workingDirectory.equals(location.workingDirectory);
        }

        public int hashCode() {
            int result2 = this.nodePackage.hashCode();
            result2 = 31 * result2 + this.workingDirectory.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolvedPackage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDirectory";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager$Location";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface Callback<TService, TResult, TThrowable extends Throwable> {
        public TResult fun(@Nullable TService var1) throws TThrowable;
    }
}

