/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutodetectLinterPackage {
    public static final NodePackageRef INSTANCE = NodePackageRef.create(JSBundle.message((String)"js.linters.detect.automatically.caption", (Object[])new Object[0]));
    private static final Key<NodePackage> TEST_AUTODETECT_KEY = new Key("TEST_AUTODETECT_KEY");

    private AutodetectLinterPackage() {
    }

    public static void setTestAutodetectedPackage(@NotNull Project project, @NotNull NodePackage nodePackage, @NotNull Disposable disposable) {
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(0);
        }
        if (nodePackage == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(2);
        }
        project.putUserData(TEST_AUTODETECT_KEY, (Object)nodePackage);
        Disposer.register((Disposable)disposable, () -> project.putUserData(TEST_AUTODETECT_KEY, null));
    }

    @Nullable
    public static NodePackage resolve(@NotNull NodePackageRef nodePackageRef, @NotNull Project project, @NotNull VirtualFile contextFile, @NotNull String packageName) {
        if (nodePackageRef == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(4);
        }
        if (contextFile == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(5);
        }
        if (packageName == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        NodePackage constantPackage = nodePackageRef.getConstantPackage();
        if (constantPackage != null) {
            return constantPackage;
        }
        if (nodePackageRef != INSTANCE) {
            return null;
        }
        NodePackage testValue = (NodePackage)project.getUserData(TEST_AUTODETECT_KEY);
        if (testValue != null) {
            return testValue;
        }
        Ref result2 = new Ref();
        PackageJsonUtil.processUpPackageJsonFiles(project, contextFile, (Processor<? super VirtualFile>)((Processor)packageJsonFile -> {
            VirtualFile installedPackage = AutodetectLinterPackage.findInstalledPackage(project, packageJsonFile, packageName);
            if (installedPackage != null && !AutodetectLinterPackage.hasPackageJsonWithDependencyStrictlyAbove(project, packageJsonFile, packageName)) {
                result2.set((Object)new NodePackage(VfsUtilCore.virtualToIoFile((VirtualFile)installedPackage).getAbsolutePath()));
                return false;
            }
            PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJsonFile);
            if (data.isDependencyOfAnyType(packageName)) {
                result2.set((Object)AutodetectLinterPackage.getDefaultNodeModulesLocation(packageJsonFile, packageName));
                return false;
            }
            return true;
        }));
        return (NodePackage)result2.get();
    }

    @NotNull
    private static NodePackage getDefaultNodeModulesLocation(VirtualFile packageJson, String name) {
        File parentDir = VfsUtilCore.virtualToIoFile((VirtualFile)packageJson.getParent());
        NodePackage nodePackage = new NodePackage(new File(new File(parentDir, "node_modules"), name).getAbsolutePath());
        if (nodePackage == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(7);
        }
        return nodePackage;
    }

    private static boolean hasPackageJsonWithDependencyStrictlyAbove(@NotNull Project project, @NotNull VirtualFile startPackageJson, @NotNull String packageName) {
        VirtualFile startDir;
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(8);
        }
        if (startPackageJson == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(9);
        }
        if (packageName == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(10);
        }
        if ((startDir = startPackageJson.getParent().getParent()) == null) {
            return false;
        }
        Ref foundPackage = new Ref((Object)Boolean.FALSE);
        PackageJsonUtil.processUpPackageJsonFiles(project, startDir, (Processor<? super VirtualFile>)((Processor)packageJsonFile -> {
            PackageJsonData data;
            PackageJsonData packageJsonData = data = packageJsonFile != null ? PackageJsonUtil.getOrCreateData(packageJsonFile) : null;
            if (data != null && data.isDependencyOfAnyType(packageName)) {
                foundPackage.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }));
        return (Boolean)foundPackage.get();
    }

    private static VirtualFile findInstalledPackage(@NotNull Project project, @NotNull VirtualFile packageJson, String packageName) {
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(11);
        }
        if (packageJson == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(12);
        }
        Ref result2 = new Ref();
        NodeModuleSearchUtil.processUpNodeModulesDirs(project, packageJson, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
            VirtualFile packageDir = nodeModulesDir.findFileByRelativePath(packageName);
            if (packageDir != null && packageDir.isDirectory() && packageDir.isValid() && PackageJsonUtil.findChildPackageJsonFile(packageDir) != null) {
                result2.set((Object)packageDir);
                return false;
            }
            return true;
        }));
        return (VirtualFile)result2.get();
    }

    @Deprecated
    @NotNull
    public static NodePackageField createNodePackageField(@NotNull List<String> packageNames, @NotNull NodeJsInterpreterField nodeInterpreterField, @NotNull JSLinterConfigFileView configFileView, boolean multiRootEnabled) {
        if (packageNames == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(13);
        }
        if (nodeInterpreterField == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(14);
        }
        if (configFileView == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(15);
        }
        NodePackageField nodePackageField = AutodetectLinterPackage.createNodePackageField(packageNames, nodeInterpreterField, configFileView);
        if (nodePackageField == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(16);
        }
        return nodePackageField;
    }

    @NotNull
    public static NodePackageField createNodePackageField(@NotNull List<String> packageNames, @NotNull NodeJsInterpreterField nodeInterpreterField, @NotNull JSLinterConfigFileView configFileView) {
        if (packageNames == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(17);
        }
        if (nodeInterpreterField == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(18);
        }
        if (configFileView == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(19);
        }
        NodePackageDescriptor packageDescriptor = AutodetectLinterPackage.createPackageDescriptor(packageNames);
        NodePackageField packageField = new NodePackageField(nodeInterpreterField, packageDescriptor, null, AutodetectLinterPackage.createNodePackageRefResolver());
        packageField.addPackageRefSelectionListener((Consumer<NodePackageRef>)((Consumer)nodePackage -> {
            boolean suppressCustomConfigFileUI = nodePackage == INSTANCE;
            configFileView.setEnabled(packageField.isEnabled() && !suppressCustomConfigFileUI);
            if (suppressCustomConfigFileUI) {
                configFileView.setCustomConfigFileUsed(false);
            } else {
                configFileView.setCustomConfigFileUsed(StringUtil.isNotEmpty((String)configFileView.getCustomConfigFilePath()));
            }
        }));
        NodePackageField nodePackageField = packageField;
        if (nodePackageField == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(20);
        }
        return nodePackageField;
    }

    @NotNull
    private static NodePackageRefResolver createNodePackageRefResolver() {
        NodePackageRefResolver nodePackageRefResolver = new NodePackageRefResolver(){

            @Override
            @Nullable
            public NodePackage resolve(@NotNull NodePackageRef ref, @Nullable NodeJsInterpreter interpreter) {
                NodePackage pkg;
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pkg = ref.getConstantPackage()) != null) {
                    return pkg;
                }
                return ref == INSTANCE ? new NodePackage("") : null;
            }

            @Override
            public boolean isValidPackage(NodePackageRef ref, @Nullable NodePackage pkg) {
                return ref == INSTANCE || pkg != null && pkg.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/linter/AutodetectLinterPackage$1", "resolve"));
            }
        };
        if (nodePackageRefResolver == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(21);
        }
        return nodePackageRefResolver;
    }

    @NotNull
    private static NodePackageDescriptor createPackageDescriptor(List<String> packageNames) {
        NodePackageDescriptor nodePackageDescriptor = new NodePackageDescriptor((List)packageNames){

            @Override
            @NotNull
            public NodePackageRef createPackageRef(@NotNull String text) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (StringUtil.equals((CharSequence)INSTANCE.getReferenceName(), (CharSequence)text)) {
                    NodePackageRef nodePackageRef = INSTANCE;
                    if (nodePackageRef == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return nodePackageRef;
                }
                NodePackageRef nodePackageRef = super.createPackageRef(text);
                if (nodePackageRef == null) {
                    2.$$$reportNull$$$0(2);
                }
                return nodePackageRef;
            }

            @Override
            @NotNull
            public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
                if (project == null) {
                    2.$$$reportNull$$$0(3);
                }
                ArrayList<NodePackageRef> refs = new ArrayList<NodePackageRef>();
                refs.add(INSTANCE);
                refs.addAll(super.listPackageRefs(project, interpreter, contextFileOrDirectory));
                ArrayList<NodePackageRef> arrayList = refs;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(4);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/linter/AutodetectLinterPackage$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/linter/AutodetectLinterPackage$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPackageRef";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listPackageRefs";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createPackageRef";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "listPackageRefs";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (nodePackageDescriptor == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(22);
        }
        return nodePackageDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackageRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/AutodetectLinterPackage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPackageJson";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeInterpreterField";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFileView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/AutodetectLinterPackage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultNodeModulesLocation";
                break;
            }
            case 16: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodePackageField";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodePackageRefResolver";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTestAutodetectedPackage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasPackageJsonWithDependencyStrictlyAbove";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findInstalledPackage";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createNodePackageField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

