/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariableInitializationExtractor {
    public static final TokenSet EXPORT_KEYWORD = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.EXPORT_KEYWORD});
    private final JSVarStatement myVarStatement;
    private final Set<JSVariable> myVariablesToExtract;
    private final Set<JSVariable> myVariablesToDelete;
    private final Set<JSVariable> myToBeConst;
    @Nullable
    private JSVarStatement.VarKeyword myNewKeyword;
    private boolean myNotApplicable;

    public JSVariableInitializationExtractor(@NotNull List<JSVariable> variables, @NotNull JSVarStatement statement) {
        if (variables == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(1);
        }
        this(statement, variables.toArray(JSVariable.EMPTY_ARRAY));
    }

    public JSVariableInitializationExtractor(JSVariable ... variables) {
        if (variables == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(2);
        }
        this((JSVarStatement)null, variables);
    }

    public JSVariableInitializationExtractor(@Nullable JSVarStatement statement, JSVariable ... variables) {
        if (variables == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(3);
        }
        this.myToBeConst = new HashSet<JSVariable>();
        this.myVariablesToExtract = new HashSet<JSVariable>(Arrays.asList(variables));
        for (JSVariable variable : variables) {
            if (variable.getParent() instanceof JSDestructuringArray) {
                this.myNotApplicable = true;
                this.myVariablesToExtract.clear();
                this.myVarStatement = null;
                this.myVariablesToDelete = null;
                return;
            }
            assert (variable.getParent() instanceof JSVarStatement);
            assert (statement == null || statement == variable.getParent());
            statement = (JSVarStatement)variable.getParent();
        }
        this.myVarStatement = statement;
        this.myVariablesToDelete = new HashSet<JSVariable>();
    }

    public JSVariableInitializationExtractor withNewKeyword(@NotNull JSVarStatement.VarKeyword keyword) {
        if (keyword == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(4);
        }
        this.myNewKeyword = keyword;
        return this;
    }

    public void toBeConst(@NotNull Collection<JSVariable> collection) {
        if (collection == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(5);
        }
        this.myToBeConst.addAll(collection);
        this.myNewKeyword = JSVarStatement.VarKeyword.LET;
    }

    public void deleteExtracted(@NotNull Collection<JSVariable> collection) {
        if (collection == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(6);
        }
        this.myVariablesToDelete.addAll(collection);
    }

    public List<PsiElement> transform() {
        JSVarStatement transformationAnchor;
        if (this.myNotApplicable) {
            return Collections.emptyList();
        }
        FragmentsSplitter fragmentsSplitter = new FragmentsSplitter(variable -> {
            boolean flag = this.myVariablesToExtract.contains(variable);
            if (flag && (variable.getInitializer() == null || this.myVariablesToDelete.contains(variable))) {
                return null;
            }
            return flag;
        });
        JSVariable[] variables = this.myVarStatement.getVariables();
        fragmentsSplitter.split(variables);
        if (this.insideFor()) {
            JSInitializerOwner[] declarations = this.myVarStatement.getDeclarations();
            if (declarations.length > 1) {
                transformationAnchor = this.myVarStatement.getParent();
            } else {
                transformationAnchor = this.myVarStatement;
                if (declarations.length == 1 && this.insideFor()) {
                    if (!((Boolean)fragmentsSplitter.extractFlagList.get(0)).booleanValue() || variables.length != 1) {
                        PsiElement keyword = this.myVarStatement.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS).getPsi();
                        if (keyword == null) {
                            return Collections.emptyList();
                        }
                        PsiElement replacementKeyword = this.createKeyword();
                        if (replacementKeyword == null) {
                            return Collections.emptyList();
                        }
                        return Collections.singletonList(keyword.replace(replacementKeyword));
                    }
                    JSVariable variable2 = this.myVarStatement.getVariables()[0];
                    if (variable2.getInitializer() != null) {
                        this.myVarStatement.replace((PsiElement)JSVariableInitializationExtractor.createInitializer(variable2).getExpression());
                        return Collections.singletonList(this.myVarStatement);
                    }
                    this.deleteOldVarStatement(null);
                    return Collections.emptyList();
                }
            }
        } else {
            transformationAnchor = this.myVarStatement;
        }
        ArrayList<PsiElement> addedElements = new ArrayList<PsiElement>();
        if (!fragmentsSplitter.isEmpty()) {
            fragmentsSplitter.iterate((PairConsumer<Boolean, List<JSVariable>>)((PairConsumer)(arg_0, arg_1) -> this.lambda$transform$1(addedElements, (PsiElement)transformationAnchor, arg_0, arg_1)));
            PsiElement extraWs = this.myVarStatement.getPrevSibling();
            if (extraWs instanceof PsiWhiteSpace && !addedElements.contains(extraWs)) {
                extraWs.delete();
            }
        }
        this.deleteOldVarStatement(addedElements);
        return addedElements;
    }

    private void deleteOldVarStatement(@Nullable List<PsiElement> addedElements) {
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)this.myVarStatement);
        if (comment != null && addedElements != null && !addedElements.isEmpty()) {
            this.moveComment(comment, addedElements);
        }
        this.myVarStatement.delete();
    }

    private void moveComment(@NotNull PsiComment comment, @Nullable List<PsiElement> addedElements) {
        if (comment == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(7);
        }
        PsiElement anchor = null;
        if (addedElements == null || addedElements.isEmpty()) {
            if (this.myVarStatement.getPrevSibling() != null) {
                anchor = PsiTreeUtil.getParentOfType((PsiElement)this.myVarStatement.getPrevSibling(), JSSourceElement.class);
            }
        } else {
            for (PsiElement element : addedElements) {
                if (!(element instanceof JSVarStatement)) continue;
                anchor = element;
                break;
            }
            if (anchor == null) {
                anchor = PsiTreeUtil.getParentOfType((PsiElement)addedElements.get(0), JSSourceElement.class);
            }
        }
        if (anchor != null) {
            JSDocumentationUtils.moveJSDoc(comment, anchor);
        }
    }

    private PsiElement createKeyword() {
        JSVarStatement.VarKeyword keyword = this.determineKeyword();
        if (keyword == null) {
            return null;
        }
        JSStatement newSt = JSPsiElementFactory.createJSStatement(keyword.getText() + " a;", (PsiElement)this.myVarStatement);
        return newSt.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS).getPsi();
    }

    private boolean insideFor() {
        return this.myVarStatement.getParent() instanceof JSForStatement || this.myVarStatement.getParent() instanceof JSForInStatement;
    }

    private void addDeclarations(PsiElement transformationAnchor, List<PsiElement> addedElements, List<JSVariable> fragment) {
        if (!this.myToBeConst.isEmpty()) {
            FragmentsSplitter fragmentsSplitter = new FragmentsSplitter(this.myToBeConst::contains);
            fragmentsSplitter.split(fragment.toArray(JSVariable.EMPTY_ARRAY));
            fragmentsSplitter.iterate((PairConsumer<Boolean, List<JSVariable>>)((PairConsumer)(flag, innerFragment) -> {
                JSSourceElement statement = this.createLetStatement((List<JSVariable>)innerFragment, flag != false ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.LET);
                addedElements.add(transformationAnchor.getParent().addBefore((PsiElement)statement, transformationAnchor));
            }));
        } else {
            addedElements.add(JSChangeUtil.doDoAddBefore(transformationAnchor.getParent(), (PsiElement)this.createLetStatement(fragment), transformationAnchor));
        }
    }

    private static JSExpressionStatement createInitializer(@NotNull JSVariable variable) {
        if (variable == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(8);
        }
        JSExpressionStatement st = JSPsiElementFactory.createJSStatement(variable.getName() + "= 1" + JSCodeStyleSettings.getSemicolon((PsiElement)variable), (PsiElement)variable, JSExpressionStatement.class);
        JSExpression expression = st.getExpression();
        assert (expression instanceof JSAssignmentExpression);
        ((JSAssignmentExpression)expression).getDefinitionExpression().getInitializer().replace(variable.getInitializer().copy());
        return st;
    }

    private JSSourceElement createLetStatement(@NotNull List<JSVariable> list2) {
        if (list2 == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(9);
        }
        return this.createLetStatement(list2, this.determineKeyword());
    }

    private JSSourceElement createLetStatement(@NotNull List<JSVariable> list2, @NotNull JSVarStatement.VarKeyword keyword) {
        if (list2 == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(10);
        }
        if (keyword == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(11);
        }
        Ref attributes = new Ref((Object)"");
        assert (!list2.isEmpty());
        String middleText = StringUtil.trimLeading((String)this.computeMiddleText(list2, (Ref<String>)attributes));
        String text = attributes + keyword.getText() + " " + middleText + JSCodeStyleSettings.getSemicolon((PsiElement)this.myVarStatement.getContainingFile());
        return JSPsiElementFactory.createJSStatement(text, (PsiElement)this.myVarStatement, JSVarStatement.class);
    }

    private String computeMiddleText(@NotNull List<JSVariable> list2, Ref<String> attributes) {
        if (list2 == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(12);
        }
        if (Arrays.stream(this.myVarStatement.getDeclarations()).noneMatch(d -> d instanceof JSDestructuringElement)) {
            return list2.stream().map(variable -> {
                PsiElement forwardComma;
                String attributeList = JSVariableInitializationExtractor.getAttributeList(variable);
                if (attributeList != null) {
                    attributes.set((Object)(attributeList + " "));
                }
                SmartList parts = new SmartList();
                PsiElement backwardCommaOrVar = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)variable);
                if (backwardCommaOrVar != null) {
                    JSVariableInitializationExtractor.fetchInBetween(backwardCommaOrVar.getNextSibling(), (PsiElement)variable, (List<PsiElement>)parts);
                }
                if ((forwardComma = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)variable)) != null) {
                    JSVariableInitializationExtractor.fetchInBetween((PsiElement)variable, forwardComma, (List<PsiElement>)parts);
                } else {
                    parts.add(variable);
                }
                return parts.stream().map(PsiElement::getText).collect(Collectors.joining(""));
            }).collect(Collectors.joining(","));
        }
        StringBuilder allVars = new StringBuilder();
        for (JSInitializerOwner declaration : this.myVarStatement.getDeclarations()) {
            if (!(declaration instanceof JSDestructuringElement) || !list2.stream().anyMatch(e -> PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)e, (boolean)true))) continue;
            if (allVars.length() != 0) {
                allVars.append(",");
            }
            allVars.append(declaration.getText());
        }
        return allVars.toString();
    }

    private static void fetchInBetween(@Nullable PsiElement from, @NotNull PsiElement toExcluding, @NotNull List<PsiElement> list2) {
        if (toExcluding == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(13);
        }
        if (list2 == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(14);
        }
        for (PsiElement current = from; current != null && !current.equals(toExcluding); current = current.getNextSibling()) {
            list2.add(current);
        }
    }

    @Nullable
    private static String getAttributeList(@NotNull JSVariable variable) {
        JSAttributeList attributeList;
        if (variable == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(15);
        }
        return (attributeList = variable.getAttributeList()) != null && !StringUtil.isEmptyOrSpaces((String)attributeList.getText()) ? attributeList.getText() : null;
    }

    private JSVarStatement.VarKeyword determineKeyword() {
        if (this.myNewKeyword != null) {
            return this.myNewKeyword;
        }
        JSVarStatement.VarKeyword keyword = this.myVarStatement.getVarKeyword();
        return keyword != null ? keyword : JSVarStatement.VarKeyword.LET;
    }

    private /* synthetic */ void lambda$transform$1(List addedElements, PsiElement transformationAnchor, Boolean flag, List fragment) {
        if (flag.booleanValue()) {
            for (JSVariable variable : fragment) {
                if (variable.getInitializer() == null) continue;
                addedElements.add(transformationAnchor.getParent().addBefore((PsiElement)JSVariableInitializationExtractor.createInitializer(variable), transformationAnchor));
            }
        } else {
            this.addDeclarations(transformationAnchor, addedElements, fragment);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExcluding";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withNewKeyword";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "toBeConst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteExtracted";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "moveComment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createInitializer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createLetStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "computeMiddleText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchInBetween";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttributeList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FragmentsSplitter {
        @NotNull
        private final Convertor<JSVariable, Boolean> convertor;
        private final List<Boolean> extractFlagList;
        private final List<List<JSVariable>> fragments;

        private FragmentsSplitter(@NotNull Convertor<JSVariable, Boolean> convertor) {
            if (convertor == null) {
                FragmentsSplitter.$$$reportNull$$$0(0);
            }
            this.extractFlagList = new ArrayList<Boolean>();
            this.fragments = new ArrayList<List<JSVariable>>();
            this.convertor = convertor;
        }

        public void split(JSVariable[] variables) {
            ArrayList<JSVariable> current = new ArrayList<JSVariable>();
            boolean currentFlag = false;
            for (JSVariable variable : variables) {
                Boolean futureFlag = (Boolean)this.convertor.convert((Object)variable);
                if (futureFlag == null) continue;
                if (futureFlag != currentFlag) {
                    if (!current.isEmpty()) {
                        this.extractFlagList.add(currentFlag);
                        this.fragments.add(current);
                        current = new ArrayList();
                    }
                    currentFlag = futureFlag;
                }
                current.add(variable);
            }
            if (!current.isEmpty()) {
                this.extractFlagList.add(currentFlag);
                this.fragments.add(current);
            }
            assert (this.fragments.size() == this.extractFlagList.size());
        }

        public void iterate(@NotNull PairConsumer<Boolean, List<JSVariable>> consumer) {
            if (consumer == null) {
                FragmentsSplitter.$$$reportNull$$$0(1);
            }
            for (int i = 0; i < this.fragments.size(); ++i) {
                List<JSVariable> fragment = this.fragments.get(i);
                boolean flag = this.extractFlagList.get(i);
                consumer.consume((Object)flag, fragment);
            }
        }

        public boolean isEmpty() {
            return this.fragments.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "convertor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor$FragmentsSplitter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iterate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

