/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSConsecutiveCommasInArrayLiteralInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLastCommaInArrayLiteralInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.last.comma.in.array.literal.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSLastCommaInArrayLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
                if (DialectDetector.isTypeScript((PsiElement)node) || DialectDetector.isES6((PsiElement)node)) {
                    return;
                }
                PsiElement child = JSLastCommaInArrayLiteralInspection.findErrorNode(node);
                if (child != null) {
                    JSPrefixExpression prefixExpr;
                    if (!DialectDetector.isActionScript((PsiElement)node) && (prefixExpr = (JSPrefixExpression)ObjectUtils.tryCast((Object)node.getParent(), JSPrefixExpression.class)) != null && prefixExpr.getOperationSign() == JSTokenTypes.MINUS) {
                        return;
                    }
                    ASTNode prev = TreeUtil.skipWhitespaceAndComments((ASTNode)child.getNode().getTreePrev(), (boolean)false);
                    LocalQuickFixAndIntentionActionOnPsiElement fix = prev != null && prev.getElementType() == JSElementTypes.EMPTY_EXPRESSION ? new RemoveCommaAndInsertUndefined(prev.getPsi()) : JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", child);
                    holder.registerProblem(child, JSBundle.message((String)"javascript.validation.message.unneeded.comma", (Object[])new Object[0]), new LocalQuickFix[]{fix});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSLastCommaInArrayLiteralInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    @Nullable
    public static PsiElement findErrorNode(@NotNull JSArrayLiteralExpression node) {
        PsiElement lastChild;
        PsiElement child;
        if (node == null) {
            JSLastCommaInArrayLiteralInspection.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = child = (lastChild = node.getLastChild()) != null ? lastChild.getPrevSibling() : null;
        if (child == null) {
            return null;
        }
        ASTNode childNode = TreeUtil.skipWhitespaceAndComments((ASTNode)child.getNode(), (boolean)false);
        if (childNode != null && childNode.getElementType() == JSTokenTypes.COMMA) {
            return childNode.getPsi();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findErrorNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveCommaAndInsertUndefined
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected RemoveCommaAndInsertUndefined(@Nullable PsiElement element) {
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement undefined;
            PsiElement parent;
            if (project == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(3);
            }
            if ((parent = (undefined = JSConsecutiveCommasInArrayLiteralInspection.InsertUndefinedFix.replaceWithUndefined(startElement)).getParent()) instanceof JSArrayLiteralExpression) {
                PsiElement comma = JSLastCommaInArrayLiteralInspection.findErrorNode((JSArrayLiteralExpression)parent);
                assert (comma != null);
                JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", comma).invoke(project, file2, editor, comma, comma);
            }
        }

        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"javascript.validation.message.remove.unneeded.comma.fix", (Object[])new Object[0]);
            if (string == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection$RemoveCommaAndInsertUndefined";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection$RemoveCommaAndInsertUndefined";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

