/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.webpack.WebpackConfigHighlightingInspection;
import com.intellij.lang.javascript.frameworks.webpack.WebpackUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.json.JSJsonSchemaProviderBase;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebpackInJavaScriptJsonSchemaProvider
extends JSJsonSchemaProviderBase {
    @NotNull
    private final WebpackUtil.WebpackVersion myVersion;
    private final VirtualFile mySchemaFile;

    @Nullable
    private static VirtualFile getWebpackSchemaFile(@NotNull WebpackUtil.WebpackVersion version) {
        if (version == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(0);
        }
        if (WebpackUtil.WebpackVersion.LIKE2.equals((Object)version)) {
            return WebpackInJavaScriptJsonSchemaProvider.loadFile(WebpackInJavaScriptJsonSchemaProvider.class, "/jsonSchemas/webpack-schema.json");
        }
        if (WebpackUtil.WebpackVersion.LIKE4.equals((Object)version)) {
            return WebpackInJavaScriptJsonSchemaProvider.loadFile(WebpackInJavaScriptJsonSchemaProvider.class, "/jsonSchemas/webpack-schema4.json");
        }
        return null;
    }

    public WebpackInJavaScriptJsonSchemaProvider(@NotNull WebpackUtil.WebpackVersion version) {
        if (version == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(1);
        }
        this.myVersion = version;
        this.mySchemaFile = WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile(version);
    }

    @Override
    public VirtualFile getSchemaFile() {
        return this.mySchemaFile;
    }

    @Override
    public boolean isAvailable(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(2);
        }
        return WebpackInJavaScriptJsonSchemaProvider.isWebpackInspectionAllowed(element) && WebpackInJavaScriptJsonSchemaProvider.isApplicable(element) && this.myVersion.equals((Object)WebpackUtil.getWebpackVersion(element.getProject()));
    }

    static boolean isAvailableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(3);
        }
        if (!Registry.is((String)"JavaScript.WebPack.With.JsonSchema", (boolean)true)) {
            return false;
        }
        String fileName = file2.getName();
        FileType fileType = file2.getFileType();
        return WebpackInJavaScriptJsonSchemaProvider.isWebpackFile(fileName, fileType);
    }

    static boolean isWebpackFile(String fileName, FileType fileType) {
        return StringUtil.containsIgnoreCase((String)fileName, (String)"webpack") && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType);
    }

    @Nullable
    public static VirtualFile getSchemaIfApplicable(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(4);
        }
        if (!WebpackInJavaScriptJsonSchemaProvider.isApplicable(element)) {
            return null;
        }
        WebpackUtil.WebpackVersion version = WebpackUtil.getWebpackVersion(element.getProject());
        return WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile(version);
    }

    protected static boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(5);
        }
        return element.getContainingFile() != null && WebpackInJavaScriptJsonSchemaProvider.isAvailableForFile(element.getContainingFile()) && WebpackInJavaScriptJsonSchemaProvider.isInSupportedArea(element, WebpackInJavaScriptJsonSchemaProvider::getModuleExportsParts) && WebpackInJavaScriptJsonSchemaProvider.isInTopLevelObject(element);
    }

    static boolean isWebpackInspectionAllowed(@NotNull PsiElement element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(6);
        }
        if (element.getContainingFile() == null) {
            return false;
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String name = InspectionProfileEntry.getShortName((String)WebpackConfigHighlightingInspection.class.getSimpleName());
        InspectionToolWrapper tool = profile.getInspectionTool(name, element.getProject());
        return profile.isToolEnabled(HighlightDisplayKey.find((String)name), element) && tool != null && !tool.getTool().isSuppressedFor(element);
    }

    @NotNull
    static List<TextRange> getModuleExportsParts(@NotNull PsiFile file2) {
        if (file2 == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(7);
        }
        List list2 = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)file2).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(Conditions.instanceOf((Class[])new Class[]{JSAssignmentExpression.class, JSVariable.class}))).traverse().map(WebpackInJavaScriptJsonSchemaProvider::getInitializer).flatten(WebpackInJavaScriptJsonSchemaProvider::collectFromInitializer).map(PsiElement::getTextRange).sort(Comparator.comparingInt(TextRange::getStartOffset)).toList();
        if (list2 == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Nullable
    private static JSExpression getInitializer(PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            return WebpackInJavaScriptJsonSchemaProvider.getModuleExportsAssignmentInitializer((JSAssignmentExpression)element);
        }
        if (element instanceof JSVariable && "webpackConfig".equalsIgnoreCase(((JSVariable)element).getName())) {
            return ((JSVariable)element).getInitializer();
        }
        return null;
    }

    @NotNull
    private static JBIterable<JSExpression> collectFromInitializer(@Nullable JSExpression initializer) {
        if (initializer instanceof JSFunction) {
            JBIterable jBIterable = WebpackInJavaScriptJsonSchemaProvider.computeInitializersFromFunction((JSFunction)initializer).flatten(e -> WebpackInJavaScriptJsonSchemaProvider.getConfigOrConfigArray(e));
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }
        JBIterable<JSExpression> jBIterable = WebpackInJavaScriptJsonSchemaProvider.getConfigOrConfigArray(WebpackInJavaScriptJsonSchemaProvider.computeDefaultInitializer(initializer));
        if (jBIterable == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<JSExpression> getConfigOrConfigArray(@Nullable JSExpression expression) {
        if ((expression = JSUtils.unparenthesize(expression)) instanceof JSObjectLiteralExpression || expression instanceof JSArrayLiteralExpression) {
            JBIterable jBIterable = JBIterable.of((Object)expression);
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        if (expression instanceof JSNewExpression) {
            JBIterable<JSExpression> jBIterable = WebpackInJavaScriptJsonSchemaProvider.getFromPromise((JSNewExpression)expression);
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<JSExpression> getFromPromise(@NotNull JSNewExpression expression) {
        JSParameterListElement firstParameter;
        JSBlockStatement block;
        JSExpression methodExpression;
        if (expression == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(14);
        }
        if (!JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression = expression.getMethodExpression(), "Promise")) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        JSExpression[] arguments = expression.getArguments();
        if (arguments.length == 0) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(16);
            }
            return jBIterable;
        }
        JSExpression first = arguments[0];
        if (first instanceof JSFunctionExpression && (block = ((JSFunctionExpression)first).getBlock()) != null && (firstParameter = (JSParameterListElement)ArrayUtil.getFirstElement((Object[])((JSFunctionExpression)first).getParameters())) instanceof JSParameter) {
            JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)block).filter(JSCallExpression.class).filter(e -> WebpackInJavaScriptJsonSchemaProvider.isReferenceToParameter(e.getMethodExpression(), (JSParameter)firstParameter)).flatten(e -> JBIterable.of((Object[])e.getArguments())).take(1).filter(Conditions.instanceOf(JSObjectLiteralExpression.class));
            if (jBIterable == null) {
                WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    @Contract(value="null, _ -> false")
    private static boolean isReferenceToParameter(@Nullable JSExpression expression, @NotNull JSParameter element) {
        if (element == null) {
            WebpackInJavaScriptJsonSchemaProvider.$$$reportNull$$$0(19);
        }
        return expression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName(expression, element.getName()) && ((JSReferenceExpression)expression).resolve() == element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleExportsParts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFromInitializer";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigOrConfigArray";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWebpackSchemaFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaIfApplicable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWebpackInspectionAllowed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExportsParts";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFromPromise";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

