/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.frameworks.webpack.WebpackInJavaScriptJsonSchemaProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaComplianceChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpackConfigHighlightingInspection
extends JSInspection {
    public final List<String> mySkippedFiles = new ArrayList<String>();

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = JSBundle.message((String)"js.webpack.config.highlighting.name", (Object[])new Object[0]);
        if (string == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(1);
        }
        if (super.isSuppressedFor(element)) {
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        return file2 != null && this.isFileNameToSkip(file2.getName());
    }

    private boolean isFileNameToSkip(String name) {
        if (name == null) {
            return true;
        }
        for (String fileName : this.mySkippedFiles) {
            if (fileName.equals(name)) {
                return true;
            }
            int star = fileName.indexOf(42);
            if (star == -1) continue;
            if (star == 0 && name.endsWith(fileName.substring(1))) {
                return true;
            }
            if (star == fileName.length() - 1 && name.startsWith(fileName.substring(0, fileName.length() - 1))) {
                return true;
            }
            if (fileName.startsWith(fileName.substring(0, star))) {
                return true;
            }
            if (!fileName.endsWith(fileName.substring(star + 1))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        TableView view = new TableView((ListTableModel)new ListTableModel<String>(new ColumnInfo[]{new ColumnInfo<String, String>(null){

            @Nullable
            public String valueOf(String s) {
                return s;
            }

            @NotNull
            public TableCellRenderer getRenderer(final String s) {
                TableCellRenderer tableCellRenderer = new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JLabel label = new JLabel(s);
                        label.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
                        return label;
                    }
                };
                if (tableCellRenderer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return tableCellRenderer;
            }

            @NotNull
            public TableCellEditor getEditor(final String s) {
                final JBTextField field = new JBTextField(s);
                field.setBorder((Border)JBUI.Borders.empty((int)-3, (int)0));
                DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JTextField)field){

                    @Override
                    public boolean stopCellEditing() {
                        WebpackConfigHighlightingInspection.this.mySkippedFiles.set(WebpackConfigHighlightingInspection.this.mySkippedFiles.indexOf(s), field.getText());
                        return super.stopCellEditing();
                    }
                };
                if (defaultCellEditor == null) {
                    1.$$$reportNull$$$0(1);
                }
                return defaultCellEditor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRenderer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEditor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }}, this.mySkippedFiles){

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        });
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)view);
        decorator.setAddAction(e -> {
            view.getListTableModel().addRow((Object)"");
            view.editCellAt(view.getListTableModel().getRowCount() - 1, 0);
        }).setRemoveAction(e -> {
            int[] rows = view.getSelectedRows();
            if (rows != null && rows.length > 0) {
                int cnt = 0;
                for (int row : rows) {
                    view.getListTableModel().removeRow(row - cnt);
                    ++cnt;
                }
                view.getListTableModel().fireTableDataChanged();
            }
        }).disableUpDownActions();
        JLabel label = new JLabel("File name masks to skip from analysis:");
        label.setBorder(JBUI.Borders.empty((int)4));
        panel.add((Component)label, "North");
        JPanel decoratorPanel = decorator.createPanel();
        decoratorPanel.setBorder(BorderFactory.createCompoundBorder(JBUI.Borders.empty((int)4), decoratorPanel.getBorder()));
        panel.add((Component)decoratorPanel, "Center");
        return panel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        PsiFile psiFile;
        if (holder == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(3);
        }
        if (!((psiFile = holder.getFile()) instanceof JSFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                WebpackConfigHighlightingInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        final JsonSchemaService service = JsonSchemaService.Impl.get((Project)holder.getProject());
        if (!service.isApplicableToFile(psiFile.getVirtualFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                WebpackConfigHighlightingInspection.$$$reportNull$$$0(5);
            }
            return psiElementVisitor;
        }
        final Ref schemaObjectRef = new Ref();
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSElement(JSElement element) {
                JsonLikePsiWalker walker;
                VirtualFile schemaFile = WebpackInJavaScriptJsonSchemaProvider.getSchemaIfApplicable((PsiElement)element);
                if (schemaFile == null) {
                    return;
                }
                JsonSchemaObject schemaObject = (JsonSchemaObject)schemaObjectRef.get();
                if (schemaObject == null) {
                    schemaObject = service.getSchemaObjectForSchemaFile(schemaFile);
                    if (schemaObject == null) {
                        return;
                    }
                    schemaObjectRef.set((Object)schemaObject);
                }
                if ((walker = JsonLikePsiWalker.getWalker((PsiElement)element, (JsonSchemaObject)schemaObject)) == null) {
                    return;
                }
                new JsonSchemaComplianceChecker(schemaObject, holder, walker, session, JsonComplianceCheckerOptions.RELAX_ENUM_CHECK, "webpack: ").annotate((PsiElement)element);
            }
        };
        if (jSElementVisitor == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(6);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

