/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSExampleDocBuilderInfo;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSMarkdownUtil;
import com.intellij.lang.javascript.documentation.JSPreDocBuilderInfo;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocBuilderSimpleInfo {
    public static final String NEW_LINE_PLACEHOLDER = "\n";
    protected static final String TAG_FOR_NEW_LINES = "<p>";
    private static final String NEW_LINE_PLACEHOLDER_REPLACEMENT = "\n<p>";
    private static final String PARAGRAPH_PLACEHOLDER = "{{Par%#%L}}";
    @NotNull
    private final StringBuilder myDescription = new StringBuilder();
    protected final List<JSExampleDocBuilderInfo> myExamples = ContainerUtil.newSmartList();
    protected final List<JSPreDocBuilderInfo> myPre = ContainerUtil.newSmartList();
    @Nullable
    JSType type;
    @Nullable
    String modifiers;
    @Nullable
    String finalAccess;
    @Nullable
    String namespace;
    boolean deprecated;
    boolean hasFiredEvents;

    void resetDescription() {
        this.myDescription.setLength(0);
    }

    boolean hasDescription() {
        return this.myDescription.length() > 0;
    }

    void appendBlockDescription(@Nullable CharSequence text) {
        if (this.hasDescription()) {
            this.myDescription.append(PARAGRAPH_PLACEHOLDER);
        }
        this.appendDescription(text);
    }

    void appendNewLines(int count) {
        for (int i = 0; i < count; ++i) {
            this.myDescription.append(NEW_LINE_PLACEHOLDER);
        }
    }

    @NotNull
    String getFinalDescription() {
        String result2 = this.myDescription.toString();
        if (StringUtil.isEmptyOrSpaces((String)result2)) {
            String string = result2;
            if (string == null) {
                JSDocBuilderSimpleInfo.$$$reportNull$$$0(0);
            }
            return string;
        }
        String html = JSDocBuilderSimpleInfo.convertMarkdownToHtml(result2);
        for (JSExampleDocBuilderInfo jSExampleDocBuilderInfo : this.myExamples) {
            html = html.replace(jSExampleDocBuilderInfo.id, jSExampleDocBuilderInfo.generateDoc());
        }
        for (JSPreDocBuilderInfo jSPreDocBuilderInfo : this.myPre) {
            String preDoc = jSPreDocBuilderInfo.generateDoc();
            html = html.replace(TAG_FOR_NEW_LINES + jSPreDocBuilderInfo.id, preDoc).replace(jSPreDocBuilderInfo.id, preDoc);
        }
        String string = html = StringUtil.replace((String)html, (String)PARAGRAPH_PLACEHOLDER, (String)TAG_FOR_NEW_LINES);
        if (string == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String convertNewLinePlaceholdersToTags(@NotNull String generatedDoc) {
        if (generatedDoc == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(2);
        }
        String string = StringUtil.replace((String)generatedDoc, (String)NEW_LINE_PLACEHOLDER, (String)NEW_LINE_PLACEHOLDER_REPLACEMENT);
        if (string == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected static String convertMarkdownToHtml(@NotNull String html) {
        String newHtml;
        if (html == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(4);
        }
        if ((newHtml = JSMarkdownUtil.toHtml(html, true, false)) == null) {
            String string = JSMarkdownUtil.replaceProhibitedTags(JSDocBuilderSimpleInfo.convertNewLinePlaceholdersToTags(html));
            if (string == null) {
                JSDocBuilderSimpleInfo.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (newHtml.startsWith(TAG_FOR_NEW_LINES)) {
            newHtml = StringUtil.trimEnd((String)StringUtil.trimStart((String)newHtml, (String)TAG_FOR_NEW_LINES), (String)"</p>");
        }
        newHtml = StringUtil.replace((String)newHtml, (String)"</p>", (String)"");
        String string = newHtml = StringUtil.replace((String)newHtml, (String)"<br  />", (String)TAG_FOR_NEW_LINES);
        if (string == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    String getRawDescription() {
        String string = this.myDescription.toString();
        if (string == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    void mergeRawDescriptionAndPlaceHolders(@NotNull JSDocBuilderSimpleInfo info) {
        if (info == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(8);
        }
        this.appendDescription(info.getRawDescription());
        this.myExamples.addAll(info.myExamples);
        this.myPre.addAll(info.myPre);
    }

    void appendDescription(@Nullable CharSequence text) {
        if (text == null) {
            return;
        }
        if (this.startsWithUnknownTag(text)) {
            return;
        }
        this.myDescription.append(text);
    }

    protected boolean startsWithUnknownTag(@NotNull CharSequence text) {
        if (text == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(9);
        }
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '@') {
                return i + 1 < text.length() && !StringUtil.equals((CharSequence)"param ", (CharSequence)text.subSequence(i + 1, Math.min(i + 7, text.length())));
            }
            if (!Character.isWhitespace(text.charAt(i))) break;
        }
        return false;
    }

    @NotNull
    JSExampleDocBuilderInfo startExample(@Nullable String text, PsiElement context) {
        String nextId = this.generateId("Example", this.myExamples);
        JSExampleDocBuilderInfo info = new JSExampleDocBuilderInfo(nextId, text, context);
        this.myExamples.add(info);
        this.appendDescription(nextId);
        JSExampleDocBuilderInfo jSExampleDocBuilderInfo = info;
        if (jSExampleDocBuilderInfo == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(10);
        }
        return jSExampleDocBuilderInfo;
    }

    @NotNull
    JSPreDocBuilderInfo startPre() {
        String nextId = this.generateId("Pre", this.myPre);
        JSPreDocBuilderInfo info = new JSPreDocBuilderInfo(nextId);
        this.myPre.add(info);
        this.appendDescription(NEW_LINE_PLACEHOLDER + nextId);
        JSPreDocBuilderInfo jSPreDocBuilderInfo = info;
        if (jSPreDocBuilderInfo == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(11);
        }
        return jSPreDocBuilderInfo;
    }

    @NotNull
    private String generateId(String prefix, List<? extends JSDocBuilderSimpleInfo> map) {
        String string = "{" + prefix + "{" + (map.size() + 1) + "#" + this.hashCode() + "}}";
        if (string == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(12);
        }
        return string;
    }

    void mergeDescriptionWith(@NotNull JSDocBuilderSimpleInfo toMerge) {
        if (toMerge == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(13);
        }
        if (toMerge.hasDescription()) {
            if (this.hasDescription()) {
                boolean addTwoBreaks = !this.endsWithNewLine();
                this.appendNewLines(addTwoBreaks ? 2 : 1);
            }
            this.appendDescription(toMerge.myDescription);
        }
    }

    private boolean endsWithNewLine() {
        return this.myDescription.lastIndexOf(NEW_LINE_PLACEHOLDER) == this.myDescription.length() - NEW_LINE_PLACEHOLDER.length();
    }

    @NotNull
    CharSequence getTypeString(@Nullable PsiElement context) {
        CharSequence charSequence = JSHtmlHighlightingUtil.getTypeHtmlHighlighting(this.type, context, this.hasFiredEvents);
        if (charSequence == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(14);
        }
        return charSequence;
    }

    boolean hasType() {
        return JSFormatUtil.isPossiblyPresentableType(this.type, null, true) && this.type.isSourceStrict();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocBuilderSimpleInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedDoc";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMerge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalDescription";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocBuilderSimpleInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNewLinePlaceholdersToTags";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMarkdownToHtml";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "startExample";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "startPre";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generateId";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertNewLinePlaceholdersToTags";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertMarkdownToHtml";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeRawDescriptionAndPlaceHolders";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startsWithUnknownTag";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mergeDescriptionWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

