/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.application.options.CodeCompletionOptionsCustomSection;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class JSCodeCompletionConfigurable
implements Configurable,
CodeCompletionOptionsCustomSection {
    private static final int LEFT_GAP = 20;
    private JBCheckBox myOnlyTypeBasedCompletion;
    private JBCheckBox myVarNamesCompletion;
    private JBCheckBox myVarNamesWithTypes;
    private JBCheckBox myOverridesCompletion;

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return "JavaScript";
    }

    @Nullable
    public JComponent createComponent() {
        this.myOnlyTypeBasedCompletion = new JBCheckBox(JSBundle.message((String)"settings.javascript.only.type.based.completion", (Object[])new Object[0]));
        this.myVarNamesCompletion = new JBCheckBox(JSBundle.message((String)"settings.javascript.var.names.completion", (Object[])new Object[0]) + "  ");
        this.myVarNamesWithTypes = new JBCheckBox(JSBundle.message((String)"settings.javascript.var.names.completion.types", (Object[])new Object[0]));
        this.myVarNamesCompletion.addChangeListener(e -> {
            Object source = e.getSource();
            if (source instanceof JBCheckBox) {
                this.myVarNamesWithTypes.setEnabled(((JBCheckBox)source).isSelected());
            }
        });
        this.myOverridesCompletion = new JBCheckBox(JSBundle.message((String)"settings.javascript.overrides.completion", (Object[])new Object[0]));
        FormBuilder builder = FormBuilder.createFormBuilder().addLabeledComponent((JComponent)new JLabel("JavaScript"), (JComponent)new JSeparator()).setFormLeftIndent(20).addVerticalGap(2);
        JSCodeCompletionConfigurable.addWithComment(builder, (JComponent)this.myOnlyTypeBasedCompletion, JSBundle.message((String)"settings.javascript.only.type.based.completion.tooltip", (Object[])new Object[0]));
        this.myOnlyTypeBasedCompletion.setSelected(JSApplicationSettings.getInstance().isOnlyTypeBasedCompletion());
        JSCodeCompletionConfigurable.addWithComment(builder, (JComponent)this.myVarNamesCompletion, JSBundle.message((String)"settings.javascript.var.names.completion.tooltip", (Object[])new Object[0]));
        JSCodeCompletionConfigurable.addWithComment(builder, (JComponent)this.myVarNamesWithTypes, JSBundle.message((String)"settings.javascript.var.names.completion.types.tooltip", (Object[])new Object[0]));
        builder.addComponent((JComponent)this.myOverridesCompletion);
        this.myVarNamesCompletion.setSelected(JSApplicationSettings.getInstance().isUseVarNamesCompletion());
        this.setVariableCompletionKind(JSApplicationSettings.getInstance().getVariableCompletionKind());
        this.myOverridesCompletion.setSelected(JSApplicationSettings.getInstance().isUseOverridesCompletion());
        return builder.getPanel();
    }

    private static void addWithComment(FormBuilder builder, JComponent box, String s) {
        builder.addComponent((JComponent)new ComponentPanelBuilder(box).withComment(s).createPanel());
    }

    public boolean isModified() {
        return JSApplicationSettings.getInstance().isOnlyTypeBasedCompletion() != this.myOnlyTypeBasedCompletion.isSelected() || JSApplicationSettings.getInstance().isUseVarNamesCompletion() != this.myVarNamesCompletion.isSelected() || JSApplicationSettings.getInstance().getVariableCompletionKind() != this.getVariableCompletionKind() || JSApplicationSettings.getInstance().isUseOverridesCompletion() != this.myOverridesCompletion.isSelected();
    }

    public void apply() throws ConfigurationException {
        JSApplicationSettings.getInstance().setOnlyTypeBasedCompletion(this.myOnlyTypeBasedCompletion.isSelected());
        JSApplicationSettings.getInstance().setUseVarNamesCompletion(this.myVarNamesCompletion.isSelected());
        JSApplicationSettings.getInstance().setVariableCompletionKind(this.getVariableCompletionKind());
        JSApplicationSettings.getInstance().setUseOverridesCompletion(this.myOverridesCompletion.isSelected());
    }

    private JSApplicationSettings.VariableCompletionKind getVariableCompletionKind() {
        return this.myVarNamesWithTypes.isSelected() ? JSApplicationSettings.VariableCompletionKind.TYPES_FOR_PARAMS : JSApplicationSettings.VariableCompletionKind.NAMES_ONLY;
    }

    private void setVariableCompletionKind(JSApplicationSettings.VariableCompletionKind kind) {
        this.myVarNamesWithTypes.setSelected(kind != JSApplicationSettings.VariableCompletionKind.NAMES_ONLY);
    }
}

