/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.ide.actions.runAnything.items.RunAnythingHelpItem;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskRunAction;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.runAnything.JsbtRunAnythingProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmScriptRunAnythingProvider
extends JsbtRunAnythingProvider {
    @Override
    @NotNull
    public String getCommand(@NotNull JsbtTaskRunAction value) {
        Project project;
        if (value == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(0);
        }
        if ((project = value.getProject()) == null) {
            if ("Unavailable" == null) {
                NpmScriptRunAnythingProvider.$$$reportNull$$$0(1);
            }
            return "Unavailable";
        }
        NodePackageRef ref = NpmManager.getInstance(project).getPackageRef();
        String string = NpmManager.getNpmCommandPresentableText(ref, NpmCommand.RUN_SCRIPT) + " " + StringUtil.join(value.getTaskSet().getTaskNames(), (String)" ");
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected JsbtService getService() {
        NpmScriptsService npmScriptsService = NpmScriptsService.getInstance();
        if (npmScriptsService == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(3);
        }
        return npmScriptsService;
    }

    @Nullable
    public Icon getIcon(@NotNull JsbtTaskRunAction value) {
        Project project;
        if (value == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(4);
        }
        if ((project = value.getProject()) == null) {
            return super.getIcon((AnAction)value);
        }
        return NpmScriptRunAnythingProvider.getIcon(NpmScriptRunAnythingProvider.isYarn(project));
    }

    @Override
    @NotNull
    protected List<JsbtFileStructure> getFileStructures(@NotNull Project project) {
        VirtualFile root;
        VirtualFile packageJson;
        if (project == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(5);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile(root = !project.isDefault() ? ProjectUtil.guessProjectDir((Project)project) : null)) == null) {
            List<JsbtFileStructure> list2 = Collections.emptyList();
            if (list2 == null) {
                NpmScriptRunAnythingProvider.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List list3 = ContainerUtil.createMaybeSingletonList((Object)this.getBuildfileStructure(project, packageJson));
        if (list3 == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(7);
        }
        return list3;
    }

    @Override
    @Nullable
    protected JsbtFileStructure getBuildfileStructure(@NotNull Project project, @NotNull VirtualFile buildfile) {
        if (project == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(8);
        }
        if (buildfile == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(9);
        }
        try {
            return NpmScriptsService.getInstance().fetchBuildfileStructure(project, buildfile);
        }
        catch (JsbtTaskFetchException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public String getCompletionGroupTitle() {
        return "npm scripts";
    }

    @Nullable
    public RunAnythingHelpItem getHelpItem(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(10);
        }
        if ((project = (Project)dataContext.getData(CommonDataKeys.PROJECT)) == null) {
            return null;
        }
        boolean yarn = NpmScriptRunAnythingProvider.isYarn(project);
        return new RunAnythingHelpItem(NpmScriptRunAnythingProvider.getHelpCommandPlaceholder(yarn), NpmScriptRunAnythingProvider.getCommandPrefix(yarn), this.getHelpDescription(), NpmScriptRunAnythingProvider.getIcon(yarn));
    }

    @Override
    @Nullable
    public Icon getHelpIcon() {
        return NpmScriptRunAnythingProvider.getIcon(false);
    }

    @Override
    @NotNull
    protected String getCommandPrefix(@NotNull Project project) {
        if (project == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(11);
        }
        String string = NpmScriptRunAnythingProvider.getCommandPrefix(NpmScriptRunAnythingProvider.isYarn(project));
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String getCommandPrefix(boolean yarn) {
        String string = NpmManager.getNpmPackagePresentableName(yarn);
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static boolean isYarn(@NotNull Project project) {
        if (project == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(14);
        }
        return NpmUtil.isYarnAlikePackageRef(NpmManager.getInstance(project).getPackageRef());
    }

    @Nullable
    public String getHelpCommandPlaceholder() {
        return NpmScriptRunAnythingProvider.getHelpCommandPlaceholder(false);
    }

    @NotNull
    private static String getHelpCommandPlaceholder(boolean yarn) {
        String string = NpmScriptRunAnythingProvider.getCommandPrefix(yarn) + " run <script name>";
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHelpCommand() {
        if ("npm" == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(16);
        }
        return "npm";
    }

    @Override
    @Nullable
    public String getHelpGroupTitle() {
        return "npm";
    }

    static Icon getIcon(boolean yarn) {
        return yarn ? JavaScriptLanguageIcons.Nodejs.Yarn : JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptRunAnythingProvider";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptRunAnythingProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStructures";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommandPlaceholder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileStructures";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBuildfileStructure";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHelpItem";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommandPrefix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isYarn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

