/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedJsonSchemaFileProvider
implements JsonSchemaFileProvider {
    private final VirtualFile mySchemaFile;
    private final String myFilename;
    @Nullable
    private final String myRemoteSourceUrl;
    @Nullable
    private final String myPresentableName;
    @NotNull
    private final Set<String> myUserFilename;

    public EmbeddedJsonSchemaFileProvider(@NotNull String resourceName, @Nullable String presentableName, @Nullable String remoteSourceUrl, @NotNull Class clazz, @NotNull String pathToFilename, String ... userFilename) {
        if (resourceName == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(1);
        }
        if (pathToFilename == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(2);
        }
        if (userFilename == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(3);
        }
        this.myFilename = resourceName;
        this.myRemoteSourceUrl = remoteSourceUrl;
        this.myUserFilename = userFilename.length == 0 ? Collections.singleton(resourceName) : ContainerUtil.set((Object[])userFilename);
        this.mySchemaFile = JsonSchemaProviderFactory.getResourceFile((Class)clazz, (String)(pathToFilename + this.myFilename));
        this.myPresentableName = presentableName;
    }

    @Deprecated
    public EmbeddedJsonSchemaFileProvider(@NotNull String resourceName, @NotNull Class clazz, @NotNull String pathToFilename, String ... userFilename) {
        if (resourceName == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(5);
        }
        if (pathToFilename == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(6);
        }
        if (userFilename == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(7);
        }
        this(resourceName, null, null, clazz, pathToFilename, userFilename);
    }

    public EmbeddedJsonSchemaFileProvider(@NotNull VirtualFile schemaFile, String ... userFilename) {
        if (schemaFile == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(8);
        }
        if (userFilename == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(9);
        }
        this.mySchemaFile = schemaFile;
        this.myFilename = schemaFile.getName();
        this.myUserFilename = ContainerUtil.set((Object[])userFilename);
        this.myPresentableName = null;
        this.myRemoteSourceUrl = null;
    }

    public boolean isAvailable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(10);
        }
        return this.myUserFilename.contains(file2.getName());
    }

    @NotNull
    public String getName() {
        String string = this.myFilename;
        if (string == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public VirtualFile getSchemaFile() {
        return this.mySchemaFile;
    }

    @NotNull
    public SchemaType getSchemaType() {
        SchemaType schemaType = SchemaType.embeddedSchema;
        if (schemaType == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(12);
        }
        return schemaType;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName == null ? this.getName() : this.myPresentableName;
        if (string == null) {
            EmbeddedJsonSchemaFileProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isUserVisible() {
        return this.myPresentableName != null;
    }

    @Nullable
    public String getRemoteSource() {
        return this.myRemoteSourceUrl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToFilename";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userFilename";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/EmbeddedJsonSchemaFileProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

