/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestFileIndexingHandler;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTestFailedLineManager {
    private final Map<String, FailedTestData> myMap;
    private final Project myProject;
    private final Alarm myRestartDaemonAlarm;
    private volatile boolean myDaemonRestartRequested;

    public JSTestFailedLineManager(@NotNull Project project) {
        if (project == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(0);
        }
        this.myMap = ContainerUtil.newConcurrentMap();
        this.myDaemonRestartRequested = false;
        this.myProject = project;
        this.myRestartDaemonAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myProject);
    }

    @NotNull
    public static JSTestFailedLineManager getInstance(@NotNull Project project) {
        if (project == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(1);
        }
        JSTestFailedLineManager jSTestFailedLineManager = (JSTestFailedLineManager)ServiceManager.getService((Project)project, JSTestFailedLineManager.class);
        if (jSTestFailedLineManager == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(2);
        }
        return jSTestFailedLineManager;
    }

    @Nullable
    public FailedTestInfo getFailedLineInfoForElement(@NotNull PsiElement methodExpr) {
        ResolveResult result2;
        PsiElement element;
        if (methodExpr == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = element = (result2 = this.findFailedLineForTest(methodExpr)) != null && result2.myPointer != null ? result2.myPointer.getElement() : null;
        if (element == methodExpr) {
            return result2.myTestInfo;
        }
        return null;
    }

    @Nullable
    public ResolveResult findFailedLineForTest(@NotNull PsiElement innerTestElement) {
        JSFile file2;
        if (innerTestElement == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(4);
        }
        if ((file2 = (JSFile)ObjectUtils.tryCast((Object)innerTestElement.getContainingFile(), JSFile.class)) == null) {
            return null;
        }
        if (this.myMap.isEmpty()) {
            return null;
        }
        for (AbstractTestFileStructureBuilder builder : JsTestFileIndexingHandler.getFileStructureBuilders()) {
            AbstractTestFileStructure structure = builder.fetchCachedTestFileStructure(file2);
            JsTestElementPath path = structure.findTestElementPath(innerTestElement.getTextRange());
            if (path == null) continue;
            FailedTestData data = this.myMap.get(JSTestFailedLineManager.locationUrl(path, false));
            if (data == null) {
                data = this.myMap.get(JSTestFailedLineManager.locationUrl(path, true));
            }
            if (data == null) continue;
            ResolveResult result2 = data.myResult;
            if (result2 == null) {
                JSTestFailedLineManager.resolveFailedLine(path.getTestElement(), data);
                result2 = Objects.requireNonNull(data.myResult);
            }
            return result2;
        }
        return null;
    }

    @NotNull
    public static String locationUrl(@NotNull JsTestElementPath path, boolean withTestFilePath) {
        VirtualFile file2;
        if (path == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(5);
        }
        String schema = path.getTestName() != null ? "test://" : "suite://";
        List names = path.getAllNames();
        if (withTestFilePath && (file2 = PsiUtilCore.getVirtualFile((PsiElement)path.getTestElement())) != null) {
            names.add(0, FileUtil.toSystemDependentName((String)file2.getPath()));
        }
        String string = schema + EscapeUtils.join((Collection)names, (char)'.');
        if (string == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void resolveFailedLine(@NotNull PsiElement enclosingElement, @NotNull FailedTestData data) {
        if (enclosingElement == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(7);
        }
        if (data == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(8);
        }
        String stacktrace = data.myTestInfo.myStacktrace;
        String withoutAnsiStackTrace = JSTestFailedLineManager.clearAnsi(stacktrace);
        int stacktraceLength = withoutAnsiStackTrace.length();
        String[] lines = StringUtil.splitByLines((String)withoutAnsiStackTrace);
        PsiElement failedAssertionElement = null;
        OpenFileDescriptor failedAssertionDescriptor = null;
        for (String line : lines) {
            PsiElement element;
            OpenFileDescriptor descriptor2;
            HyperlinkInfo info;
            Filter.Result result2 = data.myFilter.applyFilter(line, stacktraceLength);
            HyperlinkInfo hyperlinkInfo = info = result2 != null ? result2.getFirstHyperlinkInfo() : null;
            if (!(info instanceof FileHyperlinkInfo) || (descriptor2 = ((FileHyperlinkInfo)info).getDescriptor()) == null || (element = JSTestFailedLineManager.findElementAtOffsetIfInside(enclosingElement, descriptor2)) == null) continue;
            failedAssertionElement = element;
            failedAssertionDescriptor = descriptor2;
        }
        data.myResult = new ResolveResult(failedAssertionElement != null ? SmartPointerManager.createPointer(failedAssertionElement) : null, failedAssertionDescriptor, data.myTestInfo);
    }

    @NotNull
    private static String clearAnsi(@NotNull String stacktrace) {
        if (stacktrace == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(9);
        }
        StringBuilder buffer = new StringBuilder();
        new AnsiEscapeDecoder().escapeText(stacktrace, ProcessOutputTypes.STDOUT, (text, attributes) -> buffer.append(text));
        String string = buffer.toString();
        if (string == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static PsiElement findElementAtOffsetIfInside(@NotNull PsiElement enclosingElement, @NotNull OpenFileDescriptor descriptor2) {
        int offset;
        PsiFile file2;
        if (enclosingElement == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(11);
        }
        if (descriptor2 == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(12);
        }
        PsiFile psiFile = file2 = (file2 = enclosingElement.getContainingFile()) != null ? file2.getOriginalFile() : null;
        if (file2 != null && descriptor2.getFile().equals(file2.getVirtualFile()) && (offset = descriptor2.getOffset()) >= 0 && enclosingElement.getTextRange().contains(offset)) {
            return file2.findElementAt(offset);
        }
        return null;
    }

    public void onTestConfigurationStarted(@NotNull GeneralTestEventsProcessor processor, final @NotNull Filter filter) {
        if (processor == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(13);
        }
        if (filter == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(14);
        }
        processor.addEventsListener((SMTRunnerEventsListener)new SMTRunnerEventsAdapter(){

            public void onTestStarted(@NotNull SMTestProxy test) {
                if (test == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSTestFailedLineManager.this.addInfo(test.getLocationUrl(), null, null, filter);
            }

            public void onTestFinished(@NotNull SMTestProxy test) {
                if (test == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (test.isPassed()) {
                    JSTestFailedLineManager.this.addInfo(test.getLocationUrl(), null, null, filter);
                }
            }

            public void onTestFailed(@NotNull SMTestProxy test) {
                if (test == null) {
                    1.$$$reportNull$$$0(2);
                }
                JSTestFailedLineManager.this.addInfo(test.getLocationUrl(), test.getErrorMessage(), test.getStacktrace(), filter);
            }

            public void onTestIgnored(@NotNull SMTestProxy test) {
                if (test == null) {
                    1.$$$reportNull$$$0(3);
                }
                JSTestFailedLineManager.this.addInfo(test.getLocationUrl(), test.getErrorMessage(), test.getStacktrace(), filter);
            }

            public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
                if (testsRoot == null) {
                    1.$$$reportNull$$$0(4);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (JSTestFailedLineManager.this.myDaemonRestartRequested) {
                        JSTestFailedLineManager.this.myRestartDaemonAlarm.cancelAllRequests();
                        DaemonCodeAnalyzer.getInstance((Project)JSTestFailedLineManager.this.myProject).restart();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "test";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testsRoot";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/testing/JSTestFailedLineManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestFinished";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestFailed";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestIgnored";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestingFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void addInfo(@Nullable String locationUrl, @Nullable String errorMessage, @Nullable String stacktrace, @NotNull Filter filter) {
        boolean changed;
        if (filter == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(15);
        }
        if (locationUrl == null) {
            return;
        }
        if (stacktrace == null || filter instanceof CompositeFilter && ((CompositeFilter)filter).isEmpty()) {
            changed = this.myMap.remove(locationUrl) != null;
        } else {
            FailedTestData data = new FailedTestData(new FailedTestInfo(errorMessage, stacktrace), filter);
            this.myMap.put(locationUrl, data);
            changed = true;
        }
        if (changed) {
            this.requestDaemonRestart();
        }
    }

    private void requestDaemonRestart() {
        if (this.myRestartDaemonAlarm.isEmpty()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            this.myRestartDaemonAlarm.addRequest(() -> {
                if (this.myDaemonRestartRequested) {
                    this.myRestartDaemonAlarm.cancelAllRequests();
                    this.myDaemonRestartRequested = false;
                    this.requestDaemonRestart();
                }
            }, 300);
        } else {
            this.myDaemonRestartRequested = true;
        }
    }

    @NotNull
    public static String ansiToHtml(@NotNull String text) {
        if (text == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(16);
        }
        StringBuilder buffer = new StringBuilder();
        AtomicBoolean colored = new AtomicBoolean(false);
        new AnsiEscapeDecoder().escapeText(text, ProcessOutputTypes.STDOUT, (chunk, attributes) -> {
            ConsoleViewContentType type = ConsoleViewContentType.getConsoleViewType((Key)attributes);
            if (type == ConsoleViewContentType.NORMAL_OUTPUT) {
                buffer.append(chunk);
            } else {
                colored.set(true);
                buffer.append("<span style='color:#").append(ColorUtil.toHex((Color)type.getAttributes().getForegroundColor())).append(";'>");
                buffer.append(chunk);
                buffer.append("</span>");
            }
        });
        if (colored.get()) {
            String string = "<html><body>" + buffer.toString() + "</body></html>";
            if (string == null) {
                JSTestFailedLineManager.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = buffer.toString();
        if (string == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static String prependNewLineWithSpace(@NotNull String text) {
        char lf;
        int lfCount;
        if (text == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(19);
        }
        if ((lfCount = StringUtil.countChars((CharSequence)(text = StringUtil.convertLineSeparators((String)text)), (char)(lf = '\n'))) == 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder(text.length() + lfCount);
        int i = 0;
        while (i < text.length()) {
            int count = JSTestFailedLineManager.countChars(text, i, lf);
            if (count > 0) {
                int j;
                for (j = 0; j < count; ++j) {
                    builder.append(' ');
                }
                for (j = 0; j < count; ++j) {
                    builder.append(lf);
                }
                i += count;
                continue;
            }
            builder.append(text.charAt(i));
            ++i;
        }
        return builder.toString();
    }

    private static int countChars(@NotNull String text, int offset, char ch) {
        if (text == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(20);
        }
        int count = 0;
        for (int i = offset; i < text.length() && text.charAt(i) == ch; ++i) {
            ++count;
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JSTestFailedLineManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerTestElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JSTestFailedLineManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "locationUrl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAnsi";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "ansiToHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFailedLineInfoForElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFailedLineForTest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "locationUrl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveFailedLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "clearAnsi";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtOffsetIfInside";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onTestConfigurationStarted";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "ansiToHtml";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "prependNewLineWithSpace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FailedTestInfo {
        @Nullable
        private final String myMessage;
        @NotNull
        private final String myStacktrace;

        public FailedTestInfo(@Nullable String message, @NotNull String stacktrace) {
            if (stacktrace == null) {
                FailedTestInfo.$$$reportNull$$$0(0);
            }
            this.myMessage = message;
            this.myStacktrace = stacktrace;
        }

        @Nullable
        public String getMessage() {
            if (this.myMessage != null) {
                String text = JSTestFailedLineManager.prependNewLineWithSpace(this.myMessage);
                return JSTestFailedLineManager.ansiToHtml(text);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stacktrace", "com/intellij/javascript/testing/JSTestFailedLineManager$FailedTestInfo", "<init>"));
        }
    }

    public static class ResolveResult {
        @Nullable
        private final SmartPsiElementPointer<PsiElement> myPointer;
        @Nullable
        private final OpenFileDescriptor myDescriptor;
        private final FailedTestInfo myTestInfo;

        private ResolveResult(@Nullable SmartPsiElementPointer<PsiElement> pointer, @Nullable OpenFileDescriptor descriptor2, @Nullable FailedTestInfo testInfo) {
            this.myPointer = pointer;
            this.myDescriptor = descriptor2;
            this.myTestInfo = testInfo;
        }

        @Nullable
        public OpenFileDescriptor getDescriptor() {
            return this.myDescriptor;
        }
    }

    private static class FailedTestData {
        private final FailedTestInfo myTestInfo;
        private final Filter myFilter;
        private ResolveResult myResult;

        private FailedTestData(@NotNull FailedTestInfo testInfo, @NotNull Filter filter) {
            if (testInfo == null) {
                FailedTestData.$$$reportNull$$$0(0);
            }
            if (filter == null) {
                FailedTestData.$$$reportNull$$$0(1);
            }
            this.myFilter = filter;
            this.myTestInfo = testInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/testing/JSTestFailedLineManager$FailedTestData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

