/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.interpreter.LeftRightJustifyingLayoutManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NodePackageRenderer
implements ListCellRenderer<NodePackageRef> {
    private static final SimpleTextAttributes DETAILS_ATTRS = new SimpleTextAttributes(128, null);
    private static final SimpleTextAttributes GRAY_DETAILS_ATTRS = new SimpleTextAttributes(128, (Color)JBColor.GRAY);
    private final SimpleColoredComponent myNameComp;
    private final SimpleColoredComponent myDetailsComp;
    private final SimpleColoredComponent myVersionComp;
    private final JPanel myPanel;
    private final NodePackageRefResolver myResolver;

    NodePackageRenderer(@NotNull NodePackageRefResolver resolver) {
        if (resolver == null) {
            NodePackageRenderer.$$$reportNull$$$0(0);
        }
        this.myNameComp = new SimpleColoredComponent();
        this.myDetailsComp = new SimpleColoredComponent();
        this.myVersionComp = new SimpleColoredComponent();
        this.myPanel = new JPanel(new GridBagLayout());
        this.myResolver = resolver;
        this.myNameComp.setOpaque(false);
        this.myNameComp.setIpad((Insets)JBUI.emptyInsets());
        this.myNameComp.setMyBorder(null);
        this.myDetailsComp.setOpaque(false);
        this.myDetailsComp.setIpad((Insets)JBUI.emptyInsets());
        this.myDetailsComp.setMyBorder(null);
        this.myVersionComp.setOpaque(false);
        this.myVersionComp.setIpad((Insets)JBUI.emptyInsets());
        this.myVersionComp.setMyBorder(null);
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)1));
        NodeJsInterpreterRenderer.adjustBorderHeight(this.myNameComp);
        JPanel nameContainer = NodePackageRenderer.wrapInLeftRightJustifyingContainer(this.myNameComp);
        this.myPanel.add((Component)nameContainer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 256, 3, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myPanel.add((Component)this.myDetailsComp, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 256, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myPanel.add((Component)this.myVersionComp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    @NotNull
    private static JPanel wrapInLeftRightJustifyingContainer(final @NotNull SimpleColoredComponent component) {
        if (component == null) {
            NodePackageRenderer.$$$reportNull$$$0(1);
        }
        JPanel container = new JPanel((LayoutManager)new LeftRightJustifyingLayoutManager()){

            @Override
            public int getBaseline(int width, int height) {
                return component.getBaseline(width, height);
            }
        };
        container.setBorder((Border)JBUI.Borders.empty());
        container.setOpaque(false);
        container.add((Component)component);
        JPanel jPanel = container;
        if (jPanel == null) {
            NodePackageRenderer.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    public Component getListCellRendererComponent(@NotNull JList<? extends NodePackageRef> list2, @NotNull NodePackageRef ref, int index, boolean isSelected, boolean cellHasFocus) {
        if (list2 == null) {
            NodePackageRenderer.$$$reportNull$$$0(3);
        }
        if (ref == null) {
            NodePackageRenderer.$$$reportNull$$$0(4);
        }
        Font baseFont = list2.getFont();
        this.myNameComp.setFont(baseFont);
        if (this.myPanel.isEnabled() != list2.isEnabled()) {
            UIUtil.setEnabled((Component)this.myPanel, (boolean)list2.isEnabled(), (boolean)true);
        }
        this.myPanel.setBackground(isSelected ? list2.getSelectionBackground() : list2.getBackground());
        Color foreground = isSelected ? list2.getSelectionForeground() : list2.getForeground();
        this.myNameComp.setForeground(foreground);
        this.myDetailsComp.setForeground(foreground);
        this.myVersionComp.setForeground(foreground);
        this.myNameComp.clear();
        this.myNameComp.append(ref.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        NodePackage pkg = this.myResolver.resolve(ref);
        NodePackageRenderer.formatDetailsAndVersionComponents(this.myDetailsComp, this.myVersionComp, ref, pkg, isSelected);
        return this.myPanel;
    }

    static void formatDetailsAndVersionComponents(@NotNull SimpleColoredComponent detailsComponent, @NotNull SimpleColoredComponent versionComponent, @NotNull NodePackageRef pkgRef, @Nullable NodePackage pkg, boolean isSelected) {
        if (detailsComponent == null) {
            NodePackageRenderer.$$$reportNull$$$0(5);
        }
        if (versionComponent == null) {
            NodePackageRenderer.$$$reportNull$$$0(6);
        }
        if (pkgRef == null) {
            NodePackageRenderer.$$$reportNull$$$0(7);
        }
        detailsComponent.clear();
        versionComponent.clear();
        String detailsLeftSpacing = "  ";
        String versionLeftSpacing = "   ";
        if (pkg != null) {
            SemVer version;
            String path;
            String string = path = !pkgRef.isConstant() ? pkg.getPresentablePath() : "";
            if (!path.isEmpty()) {
                detailsComponent.append(detailsLeftSpacing);
                detailsComponent.append(path, isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            if ((version = pkg.getVersion()) != null) {
                versionComponent.append(versionLeftSpacing);
                versionComponent.append(version.getRawVersion(), isSelected ? DETAILS_ATTRS : GRAY_DETAILS_ATTRS);
            }
        } else {
            detailsComponent.append(detailsLeftSpacing);
            detailsComponent.append("Not found ", isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInLeftRightJustifyingContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wrapInLeftRightJustifyingContainer";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getListCellRendererComponent";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatDetailsAndVersionComponents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

