/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodePackage;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageDescriptor {
    private final List<String> myPackageNames;
    private final Map<String, String> myDependencyByPackageMap;
    private final String myHintText;

    public NodePackageDescriptor(@NotNull String packageName) {
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(0);
        }
        this(Collections.singletonList(packageName), null);
    }

    public NodePackageDescriptor(String ... packageNames) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(1);
        }
        this((List<String>)ImmutableList.copyOf((Object[])packageNames), null);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(2);
        }
        this((List<String>)ImmutableList.copyOf(packageNames), null);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames, @Nullable String hintText) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(3);
        }
        this((List<String>)ImmutableList.copyOf(packageNames), (Map<String, String>)ImmutableMap.of(), hintText);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames, @NotNull Map<String, String> dependencyByPackageMap, @Nullable String hintText) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(4);
        }
        if (dependencyByPackageMap == null) {
            NodePackageDescriptor.$$$reportNull$$$0(5);
        }
        this.myPackageNames = ImmutableList.copyOf(packageNames);
        this.myDependencyByPackageMap = ImmutableMap.copyOf(dependencyByPackageMap);
        this.myHintText = hintText;
    }

    @NotNull
    public List<String> getPackageNames() {
        List<String> list2 = this.myPackageNames;
        if (list2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    public String getDependencyByPackageName(@NotNull String packageName) {
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(7);
        }
        return this.myDependencyByPackageMap.get(packageName);
    }

    @NotNull
    public NodePackage createPackage(@NotNull String path) {
        WslNodePackage wslNodePackage;
        if (path == null) {
            NodePackageDescriptor.$$$reportNull$$$0(8);
        }
        if ((wslNodePackage = WslNodePackage.createIfWslPackagePath(path)) != null) {
            WslNodePackage wslNodePackage2 = wslNodePackage;
            if (wslNodePackage2 == null) {
                NodePackageDescriptor.$$$reportNull$$$0(9);
            }
            return wslNodePackage2;
        }
        NodePackage nodePackage = new NodePackage(path);
        if (nodePackage == null) {
            NodePackageDescriptor.$$$reportNull$$$0(10);
        }
        return nodePackage;
    }

    @NotNull
    public NodePackageRef createPackageRef(@NotNull String text) {
        if (text == null) {
            NodePackageDescriptor.$$$reportNull$$$0(11);
        }
        NodePackageRef nodePackageRef = NodePackageRef.create(this.createPackage(text));
        if (nodePackageRef == null) {
            NodePackageDescriptor.$$$reportNull$$$0(12);
        }
        return nodePackageRef;
    }

    @NotNull
    public NodePackageRef dereferenceIfProjectRef(@NotNull Project project, @NotNull NodePackageRef ref) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(13);
        }
        if (ref == null) {
            NodePackageDescriptor.$$$reportNull$$$0(14);
        }
        NodePackageRef nodePackageRef = ref;
        if (nodePackageRef == null) {
            NodePackageDescriptor.$$$reportNull$$$0(15);
        }
        return nodePackageRef;
    }

    @NotNull
    public NodePackage findFirstDirectDependencyPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(16);
        }
        NodePackage nodePackage = (NodePackage)ReadAction.compute(() -> {
            List<NodePackage> packages = this.listAvailable(project, interpreter, contextFileOrDirectory, true);
            NodePackage pkg = (NodePackage)ContainerUtil.getFirstItem(packages);
            return pkg != null ? pkg : this.createPackage("");
        });
        if (nodePackage == null) {
            NodePackageDescriptor.$$$reportNull$$$0(17);
        }
        return nodePackage;
    }

    @NotNull
    public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(18);
        }
        List<NodePackage> packages = this.listAvailable(project, interpreter, contextFileOrDirectory, false);
        List list2 = ContainerUtil.map(packages, pkg -> NodePackageRef.create(pkg));
        if (list2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    public final List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(20);
        }
        List<NodePackage> list2 = this.listAvailable(project, interpreter, contextFileOrDirectory, false);
        if (list2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(22);
        }
        List<NodePackage> list2 = this.listAvailable(project, interpreter, contextFileOrDirectory, directDependenciesInsideProject, false);
        if (list2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @NotNull
    public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject, boolean dependenciesShouldBeVisibleFromContext) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(24);
        }
        LinkedHashSet packages = new LinkedHashSet();
        LinkedHashSet globalPackages = new LinkedHashSet();
        for (String packageName : this.myPackageNames) {
            ReadAction.run(() -> NodePackageDescriptor.listAvailable(packages, globalPackages, packageName, this.myDependencyByPackageMap.get(packageName), project, interpreter, contextFileOrDirectory, directDependenciesInsideProject, this::createPackage));
        }
        LinkedHashSet<NodePackage> result2 = new LinkedHashSet<NodePackage>();
        if (contextFileOrDirectory != null) {
            MultiMap map = MultiMap.create();
            for (NodePackageAndPackageJson pkg : packages) {
                VirtualFile root = pkg.getPackageJson() != null ? pkg.getPackageJson().getParent() : null;
                if (root == null) continue;
                map.putValue((Object)root, (Object)pkg.getPackage());
            }
            for (VirtualFile dir = contextFileOrDirectory; dir != null; dir = dir.getParent()) {
                result2.addAll(map.get((Object)dir));
            }
        }
        if (!dependenciesShouldBeVisibleFromContext) {
            for (NodePackageAndPackageJson pkg : packages) {
                result2.add(pkg.getPackage());
            }
        }
        result2.addAll(globalPackages);
        ArrayList<NodePackage> arrayList = new ArrayList<NodePackage>(result2);
        if (arrayList == null) {
            NodePackageDescriptor.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Nullable
    public String getHintText() {
        String pkgText;
        if (this.myHintText != null) {
            return this.myHintText;
        }
        if (this.myPackageNames.size() == 1) {
            pkgText = (String)ContainerUtil.getFirstItem(this.myPackageNames);
        } else if (this.myPackageNames.size() > 1) {
            pkgText = StringUtil.join(this.myPackageNames.subList(0, this.myPackageNames.size() - 1), (String)", ") + " or " + (String)ContainerUtil.getLastItem(this.myPackageNames);
        } else {
            return null;
        }
        return "path to " + pkgText + " package directory";
    }

    private static void listAvailable(@NotNull Set<NodePackageAndPackageJson> packages, @NotNull Set<NodePackage> globalPackages, @NotNull String packageName, @Nullable String dependencyName, @NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject, @NotNull NodePackageProducer packageProducer) {
        if (packages == null) {
            NodePackageDescriptor.$$$reportNull$$$0(26);
        }
        if (globalPackages == null) {
            NodePackageDescriptor.$$$reportNull$$$0(27);
        }
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(28);
        }
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(29);
        }
        if (packageProducer == null) {
            NodePackageDescriptor.$$$reportNull$$$0(30);
        }
        ArrayList modules = new ArrayList();
        if (contextFileOrDirectory != null) {
            NodeModuleSearchUtil.findModulesWithName(modules, packageName, contextFileOrDirectory, null);
        }
        if (!project.isDefault()) {
            NodeModuleSearchUtil.findModulesByNameInContentRoots(modules, packageName, project);
            Set<VirtualFile> packageJsonFiles = PackageJsonFileManager.getInstance(project).getValidPackageJsonFiles();
            HashSet packageJsonWithInheritedDependency = new HashSet();
            for (VirtualFile virtualFile : packageJsonFiles) {
                VirtualFile parentPackageJson;
                VirtualFile nodeModulesDir;
                PackageJsonData data = PackageJsonData.getOrCreate(virtualFile);
                if (!NodePackageDescriptor.isPackageAndDependencyDeclared(data, packageName, dependencyName) || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(virtualFile)) == null) continue;
                int countBefore = modules.size();
                NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, packageName);
                if (modules.size() != countBefore) continue;
                VirtualFile parent = virtualFile.getParent();
                if (parent != null) {
                    parent = parent.getParent();
                }
                if (parent == null || (parentPackageJson = PackageJsonUtil.findUpPackageJson(parent)) == null) continue;
                packageJsonWithInheritedDependency.add(parentPackageJson);
            }
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            for (CompletionModuleInfo module : modules) {
                VirtualFile dir = module.getVirtualFile();
                if (dir == null || !dir.isDirectory()) continue;
                boolean ok = false;
                VirtualFile packageJson = null;
                if (directDependenciesInsideProject && JSLibraryUtil.getContentRootForFile(fileIndex, dir) != null) {
                    VirtualFile nodeModulesDir = NodePackageDescriptor.findNodeModulesByPackageDir(dir);
                    packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir);
                    if (packageJson != null) {
                        PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
                        ok = NodePackageDescriptor.isPackageAndDependencyDeclared(data, packageName, dependencyName) || packageJsonWithInheritedDependency.contains(packageJson);
                    }
                } else {
                    ok = NodePackageDescriptor.hasSiblingPackageInstalled(dir, dependencyName);
                }
                if (!ok) continue;
                NodePackage pkg = packageProducer.create(dir.getPath());
                packages.add(new NodePackageAndPackageJson(pkg, packageJson));
            }
        }
        ArrayList globalModules = new ArrayList();
        NodeModuleSearchUtil.findGloballyInstalledModules(globalModules, packageName, interpreter);
        for (CompletionModuleInfo module : globalModules) {
            VirtualFile virtualFile = module.getVirtualFile();
            if (virtualFile == null || !virtualFile.isDirectory() || !NodePackageDescriptor.hasSiblingPackageInstalled(virtualFile, dependencyName)) continue;
            NodePackage pkg = packageProducer.create(virtualFile.getPath());
            globalPackages.add(pkg);
        }
        if (!directDependenciesInsideProject && "yarn".equals(packageName)) {
            if (SystemInfo.isWindows) {
                NodePackageDescriptor.tryAdd(globalPackages, new File("C:\\Program Files (x86)\\Yarn"), packageProducer);
                NodePackageDescriptor.tryAdd(globalPackages, new File("C:\\Program Files\\Yarn"), packageProducer);
            } else {
                NodePackageDescriptor.tryAdd(globalPackages, new File("/usr/share/yarn"), packageProducer);
                NodePackageDescriptor.tryAdd(globalPackages, new File("/opt/local/libexec/yarn"), packageProducer);
                File cellarYarnDir = NodePackageDescriptor.findCellarYarnDir();
                if (cellarYarnDir != null) {
                    File[] versions;
                    for (File version : versions = (File[])ObjectUtils.notNull((Object)cellarYarnDir.listFiles(), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY)) {
                        if (NodePackageDescriptor.tryAdd(globalPackages, new File(version, "libexec"), packageProducer)) continue;
                        NodePackageDescriptor.tryAdd(globalPackages, new File(version, "libexec/lib/node_modules/yarn"), packageProducer);
                    }
                }
            }
        }
    }

    private static boolean isPackageAndDependencyDeclared(@NotNull PackageJsonData data, @NotNull String packageName, @Nullable String dependencyName) {
        if (data == null) {
            NodePackageDescriptor.$$$reportNull$$$0(31);
        }
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(32);
        }
        return data.isDependencyOfAnyType(packageName) && (dependencyName == null || data.isDependencyOfAnyType(dependencyName));
    }

    private static boolean hasSiblingPackageInstalled(@NotNull VirtualFile packageDir, @Nullable String siblingPackageName) {
        if (packageDir == null) {
            NodePackageDescriptor.$$$reportNull$$$0(33);
        }
        if (siblingPackageName == null) {
            return true;
        }
        VirtualFile nodeModulesDir = NodePackageDescriptor.findNodeModulesByPackageDir(packageDir);
        return nodeModulesDir != null && nodeModulesDir.findFileByRelativePath(siblingPackageName) != null;
    }

    @Nullable
    private static VirtualFile findNodeModulesByPackageDir(@NotNull VirtualFile dir) {
        VirtualFile parent;
        if (dir == null) {
            NodePackageDescriptor.$$$reportNull$$$0(34);
        }
        if ((parent = dir.getParent()) == null) {
            return null;
        }
        CharSequence parentName = parent.getNameSequence();
        if (parent.isDirectory() && StringUtil.equals((CharSequence)"node_modules", (CharSequence)dir.getNameSequence())) {
            return parent;
        }
        if (NodeModuleSearchUtil.isScopeDirName(parentName)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private static boolean tryAdd(@NotNull Set<NodePackage> packages, @NotNull File packageDir, @NotNull NodePackageProducer packageProducer) {
        File packageJson;
        if (packages == null) {
            NodePackageDescriptor.$$$reportNull$$$0(35);
        }
        if (packageDir == null) {
            NodePackageDescriptor.$$$reportNull$$$0(36);
        }
        if (packageProducer == null) {
            NodePackageDescriptor.$$$reportNull$$$0(37);
        }
        if (packageDir.isDirectory() && (packageJson = new File(packageDir, "package.json")).isFile()) {
            packages.add(packageProducer.create(packageDir.getAbsolutePath()));
            return true;
        }
        return false;
    }

    private static File findCellarYarnDir() {
        File yarn;
        File root;
        File bin;
        File yarnExe = PathEnvironmentVariableUtil.findInPath((String)"yarn");
        if (yarnExe != null && (bin = yarnExe.getParentFile()) != null && bin.getName().equals("bin") && (root = bin.getParentFile()) != null && (yarn = new File(root, "Cellar/yarn")).isDirectory()) {
            return yarn;
        }
        File yarn2 = new File(SystemProperties.getUserHome(), ".linuxbrew/Cellar/yarn");
        if (yarn2.isDirectory()) {
            return yarn2;
        }
        yarn2 = new File("/usr/local/Cellar/yarn");
        if (yarn2.isDirectory()) {
            return yarn2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyByPackageMap";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalPackages";
                break;
            }
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageProducer";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageRef";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "dereferenceIfProjectRef";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstDirectDependencyPackage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "listPackageRefs";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "listAvailable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyByPackageName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPackage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPackageRef";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceIfProjectRef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFirstDirectDependencyPackage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "listPackageRefs";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "listAvailable";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isPackageAndDependencyDeclared";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasSiblingPackageInstalled";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findNodeModulesByPackageDir";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "tryAdd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodePackageAndPackageJson {
        private final NodePackage myPackage;
        private final VirtualFile myPackageJson;

        private NodePackageAndPackageJson(@NotNull NodePackage pkg, @Nullable VirtualFile packageJson) {
            if (pkg == null) {
                NodePackageAndPackageJson.$$$reportNull$$$0(0);
            }
            this.myPackage = pkg;
            this.myPackageJson = packageJson;
        }

        @NotNull
        private NodePackage getPackage() {
            NodePackage nodePackage = this.myPackage;
            if (nodePackage == null) {
                NodePackageAndPackageJson.$$$reportNull$$$0(1);
            }
            return nodePackage;
        }

        @Nullable
        private VirtualFile getPackageJson() {
            return this.myPackageJson;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodePackageAndPackageJson json = (NodePackageAndPackageJson)o;
            return this.myPackage.equals(json.myPackage);
        }

        public int hashCode() {
            return this.myPackage.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pkg";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor$NodePackageAndPackageJson";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor$NodePackageAndPackageJson";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface NodePackageProducer {
        @NotNull
        public NodePackage create(@NotNull String var1);
    }
}

