/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packages.NodePackageInfo;
import com.intellij.javascript.nodejs.packages.NodePackageInfoException;
import com.intellij.javascript.nodejs.settings.NodeInstalledPackage;
import com.intellij.javascript.nodejs.settings.NodeInstalledPackagesProvider;
import com.intellij.javascript.nodejs.settings.NodePackageInfoManager;
import com.intellij.javascript.nodejs.settings.NodePackageListProvider;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageManagementService
extends PackageManagementServiceEx {
    private static final Logger LOG = Logger.getInstance(NodePackageManagementService.class);
    private final Project myProject;
    private final NodeJsInterpreter myInterpreter;
    private final NodePackageInfoManager myManager;

    public NodePackageManagementService(@NotNull Project project, @NotNull NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackageManagementService.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            NodePackageManagementService.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myInterpreter = interpreter;
        this.myManager = new NodePackageInfoManager(project, interpreter);
    }

    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            NodePackageManagementService.$$$reportNull$$$0(2);
        }
        if (version2 == null) {
            NodePackageManagementService.$$$reportNull$$$0(3);
        }
        return NodePackageVersionUtil.comparePackageVersions(version1, version2);
    }

    public List<RepoPackage> getAllPackages() throws IOException {
        List<String> names = NodePackageListProvider.getInstance().listAllRemotePackageNames();
        return ContainerUtil.map(names, name -> new RepoPackage(name, null, null));
    }

    public List<RepoPackage> reloadAllPackages() throws IOException {
        return this.getAllPackages();
    }

    public Collection<InstalledPackage> getInstalledPackages() {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        NodeInstalledPackagesProvider provider2 = NodeInstalledPackagesProvider.getInstance();
        VirtualFile dir = this.myProject.getBaseDir();
        File ioDir = dir != null && dir.isValid() && dir.isDirectory() ? VfsUtilCore.virtualToIoFile((VirtualFile)dir) : null;
        Collection<NodeInstalledPackage> nodePackages = provider2.listInstalledPackages(ioDir, NodeJsLocalInterpreter.tryCast(this.myInterpreter));
        NodeInstalledPackage[] array = nodePackages.toArray(new NodeInstalledPackage[0]);
        Arrays.sort(array, (p1, p2) -> {
            if (p1.isGlobal() != p2.isGlobal()) {
                return p1.isGlobal() ? 1 : -1;
            }
            return p1.getName().compareTo(p2.getName());
        });
        return Arrays.asList(array);
    }

    public void installPackage(RepoPackage repoPackage, @Nullable String version, boolean forceUpgrade, @Nullable String extraOptions, PackageManagementService.Listener listener2, boolean installToUser) {
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new PackageInstaller(this.myProject, this.myInterpreter, repoPackage.getName(), version, VfsUtilCore.virtualToIoFile((VirtualFile)baseDir), listener2, extraOptions));
    }

    public void installPackage(RepoPackage repoPackage, @Nullable String version, @Nullable String extraOptions, PackageManagementService.Listener listener2, @NotNull File workingDir) {
        if (workingDir == null) {
            NodePackageManagementService.$$$reportNull$$$0(4);
        }
        ProgressManager.getInstance().run((Task)new PackageInstaller(this.myProject, this.myInterpreter, repoPackage.getName(), version, workingDir, listener2, extraOptions));
    }

    public void uninstallPackages(List<InstalledPackage> installedPackages, PackageManagementService.Listener listener2) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (InstalledPackage installedPackage : installedPackages) {
                if (!(installedPackage instanceof NodeInstalledPackage)) continue;
                this.uninstallPackage((NodeInstalledPackage)installedPackage, listener2);
            }
        });
    }

    private void uninstallPackage(@NotNull NodeInstalledPackage installedPackage, @NotNull PackageManagementService.Listener listener2) {
        if (installedPackage == null) {
            NodePackageManagementService.$$$reportNull$$$0(5);
        }
        if (listener2 == null) {
            NodePackageManagementService.$$$reportNull$$$0(6);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (installedPackage.isGlobal()) {
            args.add("-g");
        }
        args.add(installedPackage.getName());
        this.runNpmCommand(installedPackage.getName(), installedPackage, NpmCommand.UNINSTALL, args, listener2);
    }

    public void fetchPackageVersions(String packageName, final CatchingConsumer<List<String>, Exception> consumer) {
        this.myManager.fetchPackageInfo(new NodePackageInfoManager.PackageInfoConsumer(packageName){

            @Override
            public void onPackageInfo(@Nullable NodePackageInfo packageInfo) {
                if (packageInfo != null) {
                    consumer.consume(packageInfo.getVersions());
                }
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                consumer.consume((Throwable)e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/nodejs/settings/NodePackageManagementService$1", "onException"));
            }
        });
    }

    public void fetchPackageDetails(String packageName, final CatchingConsumer<String, Exception> consumer) {
        this.myManager.fetchPackageInfo(new NodePackageInfoManager.PackageInfoConsumer(packageName){

            @Override
            public void onPackageInfo(@Nullable NodePackageInfo packageInfo) {
                if (packageInfo != null) {
                    consumer.consume((Object)packageInfo.formatHtmlDescription());
                }
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e instanceof NodePackageInfoException) {
                    NodePackageInfoException infoException = (NodePackageInfoException)e;
                    consumer.consume((Object)infoException.formatHtmlDescription());
                }
                consumer.consume((Throwable)e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/nodejs/settings/NodePackageManagementService$2", "onException"));
            }
        });
    }

    public void updatePackage(@NotNull InstalledPackage installedPackage, @Nullable String version, @NotNull PackageManagementService.Listener listener2) {
        NodeInstalledPackage pkg;
        if (installedPackage == null) {
            NodePackageManagementService.$$$reportNull$$$0(7);
        }
        if (listener2 == null) {
            NodePackageManagementService.$$$reportNull$$$0(8);
        }
        if ((pkg = (NodeInstalledPackage)((Object)ObjectUtils.tryCast((Object)installedPackage, NodeInstalledPackage.class))) == null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{pkg.getName() + (version != null ? "@" + version : "")});
            this.runNpmCommand(pkg.getName(), pkg, NpmCommand.ADD, args, listener2);
        });
    }

    public void fetchLatestVersion(@NotNull InstalledPackage pkg, final @NotNull CatchingConsumer<String, Exception> consumer) {
        if (pkg == null) {
            NodePackageManagementService.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            NodePackageManagementService.$$$reportNull$$$0(10);
        }
        this.myManager.fetchPackageInfo(new NodePackageInfoManager.PackageInfoConsumer(pkg.getName(), false){

            @Override
            public void onPackageInfo(@Nullable NodePackageInfo packageInfo) {
                if (packageInfo != null) {
                    consumer.consume((Object)packageInfo.getLatestVersion());
                } else {
                    consumer.consume((Object)null);
                }
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                consumer.consume((Throwable)e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/nodejs/settings/NodePackageManagementService$3", "onException"));
            }
        });
    }

    @Nullable
    private File guessWorkingDir(@Nullable NodeInstalledPackage pkg) {
        VirtualFile baseDir;
        if (pkg != null) {
            File workingDir = pkg.getSourceRootDir().getParentFile();
            if (workingDir != null && workingDir.getName().equals("node_modules")) {
                workingDir = workingDir.getParentFile();
            }
            if (workingDir != null) {
                return workingDir;
            }
        }
        return (baseDir = this.myProject.getBaseDir()) != null ? VfsUtilCore.virtualToIoFile((VirtualFile)baseDir) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNpmCommand(@NotNull String packageName, @Nullable NodeInstalledPackage pkg, @NotNull NpmCommand command, @NotNull List<String> args, @NotNull PackageManagementService.Listener listener2) {
        File workingDir;
        if (packageName == null) {
            NodePackageManagementService.$$$reportNull$$$0(11);
        }
        if (command == null) {
            NodePackageManagementService.$$$reportNull$$$0(12);
        }
        if (args == null) {
            NodePackageManagementService.$$$reportNull$$$0(13);
        }
        if (listener2 == null) {
            NodePackageManagementService.$$$reportNull$$$0(14);
        }
        if ((workingDir = this.guessWorkingDir(pkg)) == null) {
            String message = "Cannot determine working directory for " + packageName + ": " + args;
            LOG.warn(message);
            ApplicationManager.getApplication().invokeLater(() -> listener2.operationFinished(packageName, PackageManagementService.ErrorDescription.fromMessage((String)message)), ModalityState.any());
            return;
        }
        GeneralCommandLine commandLine = (GeneralCommandLine)PackageInstaller.computeAndReportIfFailed(listener2, packageName, () -> NpmUtil.createNpmCommandLine(this.myProject, workingDir, this.myInterpreter, command, args));
        if (commandLine == null) {
            return;
        }
        Ref errorMessageRef = Ref.create();
        try {
            ApplicationManager.getApplication().invokeLater(() -> listener2.operationStarted(packageName), ModalityState.any());
            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = processHandler.runProcess();
            if (output.getExitCode() != 0) {
                errorMessageRef.set((Object)NodeCommandLineUtil.formatErrorMessage(commandLine, output));
            }
        }
        catch (ExecutionException e) {
            errorMessageRef.set((Object)e.getMessage());
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> {
                listener2.operationFinished(packageName, PackageManagementService.ErrorDescription.fromMessage((String)((String)errorMessageRef.get())));
                LocalFileSystem.getInstance().refresh(true);
            }, ModalityState.any());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackage";
                break;
            }
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodePackageManagementService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compareVersions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "installPackage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "uninstallPackage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePackage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchLatestVersion";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "runNpmCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

