/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonInstallTypesIntention
extends BaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"package.json.install.types.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        String typesPackageName;
        JsonStringLiteral literal;
        if (project == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(1);
        }
        if ((literal = PackageJsonInstallTypesIntention.getModuleNameLiteral(editor, file2)) == null) {
            return false;
        }
        String packageName = literal.getValue();
        if (packageName.startsWith("@types")) {
            return false;
        }
        VirtualFile packageJson = file2.getVirtualFile();
        PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
        if (data.isDependencyOfAnyType(typesPackageName = "@types/" + packageName)) {
            return false;
        }
        VirtualFile nodeModules = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
        if (nodeModules == null) {
            return false;
        }
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(literal.getProject(), packageJson);
        InstalledPackageVersion moduleInfo = finder.findInstalledPackage(packageName);
        if (moduleInfo == null) {
            return false;
        }
        VirtualFile modulePackageJson = moduleInfo.getPackageJson();
        if (modulePackageJson == null) {
            return false;
        }
        PackageJsonData moduleData = PackageJsonData.getOrCreate(modulePackageJson);
        if (moduleData.hasTypings() || moduleInfo.getPackageDir().findChild("index.d.ts") != null) {
            return false;
        }
        this.setText(JSBundle.message((String)"node.js.quickfix.install.node.module.text", (Object[])new Object[]{typesPackageName}));
        return true;
    }

    @Nullable
    private static JsonStringLiteral getModuleNameLiteral(@Nullable Editor editor, @Nullable PsiFile file2) {
        if (file2 == null || !PackageJsonUtil.isPackageJsonFile(file2) || editor == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return null;
        }
        if (element instanceof LeafPsiElement) {
            element = element.getParent();
        }
        if (!(element instanceof JsonStringLiteral)) {
            return null;
        }
        JsonProperty property = (JsonProperty)ObjectUtils.tryCast((Object)element.getParent(), JsonProperty.class);
        if (property == null) {
            return null;
        }
        if (property.getNameElement() != element) {
            return null;
        }
        if (!PackageJsonUtil.isPackageDependencyProperty(property)) {
            return null;
        }
        return (JsonStringLiteral)element;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(2);
        }
        final JsonStringLiteral literal = PackageJsonInstallTypesIntention.getModuleNameLiteral(editor, file2);
        FileDocumentManager.getInstance().saveAllDocuments();
        if (literal == null) {
            return;
        }
        String value = literal.getValue();
        final String packageName = "@types/" + value;
        final NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        if (interpreter == null) {
            return;
        }
        final VirtualFile packageJson = file2.getVirtualFile();
        final VirtualFile parent = packageJson.getParent();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Install " + packageName, true){

            public void run(@NotNull ProgressIndicator indicator) {
                AvailablePackageVersions versions;
                List<SemVer> allVersions;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((allVersions = (versions = NpmRegistryService.getInstance().getCachedOrFetchPackageVersions(indicator, packageName)).getVersions()).isEmpty()) {
                    return;
                }
                String expectedVersion = (String)ReadAction.compute(() -> PackageJsonInstallTypesIntention.getVersionUnderReadAction(literal, allVersions));
                String extraOptions = InstallNodeModuleQuickFix.buildExtraOptions(project, true);
                PackageManagementService.Listener listener2 = InstallNodeModuleQuickFix.createListener(project, packageJson, packageName);
                new PackageInstaller(project, interpreter, packageName, expectedVersion, new File(parent.getPath()), listener2, extraOptions).run(indicator);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{packageJson});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonInstallTypesIntention$1", "run"));
            }
        });
    }

    @Nullable
    private static String getVersionUnderReadAction(@NotNull JsonStringLiteral literal, @NotNull List<SemVer> allVersions) {
        SemVer ver;
        JsonProperty property;
        if (literal == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(3);
        }
        if (allVersions == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(4);
        }
        if ((property = (JsonProperty)ObjectUtils.tryCast((Object)literal.getParent(), JsonProperty.class)) == null) {
            return null;
        }
        JsonStringLiteral value = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
        if (value == null) {
            return null;
        }
        String version = value.getValue();
        if (version.isEmpty()) {
            return null;
        }
        if (!StringUtil.isDecimalDigit((char)version.charAt(0))) {
            version = version.substring(1);
        }
        if ((ver = SemVer.parseFromText((String)version)) == null) {
            return null;
        }
        SemVer matchedVersion = PackageJsonInstallTypesIntention.getMatchedVersion(ver, allVersions);
        return matchedVersion == null ? null : matchedVersion.toString();
    }

    @Nullable
    private static SemVer getMatchedVersion(@NotNull SemVer toMatch, @NotNull List<SemVer> allVersions) {
        if (toMatch == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(5);
        }
        if (allVersions == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(6);
        }
        SemVer minorMatch = null;
        SemVer majorMatch = null;
        int toMatchMinor = toMatch.getMinor();
        int toMatchMajor = toMatch.getMajor();
        for (SemVer version : allVersions) {
            if (version.equals((Object)toMatch)) {
                return toMatch;
            }
            if (toMatchMajor != version.getMajor()) continue;
            if (majorMatch == null) {
                majorMatch = version;
            }
            if (minorMatch != null || toMatchMinor != version.getMinor()) continue;
            minorMatch = version;
        }
        if (minorMatch != null) {
            return minorMatch;
        }
        if (majorMatch != null) {
            return majorMatch;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonInstallTypesIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allVersions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonInstallTypesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVersionUnderReadAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

