/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodePackage;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.util.DefaultNodePackageRefResolver;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmUtil {
    public static final String NPM_PACKAGE_NAME = "npm";
    public static final String YARN_PACKAGE_NAME = "yarn";
    public static final String YARN_LOCK_FILENAME = "yarn.lock";
    public static final String PACKAGE_MANAGER_LABEL = "Package &manager:";
    public static final String PROJECT_PACKAGE_MANAGER_REFERENCE_NAME = "Project";
    public static final NodePackageDescriptor DESCRIPTOR = new NpmPackageDescriptor(false);
    private static final String NPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "npm-cli.js";
    private static final String YARN_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "yarn.js";
    private static final NodePackageRefResolver RESOLVER = new DefaultNodePackageRefResolver(null, DESCRIPTOR, null);

    private NpmUtil() {
    }

    @NotNull
    public static NodePackageRef createProjectPackageManagerPackageRef() {
        NodePackageRef nodePackageRef = NodePackageRef.create(PROJECT_PACKAGE_MANAGER_REFERENCE_NAME);
        if (nodePackageRef == null) {
            NpmUtil.$$$reportNull$$$0(0);
        }
        return nodePackageRef;
    }

    public static boolean isProjectPackageManagerPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(1);
        }
        return PROJECT_PACKAGE_MANAGER_REFERENCE_NAME.equals(packageRef.getReferenceName());
    }

    @NotNull
    public static NodePackageField createPackageManagerPackageField(@NotNull NodeJsInterpreterField interpreterField, boolean projectField) {
        if (interpreterField == null) {
            NpmUtil.$$$reportNull$$$0(2);
        }
        NodePackageField nodePackageField = new NodePackageField(interpreterField, new NpmPackageDescriptor(projectField), null);
        if (nodePackageField == null) {
            NpmUtil.$$$reportNull$$$0(3);
        }
        return nodePackageField;
    }

    @NotNull
    public static String getValidNpmCliJsFilePath(@NotNull NodePackage packageManagerPkg) throws ExecutionException {
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(4);
        }
        if (packageManagerPkg instanceof WslNodePackage) {
            if (NpmUtil.isYarnAlikePackage(packageManagerPkg)) {
                String string = packageManagerPkg.getSystemIndependentPath() + "/" + FileUtil.toSystemIndependentName((String)YARN_CLI_JS_RELATIVE_PATH);
                if (string == null) {
                    NpmUtil.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = packageManagerPkg.getSystemIndependentPath() + "/" + FileUtil.toSystemIndependentName((String)NPM_CLI_JS_RELATIVE_PATH);
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (packageManagerPkg.isEmptyPath()) {
            throw new ExecutionException("Please specify npm or yarn package");
        }
        if (!packageManagerPkg.isValid()) {
            throw new ExecutionException("Please correct path to npm or yarn package: no such directory \"" + packageManagerPkg.getSystemDependentPath() + "\"");
        }
        String string = NpmUtil.findBinCliFile(packageManagerPkg);
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean isYarnAlikePackageRef(@NotNull NodePackageRef packageManagerPkgRef) {
        NodePackage pkg;
        if (packageManagerPkgRef == null) {
            NpmUtil.$$$reportNull$$$0(8);
        }
        if ((pkg = packageManagerPkgRef.getConstantPackage()) != null) {
            return NpmUtil.isYarnAlikePackage(pkg);
        }
        return StringUtil.containsIgnoreCase((String)Objects.requireNonNull(packageManagerPkgRef.getReferenceName()), (String)YARN_PACKAGE_NAME);
    }

    public static boolean isYarnAlikePackage(@NotNull NodePackage packageManagerPkg) {
        String packageName;
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(9);
        }
        if (StringUtil.containsIgnoreCase((String)(packageName = PathUtil.getFileName((String)packageManagerPkg.getSystemIndependentPath())), (String)YARN_PACKAGE_NAME)) {
            return true;
        }
        return "libexec".equals(packageName) && packageManagerPkg.getSystemIndependentPath().contains(YARN_PACKAGE_NAME);
    }

    @NotNull
    private static String findBinCliFile(@NotNull NodePackage pkg) throws ExecutionException {
        if (pkg == null) {
            NpmUtil.$$$reportNull$$$0(10);
        }
        String failoverBinRelativePath = NpmUtil.isYarnAlikePackage(pkg) ? YARN_CLI_JS_RELATIVE_PATH : NPM_CLI_JS_RELATIVE_PATH;
        File binFile = pkg.findBinFile(pkg.getName(), failoverBinRelativePath);
        if (binFile == null) {
            throw new ExecutionException("Please specify npm or yarn package: cannot find binary file inside '" + pkg.getSystemDependentPath() + "' directory");
        }
        String string = binFile.getAbsolutePath();
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static NodePackage resolveRef(@NotNull NodePackageRef ref, @NotNull Project project, @Nullable NodeJsInterpreter interpreter) {
        if (ref == null) {
            NpmUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            NpmUtil.$$$reportNull$$$0(13);
        }
        return RESOLVER.resolve(DESCRIPTOR.dereferenceIfProjectRef(project, ref), interpreter);
    }

    @NotNull
    public static NodePackage resolvePackageRefOrThrow(@NotNull NodePackageRef packageRef, @Nullable Project project, @Nullable NodeJsInterpreter interpreter) throws ExecutionException {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(14);
        }
        if (project != null) {
            packageRef = DESCRIPTOR.dereferenceIfProjectRef(project, packageRef);
        } else if (NpmUtil.isProjectPackageManagerPackageRef(packageRef)) {
            throw new ExecutionException("Project npm package cannot be referenced here");
        }
        if (StringUtil.isEmptyOrSpaces((String)packageRef.getIdentifier())) {
            throw new ExecutionException("Unspecified package manager");
        }
        NodePackage npmPkg = RESOLVER.resolve(packageRef, interpreter);
        if (npmPkg == null) {
            throw new ExecutionException("Cannot resolve '" + packageRef.getIdentifier() + "' package manager");
        }
        NodePackage nodePackage = npmPkg;
        if (nodePackage == null) {
            NpmUtil.$$$reportNull$$$0(15);
        }
        return nodePackage;
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable Project project, @Nullable File workingDir, @NotNull NodeJsInterpreter interpreter, @NotNull NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        NodePackage pkg;
        if (interpreter == null) {
            NpmUtil.$$$reportNull$$$0(16);
        }
        if (command == null) {
            NpmUtil.$$$reportNull$$$0(17);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(18);
        }
        if (project != null) {
            pkg = NpmManager.getInstance(project).getPackageOrThrow(interpreter);
        } else {
            pkg = interpreter instanceof NodeJsLocalInterpreter ? new NodePackage(((NodeJsLocalInterpreter)interpreter).getNpmPackageDir()) : (interpreter instanceof WslNodeInterpreter ? WslNodePackage.resolvePackageRefAsWsl((WslNodeInterpreter)interpreter, NodePackageRef.create(NPM_PACKAGE_NAME)) : null);
            if (pkg == null) {
                throw new ExecutionException("No bundled npm detected for " + interpreter.getReferenceName());
            }
        }
        GeneralCommandLine generalCommandLine = NpmUtil.createNpmCommandLine(workingDir, interpreter, pkg, command, arguments);
        if (generalCommandLine == null) {
            NpmUtil.$$$reportNull$$$0(19);
        }
        return generalCommandLine;
    }

    @Deprecated
    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable Project project, @Nullable File workingDir, @NotNull NodeJsLocalInterpreter interpreter, @NotNull NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (interpreter == null) {
            NpmUtil.$$$reportNull$$$0(20);
        }
        if (command == null) {
            NpmUtil.$$$reportNull$$$0(21);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(22);
        }
        GeneralCommandLine generalCommandLine = NpmUtil.createNpmCommandLine(project, workingDir, (NodeJsInterpreter)interpreter, command, arguments);
        if (generalCommandLine == null) {
            NpmUtil.$$$reportNull$$$0(23);
        }
        return generalCommandLine;
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable File workingDir, @NotNull NodeJsInterpreter interpreter, @NotNull NodePackage npmPackage, @NotNull NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (interpreter == null) {
            NpmUtil.$$$reportNull$$$0(24);
        }
        if (npmPackage == null) {
            NpmUtil.$$$reportNull$$$0(25);
        }
        if (command == null) {
            NpmUtil.$$$reportNull$$$0(26);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(27);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        String cliJsFilePath = NpmUtil.getValidNpmCliJsFilePath(npmPackage);
        commandLine.addParameter(cliJsFilePath);
        boolean yarn = NpmUtil.isYarnAlikePackage(npmPackage);
        commandLine.addParameter(command.getCliOption(yarn));
        commandLine.addParameters(arguments);
        NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            NpmUtil.$$$reportNull$$$0(28);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmUtil";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkg";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkgRef";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 17: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 18: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectPackageManagerPackageRef";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageManagerPackageField";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidNpmCliJsFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinCliFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePackageRefOrThrow";
                break;
            }
            case 19: 
            case 23: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createNpmCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isProjectPackageManagerPackageRef";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPackageManagerPackageField";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValidNpmCliJsFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackageRef";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findBinCliFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveRef";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolvePackageRefOrThrow";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createNpmCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NpmPackageDescriptor
    extends NodePackageDescriptor {
        private final boolean myProjectField;

        NpmPackageDescriptor(boolean projectField) {
            super(NpmUtil.NPM_PACKAGE_NAME, NpmUtil.YARN_PACKAGE_NAME);
            this.myProjectField = projectField;
        }

        @Override
        @NotNull
        public NodePackageRef createPackageRef(@NotNull String text) {
            if (text == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(0);
            }
            if (this.getPackageNames().contains(text) || NpmUtil.PROJECT_PACKAGE_MANAGER_REFERENCE_NAME.equals(text)) {
                NodePackageRef nodePackageRef = NodePackageRef.create(text);
                if (nodePackageRef == null) {
                    NpmPackageDescriptor.$$$reportNull$$$0(1);
                }
                return nodePackageRef;
            }
            NodePackageRef nodePackageRef = super.createPackageRef(text);
            if (nodePackageRef == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(2);
            }
            return nodePackageRef;
        }

        @Override
        @NotNull
        public NodePackageRef dereferenceIfProjectRef(@NotNull Project project, @NotNull NodePackageRef ref) {
            if (project == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(3);
            }
            if (ref == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(4);
            }
            if (NpmUtil.isProjectPackageManagerPackageRef(ref)) {
                NodePackageRef nodePackageRef = NpmManager.getInstance(project).getPackageRef();
                if (nodePackageRef == null) {
                    NpmPackageDescriptor.$$$reportNull$$$0(5);
                }
                return nodePackageRef;
            }
            NodePackageRef nodePackageRef = ref;
            if (nodePackageRef == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(6);
            }
            return nodePackageRef;
        }

        @Override
        @NotNull
        public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
            if (project == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(7);
            }
            ArrayList<NodePackageRef> result2 = new ArrayList<NodePackageRef>();
            if (!this.myProjectField) {
                result2.add(NpmUtil.createProjectPackageManagerPackageRef());
            }
            for (String pkgName : this.getPackageNames()) {
                result2.add(NodePackageRef.create(pkgName));
            }
            if (interpreter instanceof NodeJsLocalInterpreter) {
                String globalNodeModules;
                NodeJsLocalInterpreter localInterpreter = (NodeJsLocalInterpreter)interpreter;
                String bundledNodeModules = FileUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)localInterpreter.getNpmPackageDir()));
                VirtualFile dir = localInterpreter.getGlobalNodeModulesVirtualDir();
                String string = globalNodeModules = dir != null ? dir.getPath() : null;
                if (bundledNodeModules.equals(globalNodeModules)) {
                    interpreter = null;
                }
            }
            List<NodePackageRef> refs = super.listPackageRefs(project, interpreter, contextFileOrDirectory);
            result2.addAll(refs);
            ArrayList<NodePackageRef> arrayList = result2;
            if (arrayList == null) {
                NpmPackageDescriptor.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmUtil$NpmPackageDescriptor";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmUtil$NpmPackageDescriptor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPackageRef";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "dereferenceIfProjectRef";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listPackageRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPackageRef";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "dereferenceIfProjectRef";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "listPackageRefs";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

