/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeTypingsDownloader {
    private static final Logger LOG = Logger.getInstance(NodeTypingsDownloader.class);
    private static final String NODE_TYPINGS = "@types/node";
    private final NodeJsInterpreter myInterpreter;
    private final File myTypingsDir;
    private final NodePackage myNpmPackage;

    public NodeTypingsDownloader(@NotNull NodeJsInterpreter interpreter, @Nullable NodePackage npmPackage, @NotNull File typingsDir) {
        if (interpreter == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(0);
        }
        if (typingsDir == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(1);
        }
        this.myInterpreter = interpreter;
        this.myNpmPackage = npmPackage;
        this.myTypingsDir = typingsDir;
    }

    @NotNull
    public Future<Object> download(@Nullable ProgressIndicator progress) {
        FutureTask<Object> future = new FutureTask<Object>(() -> this.doDownload(progress));
        ApplicationManager.getApplication().executeOnPooledThread(future);
        FutureTask<Object> futureTask = future;
        if (futureTask == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(2);
        }
        return futureTask;
    }

    @NotNull
    private Object doDownload(@Nullable ProgressIndicator progress) throws ExecutionException {
        File file2;
        if (this.myNpmPackage == null) {
            throw new ExecutionException("Cannot find npm package");
        }
        ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{NODE_TYPINGS, "--ignore-scripts"});
        File nodeModulesDir = new File(this.myTypingsDir, "node_modules");
        FileUtil.createDirectory((File)nodeModulesDir);
        GeneralCommandLine commandLine = NpmUtil.createNpmCommandLine(this.myTypingsDir, this.myInterpreter, this.myNpmPackage, NpmCommand.ADD, (List<String>)args);
        KillableColoredProcessHandler handler = NodeCommandLineUtil.createKillableColoredProcessHandler(commandLine, false);
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)handler);
        ProcessOutput output = runner.runProcess(EmptyProgressIndicator.notNullize((ProgressIndicator)progress), (int)TimeUnit.SECONDS.toMillis(120L), true);
        if (output.getExitCode() != 0 || output.isTimeout()) {
            throw new ExecutionException("Cannot download @types/node: " + NodeTypingsDownloader.stringifyProcessOutput(commandLine, output));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Status of @types/node installation: " + NodeTypingsDownloader.stringifyProcessOutput(commandLine, output));
        }
        if ((file2 = new File(nodeModulesDir, NODE_TYPINGS)).isDirectory()) {
            Object object = new Object();
            if (object == null) {
                NodeTypingsDownloader.$$$reportNull$$$0(3);
            }
            return object;
        }
        throw new ExecutionException("Cannot find @types/node package: nonexistent " + file2.getAbsolutePath());
    }

    @NotNull
    private static String stringifyProcessOutput(@NotNull GeneralCommandLine commandLine, @NotNull ProcessOutput output) {
        if (commandLine == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(4);
        }
        if (output == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(5);
        }
        String string = commandLine + " finished with exit code " + output.getExitCode() + (output.isExitCodeSet() ? "" : " (unset)") + ", timed out: " + output.isTimeout() + ", cancelled: " + output.isCancelled() + ", stdout:" + output.getStdout() + ", stderr: " + output.getStderr();
        if (string == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingsDir";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeTypingsDownloader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeTypingsDownloader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "download";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doDownload";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyProcessOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "stringifyProcessOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

