/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.javascript.nodejs.library.core.NodeCoreModulesCatalog;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NodeCoreSourcesSnapshot {
    private static final Logger LOG = Logger.getInstance(NodeCoreSourcesSnapshot.class);
    private final VirtualFile myCoreModulesSrcDir;
    private final ImmutableMap<String, VirtualFile> myAllPathToFileMap;
    private final ImmutableSet<VirtualFile> myAllFiles;

    NodeCoreSourcesSnapshot(@NotNull VirtualFile coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(0);
        }
        this.myCoreModulesSrcDir = coreModulesSrcDir;
        Map pathToFileMap = (Map)ReadAction.compute(() -> NodeCoreSourcesSnapshot.buildPathToFileMap(coreModulesSrcDir));
        HashMap publicModules = new HashMap();
        for (Map.Entry entry : pathToFileMap.entrySet()) {
            String moduleName = FileUtilRt.getNameWithoutExtension((String)((String)entry.getKey()));
            if (!NodeCoreModulesCatalog.INSTANCE.isPublicCoreModule(moduleName)) continue;
            publicModules.put(moduleName, entry.getValue());
        }
        this.myAllPathToFileMap = ImmutableMap.copyOf((Map)pathToFileMap);
        this.myAllFiles = ImmutableSet.copyOf(pathToFileMap.values());
    }

    @NotNull
    VirtualFile getCoreModulesSrcDir() {
        VirtualFile virtualFile = this.myCoreModulesSrcDir;
        if (virtualFile == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    boolean isCoreModuleFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(2);
        }
        return this.myAllFiles.contains((Object)file2);
    }

    @Nullable
    public VirtualFile getFileByModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(3);
        }
        return (VirtualFile)this.myAllPathToFileMap.get((Object)moduleName);
    }

    private static Map<String, VirtualFile> buildPathToFileMap(final @NotNull VirtualFile coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(4);
        }
        if (!coreModulesSrcDir.isValid() || !coreModulesSrcDir.isDirectory()) {
            LOG.error(coreModulesSrcDir.getPath() + " isValid: " + coreModulesSrcDir.isValid() + ", isDirectory: " + coreModulesSrcDir.isDirectory());
            return Collections.emptyMap();
        }
        final HashMap<String, VirtualFile> pathToFile = new HashMap<String, VirtualFile>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)coreModulesSrcDir, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file2.isDirectory()) {
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)coreModulesSrcDir);
                    if (relativePath == null) {
                        LOG.error("Cannot find relative path: " + file2.getPath() + " relative to " + coreModulesSrcDir.getPath());
                    } else {
                        pathToFile.put(FileUtilRt.getNameWithoutExtension((String)relativePath), file2);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/core/NodeCoreSourcesSnapshot$1", "visitFile"));
            }
        });
        return pathToFile;
    }

    @NotNull
    Set<VirtualFile> getFilesToIndex() {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (Map.Entry entry : this.myAllPathToFileMap.entrySet()) {
            String moduleName = FileUtilRt.getNameWithoutExtension((String)((String)entry.getKey()));
            if (!NodeCoreModulesCatalog.INSTANCE.isIncludedCoreModule(moduleName)) continue;
            result2.add((VirtualFile)entry.getValue());
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreModulesSrcDir";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreSourcesSnapshot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSourcesSnapshot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreModulesSrcDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileByModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildPathToFileMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

