/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.download;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsDownloadService {
    private final ExecutorService myInstaller = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"NodeJsInstaller", (int)1);

    public void ensureInstalled(Project project, NodeJsInterpreter node, Consumer<NodeJsInterpreter> runWhenInstalled) {
        if (node instanceof NodeJsDownloadableInterpreter) {
            this.myInstaller.submit(() -> NodeJsDownloadService.install(project, (NodeJsDownloadableInterpreter)node, runWhenInstalled));
        } else {
            runWhenInstalled.accept(node);
        }
    }

    private static void install(Project project, final NodeJsDownloadableInterpreter node, final Consumer<NodeJsInterpreter> runWhenInstalled) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Downloading Node.js " + node, true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    String installDirectory = NodeJsDownloadService.getInstallDirectory(node);
                    if (!FileUtil.exists((String)installDirectory)) {
                        String filename = NodeJsDownloadService.constructFilename(node);
                        String url = NodeJsDownloadService.constructUrl((SemVer)node.getCachedVersion().get(), filename);
                        File tempFile = FileUtil.createTempFile((String)"", (String)"", (boolean)true);
                        DownloadUtil.downloadAtomically((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (String)url, (File)tempFile);
                        Decompressor.Zip decompressor = SystemInfo.isWindows ? new Decompressor.Zip(tempFile) : new Decompressor.Tar(tempFile);
                        decompressor.extract(new File(NodeJsDownloadService.getInstallDirectory()));
                    }
                    NodeJsLocalInterpreter interpreter = new NodeJsLocalInterpreter(installDirectory + (!SystemInfo.isWindows ? "/bin" : "") + "/node" + (SystemInfo.isWindows ? ".exe" : ""));
                    NodeJsLocalInterpreterType type = NodeJsLocalInterpreterType.getInstance();
                    ArrayList<NodeJsLocalInterpreter> interpreters = new ArrayList<NodeJsLocalInterpreter>(type.getInterpreters());
                    if (!interpreters.contains(interpreter)) {
                        interpreters.add(interpreter);
                        type.setInterpreters((List<NodeJsLocalInterpreter>)interpreters);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> runWhenInstalled.accept(interpreter));
                }
                catch (IOException e) {
                    Logger.getInstance(NodeJsDownloadService.class).error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$1", "run"));
            }
        });
    }

    @NotNull
    private static String constructFilename(NodeJsDownloadableInterpreter node) {
        Ref<SemVer> ref = node.getCachedVersion();
        SemVer version = (SemVer)ref.get();
        String os = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "darwin" : "linux");
        String bits = SystemInfo.is32Bit ? "x86" : "x64";
        String string = "node-v" + version + "-" + os + "-" + bits;
        if (string == null) {
            NodeJsDownloadService.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getInstallDirectory(NodeJsDownloadableInterpreter node) {
        String string = NodeJsDownloadService.getInstallDirectory() + NodeJsDownloadService.constructFilename(node);
        if (string == null) {
            NodeJsDownloadService.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getInstallDirectory() {
        String string = PathManager.getConfigPath() + "/node/";
        if (string == null) {
            NodeJsDownloadService.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getNpmInstallDirectory(@Nullable NodeJsDownloadableInterpreter interpreter) {
        String string = NodeJsDownloadService.getInstallDirectory(interpreter) + (SystemInfo.isWindows ? "" : "/lib") + "/node_modules/npm/";
        if (string == null) {
            NodeJsDownloadService.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String constructUrl(SemVer version, String filename) {
        String extension = SystemInfo.isWindows ? "zip" : "tar.gz";
        return "https://nodejs.org/dist/v" + version + "/" + filename + "." + extension;
    }

    public static NodeJsDownloadService getInstance() {
        return (NodeJsDownloadService)ServiceManager.getService(NodeJsDownloadService.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "constructFilename";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpmInstallDirectory";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

