/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefinedEnvironmentVariablesProvider {
    private final RunManager myRunManager;
    private volatile Map<String, String> myEnvironment;

    public DefinedEnvironmentVariablesProvider(@NotNull Project project, @NotNull RunManager runManager) {
        if (project == null) {
            DefinedEnvironmentVariablesProvider.$$$reportNull$$$0(0);
        }
        if (runManager == null) {
            DefinedEnvironmentVariablesProvider.$$$reportNull$$$0(1);
        }
        this.myRunManager = runManager;
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                DefinedEnvironmentVariablesProvider.this.onRunConfigurationChanged(settings);
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                DefinedEnvironmentVariablesProvider.this.onRunConfigurationChanged(settings);
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(2);
                }
                DefinedEnvironmentVariablesProvider.this.onRunConfigurationChanged(settings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/javascript/nodejs/execution/DefinedEnvironmentVariablesProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onRunConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            DefinedEnvironmentVariablesProvider.$$$reportNull$$$0(2);
        }
        if (DefinedEnvironmentVariablesProvider.getEnvironment(settings.getConfiguration()) != null) {
            this.myEnvironment = this.collectEnvironment();
        }
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        Map<String, String> envs = this.myEnvironment;
        if (envs == null) {
            this.myEnvironment = envs = this.collectEnvironment();
        }
        Map<String, String> map = envs;
        if (map == null) {
            DefinedEnvironmentVariablesProvider.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    private Map<String, String> collectEnvironment() {
        EnvMerger envMerger = new EnvMerger();
        for (RunConfiguration configuration : this.myRunManager.getAllConfigurationsList()) {
            Map<String, String> environment = DefinedEnvironmentVariablesProvider.getEnvironment(configuration);
            if (environment == null) continue;
            envMerger.addEnvsIfAbsent(environment);
        }
        envMerger.addEnvsIfAbsent(EnvironmentUtil.getEnvironmentMap());
        LinkedHashMap linkedHashMap = envMerger.myOrderedEnvs;
        if (linkedHashMap == null) {
            DefinedEnvironmentVariablesProvider.$$$reportNull$$$0(4);
        }
        return linkedHashMap;
    }

    @Nullable
    private static Map<String, String> getEnvironment(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            DefinedEnvironmentVariablesProvider.$$$reportNull$$$0(5);
        }
        if (configuration instanceof CommonProgramRunConfigurationParameters) {
            return ((CommonProgramRunConfigurationParameters)configuration).getEnvs();
        }
        if (configuration instanceof NpmRunConfiguration) {
            return ((NpmRunConfiguration)configuration).getRunSettings().getEnvData().getEnvs();
        }
        return null;
    }

    @NotNull
    public static DefinedEnvironmentVariablesProvider getInstance(@NotNull Project project) {
        if (project == null) {
            DefinedEnvironmentVariablesProvider.$$$reportNull$$$0(6);
        }
        DefinedEnvironmentVariablesProvider definedEnvironmentVariablesProvider = (DefinedEnvironmentVariablesProvider)ServiceManager.getService((Project)project, DefinedEnvironmentVariablesProvider.class);
        if (definedEnvironmentVariablesProvider == null) {
            DefinedEnvironmentVariablesProvider.$$$reportNull$$$0(7);
        }
        return definedEnvironmentVariablesProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/execution/DefinedEnvironmentVariablesProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/execution/DefinedEnvironmentVariablesProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectEnvironment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onRunConfigurationChanged";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnvMerger {
        private final Set<String> myEnvNames;
        private final LinkedHashMap<String, String> myOrderedEnvs = new LinkedHashMap();

        private EnvMerger() {
            this.myEnvNames = new THashSet((TObjectHashingStrategy)(SystemInfo.isWindows ? CaseInsensitiveStringHashingStrategy.INSTANCE : ContainerUtil.canonicalStrategy()));
        }

        private void addEnvsIfAbsent(@NotNull Map<String, String> envs) {
            if (envs == null) {
                EnvMerger.$$$reportNull$$$0(0);
            }
            for (Map.Entry<String, String> entry : envs.entrySet()) {
                if (!this.myEnvNames.add(entry.getKey())) continue;
                this.myOrderedEnvs.put(entry.getKey(), entry.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/javascript/nodejs/execution/DefinedEnvironmentVariablesProvider$EnvMerger", "addEnvsIfAbsent"));
        }
    }
}

