/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.compose.cli.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.DockerRuntimesCache;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ComposeDeploymentRuntime
extends ComposeApplicationRuntime {
    private static final Logger LOG = Logger.getInstance(ComposeDeploymentRuntime.class);
    private final Project myProject;
    private final DockerRuntimesCache myRuntimesCache;
    private final DeploymentLogManager myLogManager;
    private final File myWorkingDirectory;
    private final String myComposeProjectName;
    private NextDeployInfo myNextDeployInfo;
    private final LinkedHashSet<File> myMergedComposeFiles;
    private final Map<String, String> myMergedEnvironment;

    public ComposeDeploymentRuntime(@NotNull DockerRuntimesCache runtimesCache, @NotNull DeploymentTask<DockerDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager) throws ServerRuntimeException {
        if (runtimesCache == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(0);
        }
        if (task == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(1);
        }
        if (logManager == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(2);
        }
        this(runtimesCache, task, logManager, ComposeDeploymentRuntime.getComposeFiles(task));
    }

    public ComposeDeploymentRuntime(@NotNull DockerRuntimesCache runtimesCache, @NotNull DeploymentTask<DockerDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull List<File> composeFiles) throws ServerRuntimeException {
        if (runtimesCache == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(3);
        }
        if (task == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(4);
        }
        if (logManager == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(5);
        }
        if (composeFiles == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(6);
        }
        super(runtimesCache.getRuntimeContext(), ComposeDeploymentRuntime.computeApplicationId(composeFiles));
        this.myMergedComposeFiles = new LinkedHashSet();
        this.myMergedEnvironment = new LinkedHashMap<String, String>();
        this.myProject = task.getProject();
        this.myRuntimesCache = runtimesCache;
        this.myLogManager = logManager;
        this.myWorkingDirectory = ComposeDeploymentRuntime.computeWorkingDir(composeFiles);
        this.myComposeProjectName = ComposeDeploymentRuntime.computeErasedProjectName(this.myWorkingDirectory.getName());
        this.myNextDeployInfo = new NextDeployInfo((DockerDeploymentConfiguration)task.getConfiguration(), composeFiles);
        this.myMergedComposeFiles.addAll(composeFiles);
        this.myMergedEnvironment.putAll(ComposeDeploymentRuntime.getTaskEnvironment(task));
    }

    void appendDeploymentTask(@NotNull DeploymentTask<DockerDeploymentConfiguration> newDeploymentTask) throws ServerRuntimeException {
        List<File> newComposeFiles;
        File newWorkingDirectory;
        if (newDeploymentTask == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(7);
        }
        if ((newWorkingDirectory = ComposeDeploymentRuntime.computeWorkingDir(newComposeFiles = ComposeDeploymentRuntime.getComposeFiles(this.myProject, (DockerDeploymentConfiguration)newDeploymentTask.getConfiguration()))) == null || !FileUtil.filesEqual((File)newWorkingDirectory, (File)this.myWorkingDirectory)) {
            LOG.debug("Merging compose deployments from different folders: current work-dir: " + this.myWorkingDirectory + ", requested: " + newWorkingDirectory);
        }
        this.myNextDeployInfo = new NextDeployInfo((DockerDeploymentConfiguration)newDeploymentTask.getConfiguration(), newComposeFiles);
        this.myMergedComposeFiles.addAll(newComposeFiles);
        this.myMergedEnvironment.putAll(ComposeDeploymentRuntime.getTaskEnvironment(newDeploymentTask));
    }

    @Override
    @NotNull
    public String getComposeProjectName() {
        String string = this.myComposeProjectName;
        if (string == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String computeErasedProjectName(@NotNull String name) {
        if (name == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(9);
        }
        String string = StringUtil.toLowerCase((String)name.replaceAll("[^a-zA-Z0-9-_]+", ""));
        if (string == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public List<File> getComposeFiles() {
        ArrayList<File> arrayList = new ArrayList<File>(this.myMergedComposeFiles);
        if (arrayList == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected RemoteDockerRuntime getRuntimeHelper() throws ServerRuntimeException {
        RemoteDockerRuntime result = RemoteDockerRuntime.create(this.getServerConfiguration(), this.myProject);
        assert (result != null);
        RemoteDockerRuntime remoteDockerRuntime = result;
        if (remoteDockerRuntime == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(12);
        }
        return remoteDockerRuntime;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> executeCli(@NotNull AbstractDockerComposeCmdCliBuilder<?> cliBuilder) {
        if (cliBuilder == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(13);
        }
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        GeneralCommandLine cli = cliBuilder.buildCommandLine().withWorkDirectory(this.myWorkingDirectory).withEnvironment(this.myMergedEnvironment);
        try {
            ColoredProcessHandler processHandler = new ColoredProcessHandler(cli);
            this.myLogManager.getMainLoggingHandler().attachToProcess((ProcessHandler)processHandler);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    int exitCode;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((exitCode = event.getExitCode()) == 0) {
                        result.complete(null);
                    } else {
                        result.completeExceptionally(new CompletionException("`docker-compose` process finished with exit code " + exitCode, null));
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            processHandler.startNotify();
        }
        catch (ExecutionException e) {
            result.completeExceptionally(e);
        }
        CompletableFuture<Void> completableFuture = result;
        if (completableFuture == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(14);
        }
        return completableFuture;
    }

    public void deploy(ServerRuntimeInstance.DeploymentOperationCallback callback) {
        CompletableFuture<?> promise;
        try {
            promise = this.doDeploy();
        }
        catch (ServerRuntimeException e2) {
            callback.errorOccurred(e2.getMessage());
            return;
        }
        ((CompletableFuture)promise.thenRun(() -> callback.succeeded((DeploymentRuntime)this))).exceptionally(e -> {
            callback.errorOccurred(e.getMessage());
            return null;
        });
    }

    @NotNull
    private static List<File> getComposeFiles(@NotNull DeploymentTask<DockerDeploymentConfiguration> deploymentTask) {
        if (deploymentTask == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(15);
        }
        List<File> list = ComposeDeploymentRuntime.getComposeFiles(deploymentTask.getProject(), (DockerDeploymentConfiguration)deploymentTask.getConfiguration());
        if (list == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private static List<File> getComposeFiles(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) {
        if (project == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(17);
        }
        if (configuration == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(18);
        }
        LinkedList<String> paths = new LinkedList<String>();
        paths.add(configuration.getSourceFilePath());
        paths.addAll(configuration.getSecondarySourceFiles());
        List<File> list = paths.stream().filter(Objects::nonNull).map(path -> DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(project, path)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static String computeApplicationId(@NotNull List<File> composeFiles) throws ServerRuntimeException {
        if (composeFiles == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(20);
        }
        return "Docker-compose: " + ComposeDeploymentRuntime.computeWorkingDir(composeFiles).getName();
    }

    private static File computeWorkingDir(@NotNull List<File> composeFiles) throws ServerRuntimeException {
        if (composeFiles == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(21);
        }
        ComposeDeploymentRuntime.validateComposeFiles(composeFiles);
        return composeFiles.get(0).getParentFile();
    }

    private static void validateComposeFiles(@NotNull List<File> files) throws ServerRuntimeException {
        if (files == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(22);
        }
        if (files.isEmpty()) {
            throw new ServerRuntimeException("Compose file is not specified");
        }
        Optional<File> firstMissing = files.stream().filter(f -> !f.exists() || !f.isFile()).findFirst();
        if (firstMissing.isPresent()) {
            throw new ServerRuntimeException("Can't read compose file at " + firstMissing.get());
        }
    }

    private CompletableFuture<?> doDeploy() throws ServerRuntimeException {
        AbstractDockerComposeCmdCliBuilder cliBuilder = this.shouldRestartOnDeploy() ? DockerComposeCliUtil.buildRestartCommand(this.getRuntimeHelper()).withServices(this.myNextDeployInfo.getServices()) : DockerComposeCliUtil.buildUpCommand(this.getRuntimeHelper()).withDetached(true).withServices(this.myNextDeployInfo.getServices()).withForcedBuild(this.myNextDeployInfo.isForceBuild());
        cliBuilder.withFiles(this.myNextDeployInfo.getComposeFilePaths());
        return this.executeCli(cliBuilder);
    }

    private boolean shouldRestartOnDeploy() {
        String[] services = this.myNextDeployInfo.getServices();
        if (services.length != 1) {
            return false;
        }
        DockerRuntimesManagerService.DockerRuntimesManager manager = DockerRuntimesManagerService.getInstance().getActiveManager();
        if (manager == null) {
            return false;
        }
        return manager.findComposeServiceStatus(this.myComposeProjectName, services[0]) == DockerRuntimesManagerService.ComposeServiceStatus.DEPLOYED;
    }

    public CompletableFuture<?> down() throws ServerRuntimeException {
        RemoteDockerRuntime helper = this.getRuntimeHelper();
        DockerComposeDownCliBuilder cliBuilder = ((DockerComposeDownCliBuilder)DockerComposeCliUtil.buildDownCommand(helper).withFiles(this.getComposeFilePaths())).withRemoveOrphans();
        return this.executeCli(cliBuilder);
    }

    public CompletableFuture<?> stopAllServices() throws ServerRuntimeException {
        RemoteDockerRuntime helper = this.getRuntimeHelper();
        String[] allServices = this.getAllServiceNames();
        DockerComposeStopCliBuilder cliBuilder = ((DockerComposeStopCliBuilder)DockerComposeCliUtil.buildStopCommand(helper).withFiles(this.getComposeFilePaths())).withServices(allServices);
        return this.executeCli(cliBuilder);
    }

    @Override
    public String toString() {
        return "@" + Integer.toHexString(this.hashCode()) + " id: " + this.getApplicationName() + ", [APP][++]";
    }

    @Override
    public boolean isUndeploySupported() {
        return true;
    }

    @Override
    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        CompletableFuture<?> downPromise;
        if (callback == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(23);
        }
        try {
            downPromise = this.down();
        }
        catch (ServerRuntimeException e2) {
            callback.errorOccurred(e2.getMessage());
            return;
        }
        ((CompletableFuture)((CompletableFuture)downPromise.thenRun(() -> this.myRuntimesCache.composeApplicationUndeployed(this))).thenRun(() -> callback.succeeded())).exceptionally(e -> {
            callback.errorOccurred(e.getMessage());
            return null;
        });
    }

    @NotNull
    private static Map<String, String> getTaskEnvironment(@NotNull DeploymentTask<DockerDeploymentConfiguration> task) {
        if (task == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(24);
        }
        Map<String, String> map = ((DockerDeploymentConfiguration)task.getConfiguration()).getEnvVars().stream().filter(var -> !StringUtil.isEmptyOrSpaces((String)var.getName())).collect(Collectors.toMap(var -> StringUtil.trim((String)var.getName()), var -> StringUtil.trim((String)var.getValue()), (oldVal, newVal) -> newVal));
        if (map == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(25);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimesCache";
                break;
            }
            case 1: 
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 6: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDeploymentTask";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliBuilder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentTask";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeProjectName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeErasedProjectName";
                break;
            }
            case 11: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeHelper";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCli";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendDeploymentTask";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeErasedProjectName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeCli";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getComposeFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computeApplicationId";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeWorkingDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "validateComposeFiles";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "undeploy";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTaskEnvironment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NextDeployInfo {
        private final String[] myServices;
        private final boolean myIsForceBuild;
        private final List<File> myComposeFiles;

        NextDeployInfo(@NotNull DockerDeploymentConfiguration deployment, @NotNull List<File> composeFiles) {
            if (deployment == null) {
                NextDeployInfo.$$$reportNull$$$0(0);
            }
            if (composeFiles == null) {
                NextDeployInfo.$$$reportNull$$$0(1);
            }
            this.myIsForceBuild = DockerComposeDeploymentSourceType.getInstance().isForceBuild(deployment);
            this.myServices = ArrayUtilRt.toStringArray(deployment.getServices());
            this.myComposeFiles = new ArrayList<File>(composeFiles);
        }

        public List<Path> getComposeFilePaths() {
            return ContainerUtil.map(this.myComposeFiles, File::toPath);
        }

        public String[] getServices() {
            return this.myServices;
        }

        public boolean isForceBuild() {
            return this.myIsForceBuild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deployment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "composeFiles";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime$NextDeployInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

