/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeRunCliBuilder;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ui.EdtInvocationManager;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002JF\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/compose/DockerComposeIntegrationService;", "", "()V", "lock", "processed", "", "Lcom/intellij/docker/compose/DockerComposeIntegrationService$SharedVolumeKey;", "Ljava/util/concurrent/CountDownLatch;", "doPrePopulateSharedVolume", "", "dockerRuntime", "Lcom/intellij/docker/remote/run/runtime/RemoteDockerRuntime;", "configurationPaths", "", "Ljava/nio/file/Path;", "volume", "Lcom/intellij/docker/compose/service/commands/SharedVolume;", "envs", "", "", "executeCommandLine", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "progressText", "prePopulateSharedVolume", "configurationVersion", "Companion", "SharedVolumeKey", "intellij.clouds.docker"})
@ApiStatus.Experimental
public final class DockerComposeIntegrationService {
    private final Object lock = new Object();
    private final Map<SharedVolumeKey, CountDownLatch> processed = new HashMap();
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void prePopulateSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull List<? extends Path> configurationPaths, @NotNull String configurationVersion, @NotNull SharedVolume volume, @Nullable Map<String, String> envs) {
        void latch;
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
        Intrinsics.checkParameterIsNotNull(configurationPaths, (String)"configurationPaths");
        Intrinsics.checkParameterIsNotNull((Object)configurationVersion, (String)"configurationVersion");
        Intrinsics.checkParameterIsNotNull((Object)volume, (String)"volume");
        DockerComposeConfigurationV2 dockerComposeConfigurationV2 = ServiceCmdExecUtils.setupSharedService(configurationVersion, volume);
        Intrinsics.checkExpressionValueIsNotNull((Object)dockerComposeConfigurationV2, (String)"ServiceCmdExecUtils.setu\u2026igurationVersion, volume)");
        DockerComposeConfigurationV2 helpersConfiguration = dockerComposeConfigurationV2;
        File file2 = ServiceCmdExecUtils.writeDockerComposeOverrideYml(helpersConfiguration);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"ServiceCmdExecUtils.writ\u2026Yml(helpersConfiguration)");
        File helpersConfigurationFile = file2;
        String composeProjectName = DockerComposeConfigurationUtil.getEffectiveDockerComposeProjectName(configurationPaths, envs);
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Pair pair2;
            boolean bl3 = false;
            DockerCloudConfiguration dockerCloudConfiguration = dockerRuntime.getAccount();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dockerCloudConfiguration), (String)"dockerRuntime.account");
            String string = dockerCloudConfiguration.getApiUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dockerRuntime.account.apiUrl");
            SharedVolumeKey key = new SharedVolumeKey(string, composeProjectName, volume.getVolumeName());
            CountDownLatch latch2 = this.processed.get(key);
            if (latch2 == null) {
                CountDownLatch newLatch = new CountDownLatch(1);
                this.processed.put(key, newLatch);
                pair2 = TuplesKt.to((Object)newLatch, (Object)true);
            } else {
                pair2 = TuplesKt.to((Object)latch2, (Object)false);
            }
            pair = pair2;
        }
        Pair pair3 = pair;
        CountDownLatch countDownLatch = (CountDownLatch)pair3.component1();
        boolean startPopulate = (Boolean)pair3.component2();
        if (startPopulate) {
            try {
                this.doPrePopulateSharedVolume(dockerRuntime, CollectionsKt.plus((Collection)configurationPaths, (Iterable)CollectionsKt.listOf((Object)helpersConfigurationFile.toPath())), volume, envs);
            }
            finally {
                latch.countDown();
            }
        } else {
            latch.await();
        }
    }

    public static /* synthetic */ void prePopulateSharedVolume$default(DockerComposeIntegrationService dockerComposeIntegrationService, RemoteDockerRuntime remoteDockerRuntime, List list, String string, SharedVolume sharedVolume, Map map, int n, Object object) {
        if ((n & 0x10) != 0) {
            map = null;
        }
        dockerComposeIntegrationService.prePopulateSharedVolume(remoteDockerRuntime, list, string, sharedVolume, map);
    }

    @JvmOverloads
    public final void prePopulateSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull List<? extends Path> configurationPaths, @NotNull String configurationVersion, @NotNull SharedVolume volume) {
        DockerComposeIntegrationService.prePopulateSharedVolume$default(this, dockerRuntime, configurationPaths, configurationVersion, volume, null, 16, null);
    }

    private final void doPrePopulateSharedVolume(RemoteDockerRuntime dockerRuntime, List<? extends Path> configurationPaths, SharedVolume volume, Map<String, String> envs) {
        LOG.info("Populate shared volume " + volume.getVolumeName());
        GeneralCommandLine commandLine = ((DockerComposeRunCliBuilder)((DockerComposeRunCliBuilder)DockerComposeCliUtil.buildRunCommand(dockerRuntime).withFiles(configurationPaths)).withRemove(true).withService(volume.getServiceName()).withEnvironment(envs)).buildCommandLine();
        String progressText = "Updating " + volume.getVolumeName() + " Volume";
        EdtInvocationManager edtInvocationManager = EdtInvocationManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)edtInvocationManager, (String)"EdtInvocationManager.getInstance()");
        if (edtInvocationManager.isEventDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, commandLine, progressText){
                final /* synthetic */ DockerComposeIntegrationService this$0;
                final /* synthetic */ GeneralCommandLine $commandLine;
                final /* synthetic */ String $progressText;

                public final void run() {
                    DockerComposeIntegrationService.access$executeCommandLine(this.this$0, this.$commandLine, this.$progressText);
                }
                {
                    this.this$0 = dockerComposeIntegrationService;
                    this.$commandLine = generalCommandLine;
                    this.$progressText = string;
                }
            }, progressText, true, null);
        } else {
            this.executeCommandLine(commandLine, progressText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeCommandLine(GeneralCommandLine commandLine, String progressText) {
        ProgressIndicator progressIndicator;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator2 = progressIndicator = progressManager.getProgressIndicator();
        if (progressIndicator2 != null) {
            progressIndicator2.pushState();
        }
        try {
            String string = commandLine.getCommandLineString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commandLine.commandLineString");
            String commandLineString = string;
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText(progressText);
            }
            KillableProcessHandler processHandler = new KillableProcessHandler(commandLine);
            processHandler.startNotify();
            boolean processFinished = processHandler.waitFor();
            if (!processFinished) {
                LOG.warn("Populating shared volume with using command " + commandLineString + " cancelled");
            } else {
                Integer exitCode;
                Integer n = exitCode = processHandler.getExitCode();
                if (n == null || n != 0) {
                    LOG.warn("Populating shared volume with using command " + commandLineString + " returned " + exitCode + " exit code");
                }
            }
        }
        finally {
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 != null) {
                progressIndicator4.popState();
            }
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DockerComposeIntegrationService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Docke\u2026ationService::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$executeCommandLine(DockerComposeIntegrationService $this, GeneralCommandLine commandLine, String progressText) {
        $this.executeCommandLine(commandLine, progressText);
    }

    @JvmStatic
    @NotNull
    public static final DockerComposeIntegrationService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/compose/DockerComposeIntegrationService$SharedVolumeKey;", "", "account", "", "composeProjectName", "volumeName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccount", "()Ljava/lang/String;", "getComposeProjectName", "getVolumeName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.docker"})
    private static final class SharedVolumeKey {
        @NotNull
        private final String account;
        @Nullable
        private final String composeProjectName;
        @NotNull
        private final String volumeName;

        @NotNull
        public final String getAccount() {
            return this.account;
        }

        @Nullable
        public final String getComposeProjectName() {
            return this.composeProjectName;
        }

        @NotNull
        public final String getVolumeName() {
            return this.volumeName;
        }

        public SharedVolumeKey(@NotNull String account, @Nullable String composeProjectName, @NotNull String volumeName) {
            Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
            Intrinsics.checkParameterIsNotNull((Object)volumeName, (String)"volumeName");
            this.account = account;
            this.composeProjectName = composeProjectName;
            this.volumeName = volumeName;
        }

        @NotNull
        public final String component1() {
            return this.account;
        }

        @Nullable
        public final String component2() {
            return this.composeProjectName;
        }

        @NotNull
        public final String component3() {
            return this.volumeName;
        }

        @NotNull
        public final SharedVolumeKey copy(@NotNull String account, @Nullable String composeProjectName, @NotNull String volumeName) {
            Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
            Intrinsics.checkParameterIsNotNull((Object)volumeName, (String)"volumeName");
            return new SharedVolumeKey(account, composeProjectName, volumeName);
        }

        public static /* synthetic */ SharedVolumeKey copy$default(SharedVolumeKey sharedVolumeKey, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = sharedVolumeKey.account;
            }
            if ((n & 2) != 0) {
                string2 = sharedVolumeKey.composeProjectName;
            }
            if ((n & 4) != 0) {
                string3 = sharedVolumeKey.volumeName;
            }
            return sharedVolumeKey.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SharedVolumeKey(account=" + this.account + ", composeProjectName=" + this.composeProjectName + ", volumeName=" + this.volumeName + ")";
        }

        public int hashCode() {
            String string = this.account;
            String string2 = this.composeProjectName;
            String string3 = this.volumeName;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SharedVolumeKey)) break block3;
                    SharedVolumeKey sharedVolumeKey = (SharedVolumeKey)object;
                    if (!Intrinsics.areEqual((Object)this.account, (Object)sharedVolumeKey.account) || !Intrinsics.areEqual((Object)this.composeProjectName, (Object)sharedVolumeKey.composeProjectName) || !Intrinsics.areEqual((Object)this.volumeName, (Object)sharedVolumeKey.volumeName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/compose/DockerComposeIntegrationService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/docker/compose/DockerComposeIntegrationService;", "intellij.clouds.docker"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DockerComposeIntegrationService getInstance() {
            boolean $i$f$service = false;
            Object object = ServiceManager.getService(DockerComposeIntegrationService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (DockerComposeIntegrationService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

