/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.DockerActionUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class InspectDockerAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InspectDockerAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        DockerApplicationRuntime runtime = (DockerApplicationRuntime)((Object)ApplicationActionUtils.getApplicationRuntime((AnActionEvent)e, DockerApplicationRuntime.class));
        if (DockerActionUtils.isImageRuntime(runtime)) {
            presentation.setEnabledAndVisible(true);
            presentation.setDescription(DockerBundle.getText("InspectDockerAction.description.image", new Object[0]));
        } else if (DockerActionUtils.isContainerRuntime(runtime)) {
            presentation.setEnabledAndVisible(true);
            presentation.setDescription(DockerBundle.getText("InspectDockerAction.description.container", new Object[0]));
        } else {
            presentation.setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DockerActionUtils.LoggingActionHelper helper;
        if (e == null) {
            InspectDockerAction.$$$reportNull$$$0(1);
        }
        if ((helper = DockerActionUtils.getLoggingActionHelper(e)) == null) {
            return;
        }
        ((CompletableFuture)helper.applicationRuntime.promiseInspectJson().thenAccept(json -> new ShowAsLogConsumer(helper.project, helper.applicationRuntime).showAsLog((String)json, "Inspection"))).thenRun(helper.createLogSelector("Inspection"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/docker/action/InspectDockerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ShowAsLogConsumer {
        private final Project myProject;
        private final DeploymentLogManagerImpl myLogManager;

        ShowAsLogConsumer(@NotNull Project project, @NotNull DockerApplicationRuntime runtime) {
            if (project == null) {
                ShowAsLogConsumer.$$$reportNull$$$0(0);
            }
            if (runtime == null) {
                ShowAsLogConsumer.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myLogManager = (DeploymentLogManagerImpl)runtime.getDeploymentLogManager(project);
            assert (this.myLogManager != null) : "Missing deployment: " + (Object)((Object)runtime) + ": [" + runtime.getImageId() + ", " + runtime.getContainerId() + "]";
        }

        void showAsLog(String preparedText, String logPresentableName) {
            if (this.myProject.isDisposed()) {
                return;
            }
            LoggingHandler handler = this.myLogManager.findOrCreateAdditionalLog(logPresentableName);
            handler.clear();
            handler.print(preparedText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runtime";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/action/InspectDockerAction$ShowAsLogConsumer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

