/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.machine.DockerMachineUtil;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DockerSettings", storages={@Storage(value="docker.xml")})
public class DockerSettings
implements PersistentStateComponent<State> {
    public static final String DEFAULT_DOCKER_EXECUTABLE = "docker";
    private static final String DEFAULT_DOCKER_EXECUTABLE_ON_MAC_OS_X = "/usr/local/bin/docker";
    private static final String DEFAULT_DOCKER_COMPOSE_EXECUTABLE = "docker-compose";
    private static final String DEFAULT_DOCKER_COMPOSE_EXECUTABLE_ON_MAC_OS_X = "/usr/local/bin/docker-compose";
    private String myDockerMachinePath;
    private String myDockerComposePath;
    private String myDockerPath;

    @NotNull
    public static DockerSettings getInstance() {
        DockerSettings dockerSettings = (DockerSettings)ServiceManager.getService(DockerSettings.class);
        if (dockerSettings == null) {
            DockerSettings.$$$reportNull$$$0(0);
        }
        return dockerSettings;
    }

    @Nullable
    public State getState() {
        State state = new State();
        state.setDockerComposePath(this.myDockerComposePath);
        state.setDockerMachinePath(this.myDockerMachinePath);
        state.setDockerPath(this.myDockerPath);
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            DockerSettings.$$$reportNull$$$0(1);
        }
        this.setDockerMachinePath(state.getDockerMachinePath());
        this.setDockerComposePath(state.getDockerComposePath());
        this.setDockerPath(state.getDockerPath());
    }

    @NotNull
    public String getDockerMachinePath() {
        if (this.myDockerMachinePath == null) {
            this.myDockerMachinePath = DockerMachineUtil.tryFindDockerMachineExecutable().orElse(DockerMachineUtil.getDefaultDockerMachineExecutable());
        }
        String string = this.myDockerMachinePath;
        if (string == null) {
            DockerSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setDockerMachinePath(String dockerMachinePath) {
        this.myDockerMachinePath = dockerMachinePath;
    }

    @NotNull
    public String getDockerComposePath() {
        if (this.myDockerComposePath == null) {
            File foundInPath;
            this.myDockerComposePath = SystemInfo.isMac ? DEFAULT_DOCKER_COMPOSE_EXECUTABLE_ON_MAC_OS_X : ((foundInPath = PathEnvironmentVariableUtil.findInPath((String)DEFAULT_DOCKER_COMPOSE_EXECUTABLE)) != null ? foundInPath.getAbsolutePath() : DEFAULT_DOCKER_COMPOSE_EXECUTABLE);
        }
        String string = this.myDockerComposePath;
        if (string == null) {
            DockerSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getDockerPath() {
        if (this.myDockerPath == null) {
            File foundInPath;
            this.myDockerPath = SystemInfo.isMac ? DEFAULT_DOCKER_EXECUTABLE_ON_MAC_OS_X : ((foundInPath = PathEnvironmentVariableUtil.findInPath((String)DEFAULT_DOCKER_EXECUTABLE)) != null ? foundInPath.getAbsolutePath() : DEFAULT_DOCKER_EXECUTABLE);
        }
        String string = this.myDockerPath;
        if (string == null) {
            DockerSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setDockerComposePath(String dockerComposePath) {
        this.myDockerComposePath = dockerComposePath;
    }

    public void setDockerPath(String dockerPath) {
        this.myDockerPath = dockerPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerMachinePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class State {
        private String myDockerMachinePath;
        private String myDockerComposePath;
        private String myDockerPath;

        State() {
        }

        public String getDockerPath() {
            return this.myDockerPath;
        }

        void setDockerPath(String dockerPath) {
            this.myDockerPath = dockerPath;
        }

        public String getDockerMachinePath() {
            return this.myDockerMachinePath;
        }

        public void setDockerComposePath(String dockerComposePath) {
            this.myDockerComposePath = dockerComposePath;
        }

        public String getDockerComposePath() {
            return this.myDockerComposePath;
        }

        public void setDockerMachinePath(String dockerMachinePath) {
            this.myDockerMachinePath = dockerMachinePath;
        }
    }
}

