/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.run.HttpClientExecutionController;
import com.intellij.ws.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.ws.http.request.run.HttpRunRequestInfo;
import com.intellij.ws.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.ws.http.request.run.console.HttpResponseConsole;
import com.intellij.ws.http.request.run.console.HttpResponsePresentation;
import com.intellij.ws.http.request.run.console.HttpSingleResponseConsole;
import com.intellij.ws.http.request.run.test.HttpMultiResponseConsole;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunHttpRequestProfileState
implements RunProfileState {
    private final Project myProject;
    private final HttpRequestExecutionConfig myConfig;
    private final SMTRunnerConsoleProperties myProperties;
    private final HttpRequestVariableSubstitutor mySubstitutor;

    public RunHttpRequestProfileState(@NotNull Project project, @NotNull HttpRequestExecutionConfig config, @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(0);
        }
        if (config == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myConfig = config;
        this.myProperties = properties;
        this.mySubstitutor = substitutor;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(4);
        }
        List<HttpRequest> requests = this.myConfig.getRequests();
        boolean hasResponseHandler = requests.stream().anyMatch(request -> request.getResponseHandler() != null);
        HttpClientRequestProcessHandler processHandler = new HttpClientRequestProcessHandler(hasResponseHandler);
        ArrayList<HttpRunRequestInfo> infos = new ArrayList<HttpRunRequestInfo>();
        for (HttpRequest psiRequest : requests) {
            infos.add(HttpRunRequestInfo.create(psiRequest, this.mySubstitutor));
        }
        final HttpResponseConsole console = this.createConsole(processHandler, infos);
        FileDocumentManager.getInstance().saveAllDocuments();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((exitCode = event.getExitCode()) != 0) {
                    String message = exitCode == 1 ? RestClientBundle.message("rest.client.request.execute.cancel", new Object[0]) : RestClientBundle.message("rest.client.request.execute.cancel.post.process", new Object[0]);
                    console.setErrorResponse(null, HttpResponsePresentation.createErrorResponse(message));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ws/http/request/run/RunHttpRequestProfileState$1", "processTerminated"));
            }
        });
        this.executeHttpRequest(this.myProject, infos.iterator(), processHandler, console, infos.size() == 1);
        return new DefaultExecutionResult((ExecutionConsole)console.getConsole(), (ProcessHandler)processHandler);
    }

    @NotNull
    private HttpResponseConsole createConsole(@NotNull HttpClientRequestProcessHandler processHandler, @NotNull List<HttpRunRequestInfo> requests) throws ExecutionException {
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(5);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(6);
        }
        if (requests.isEmpty()) {
            throw new ExecutionException("No Requests to Execute");
        }
        if (requests.size() == 1) {
            HttpRunRequestInfo info = requests.get(0);
            RestClientRequest request = info.getRequest();
            String target = request.httpMethod + " " + request.toString() + "\n\n";
            boolean withPostProcessor = info.getResponseHandler() != null;
            HttpSingleResponseConsole httpSingleResponseConsole = new HttpSingleResponseConsole(this.myProject, target, this.myProperties, processHandler, withPostProcessor);
            if (httpSingleResponseConsole == null) {
                RunHttpRequestProfileState.$$$reportNull$$$0(7);
            }
            return httpSingleResponseConsole;
        }
        HttpMultiResponseConsole httpMultiResponseConsole = new HttpMultiResponseConsole(this.myProject, this.myProperties, processHandler);
        if (httpMultiResponseConsole == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(8);
        }
        return httpMultiResponseConsole;
    }

    private void executeHttpRequest(@NotNull Project project, @NotNull Iterator<HttpRunRequestInfo> requests, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console, boolean showResponseInplace) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(9);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(10);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(11);
        }
        if (console == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(12);
        }
        if (!requests.hasNext()) {
            return;
        }
        Runnable onRequestFinished = this.createOnFinished(project, console, processHandler, requests, showResponseInplace);
        HttpClientExecutionController.create(project, requests.next(), processHandler, console, onRequestFinished, showResponseInplace).execute();
    }

    @NotNull
    private Runnable createOnFinished(@NotNull Project project, @NotNull HttpResponseConsole console, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull Iterator<HttpRunRequestInfo> requests, boolean showResponseInplace) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(13);
        }
        if (console == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(14);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(15);
        }
        if (requests == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(16);
        }
        Runnable runnable = () -> {
            if (requests.hasNext()) {
                this.executeHttpRequest(project, requests, processHandler, console, showResponseInplace);
            } else {
                processHandler.onRunFinished();
            }
        };
        if (runnable == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(17);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestProfileState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createOnFinished";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 7: 
            case 8: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeHttpRequest";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createOnFinished";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

