/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.documentation.comments;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ws.http.request.documentation.comments.HttpDocElementType;
import com.intellij.ws.http.request.documentation.comments.psi.impl.HttpDocNoCookieJarTagImpl;
import com.intellij.ws.http.request.documentation.comments.psi.impl.HttpDocNoLogResponseTagImpl;
import com.intellij.ws.http.request.documentation.comments.psi.impl.HttpDocNoRedirectTagImpl;
import com.intellij.ws.http.request.documentation.comments.psi.impl.HttpDocUnknownTagImpl;
import com.intellij.ws.http.request.psi.HttpRequestTokenType;

public interface HttpDocCommentElementTypes {
    public static final IElementType COMMENT_TAG = new HttpDocElementType("COMMENT_TAG");
    public static final IElementType NO_COOKIE_JAR_TAG = new HttpDocElementType("NO_COOKIE_JAR_TAG");
    public static final IElementType NO_LOG_RESPONSE_TAG = new HttpDocElementType("NO_LOG_RESPONSE_TAG");
    public static final IElementType NO_REDIRECT_TAG = new HttpDocElementType("NO_REDIRECT_TAG");
    public static final IElementType UNKNOWN_TAG = new HttpDocElementType("UNKNOWN_TAG");
    public static final IElementType COMMENT_START = new HttpRequestTokenType("COMMENT_START");
    public static final IElementType COMMENT_TEXT = new HttpRequestTokenType("COMMENT_TEXT");
    public static final IElementType NO_COOKIE_JAR = new HttpRequestTokenType("NO_COOKIE_JAR");
    public static final IElementType NO_LOG_RESPONSE = new HttpRequestTokenType("NO_LOG_RESPONSE");
    public static final IElementType NO_REDIRECT = new HttpRequestTokenType("NO_REDIRECT");
    public static final IElementType UNKNOWN = new HttpRequestTokenType("UNKNOWN");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == NO_COOKIE_JAR_TAG) {
                return new HttpDocNoCookieJarTagImpl(node);
            }
            if (type == NO_LOG_RESPONSE_TAG) {
                return new HttpDocNoLogResponseTagImpl(node);
            }
            if (type == NO_REDIRECT_TAG) {
                return new HttpDocNoRedirectTagImpl(node);
            }
            if (type == UNKNOWN_TAG) {
                return new HttpDocUnknownTagImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

