/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.cookies.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ws.http.request.cookies.psi.CookieElementType;
import com.intellij.ws.http.request.cookies.psi.CookieTokenType;
import com.intellij.ws.http.request.cookies.psi.impl.CookieDateImpl;
import com.intellij.ws.http.request.cookies.psi.impl.CookieDomainImpl;
import com.intellij.ws.http.request.cookies.psi.impl.CookieNameImpl;
import com.intellij.ws.http.request.cookies.psi.impl.CookiePathImpl;
import com.intellij.ws.http.request.cookies.psi.impl.CookieRecordImpl;
import com.intellij.ws.http.request.cookies.psi.impl.CookieValueImpl;
import com.intellij.ws.http.request.cookies.psi.impl.MalformedCookieImpl;
import com.intellij.ws.http.request.cookies.psi.impl.RecordRestImpl;

public interface CookieElementTypes {
    public static final IElementType COOKIE_DATE = new CookieElementType("COOKIE_DATE");
    public static final IElementType COOKIE_DOMAIN = new CookieElementType("COOKIE_DOMAIN");
    public static final IElementType COOKIE_NAME = new CookieElementType("COOKIE_NAME");
    public static final IElementType COOKIE_PATH = new CookieElementType("COOKIE_PATH");
    public static final IElementType COOKIE_RECORD = new CookieElementType("COOKIE_RECORD");
    public static final IElementType COOKIE_VALUE = new CookieElementType("COOKIE_VALUE");
    public static final IElementType MALFORMED_COOKIE = new CookieElementType("MALFORMED_COOKIE");
    public static final IElementType RECORD_REST = new CookieElementType("RECORD_REST");
    public static final IElementType COMMENT = new CookieTokenType("COMMENT");
    public static final IElementType COOKIE_TOKEN = new CookieTokenType("COOKIE_TOKEN");
    public static final IElementType NEW_LINE = new CookieTokenType("NEW_LINE");
    public static final IElementType SEPARATOR = new CookieTokenType("SEPARATOR");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == COOKIE_DATE) {
                return new CookieDateImpl(node);
            }
            if (type == COOKIE_DOMAIN) {
                return new CookieDomainImpl(node);
            }
            if (type == COOKIE_NAME) {
                return new CookieNameImpl(node);
            }
            if (type == COOKIE_PATH) {
                return new CookiePathImpl(node);
            }
            if (type == COOKIE_RECORD) {
                return new CookieRecordImpl(node);
            }
            if (type == COOKIE_VALUE) {
                return new CookieValueImpl(node);
            }
            if (type == MALFORMED_COOKIE) {
                return new MalformedCookieImpl(node);
            }
            if (type == RECORD_REST) {
                return new RecordRestImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

