/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor.gutter;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCellMarker;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterTypes;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"createCellMarkerTextRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "isCellMarker", "", "isCodeMarker", "intellij.python.jupyter"})
public final class JupyterCellLineMarkerProviderKt {
    public static final boolean isCellMarker(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return element instanceof JupyterCellMarker;
    }

    public static final boolean isCodeMarker(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psiElement = element.getFirstChild();
        if (!(psiElement instanceof LeafPsiElement)) {
            psiElement = null;
        }
        LeafPsiElement leafPsiElement = (LeafPsiElement)psiElement;
        return Intrinsics.areEqual((Object)(leafPsiElement != null ? leafPsiElement.getElementType() : null), (Object)JupyterTypes.CODE_MARKER);
    }

    @NotNull
    public static final TextRange createCellMarkerTextRange(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        TextRange textRange = element.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
        int n = textRange.getStartOffset();
        TextRange textRange2 = element.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"element.textRange");
        return new TextRange(n, textRange2.getEndOffset() - 1);
    }
}

